/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class SQLToJUnit {
    private static final int DEFAULT_LEFT_MARGIN = 8;
    private static String leftMargin;
    private static final String IJ_COMMENT = "--";
    private static final String IJ_WARNING = "ij warning";
    private static final String JAVA_COMMENT = "//";
    private static final String RS_META_OBJECT_NAME = "rsmd";
    private static final String RS_OBJECT_NAME = "rs";
    private static final String CSTMT_OBJECT_NAME = "cSt";
    private static final String PSTMT_OBJECT_NAME = "pSt";
    private static final String SQL_WARN_OBJECT_NAME = "sqlWarn";
    private static String IJ_PROMPT;
    private static String CONN_OBJECT_NAME;
    private static String STMT_OBJECT_NAME;
    private static String USER_NAME;
    private static String getWarningLogic;
    private static final String[] DDL_NO_RC_COMMANDS;
    private static final String[] DDL_RC_COMMANDS;
    private static final String[] QUERY_COMMANDS;
    private static final String[] IJ_COMMANDS;
    private static int EXEC_QUERY;
    private static int EXEC_DDL_NO_ROW_COUNT;
    private static int EXEC_DDL_WITH_ROW_COUNT;
    private static int PREPARE;
    private static int P_EXECUTE;
    private static int CALL_STMT;
    private static int COMMENT;
    private static int AUTOCOMMIT;
    private static int COMMIT;
    private static int ROLLBACK;
    private static int SET_SCHEMA;
    private static int REMOVE;
    private static int GRANT;
    private static int GET_CURSOR;
    private static int CURSOR_NEXT;
    private static int CURSOR_CLOSE;
    private static int CONNECT;
    private static int SET_CONNECTION;
    private static int REVOKE;
    private static int IJ_COMMAND;
    private static int ROW_COUNT;
    private static int BLANK_LINE;
    private static int SQL_ERROR;
    private static int SQL_WARNING;
    private static int IWARNING;
    private static int UNKNOWN_LINE;
    private static int LINE_LENGTH;
    private int prevLineType;
    private String jTestName;
    private BufferedReader ijScript;
    private BufferedWriter junit;
    private StringBuffer tmpBuf;
    private boolean gotRuntimeStatistics = false;
    private int numIgnored = 0;
    private int numUnconverted = 0;
    private boolean multipleUserConnections = false;
    private Properties userConnections = new Properties();
    private int usersConnected;
    private int anonymousCount = 0;

    public static void main(String[] stringArray) {
        try {
            new SQLToJUnit().convert(stringArray);
        }
        catch (Exception exception) {
            System.out.println("OOPS, top-level error:");
            exception.printStackTrace();
        }
    }

    public void convert(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("\n  Usage:  java SQLToJUnit <embedded_sql_out_file>\n");
            return;
        }
        if (!this.loadIJScript(stringArray[0])) {
            return;
        }
        this.writePrologue();
        this.tmpBuf = new StringBuffer();
        try {
            int n;
            leftMargin = "";
            for (n = 0; n < 8; ++n) {
                leftMargin = leftMargin + " ";
            }
            this.writeJUnitEOL();
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            while (!bl && this.getNextIjCommand(stringBuffer3)) {
                n = this.getLineType(stringBuffer3);
                if (n == SET_CONNECTION) {
                    CONN_OBJECT_NAME = stringBuffer3.substring(stringBuffer3.indexOf("set connection ") + 15, stringBuffer3.length());
                    STMT_OBJECT_NAME = "st_" + CONN_OBJECT_NAME;
                    IJ_PROMPT = "ij(" + CONN_OBJECT_NAME.toUpperCase() + ")>";
                    USER_NAME = this.userConnections.getProperty(CONN_OBJECT_NAME);
                    this.junit.write("// set connection " + CONN_OBJECT_NAME);
                    this.writeJUnitEOL();
                }
                while (this.ignorableLine(n)) {
                    if (n != BLANK_LINE) {
                        this.junit.write("[**:: IGNORED ::**] ");
                        this.junit.write(stringBuffer3.toString().trim());
                        this.writeJUnitEOL();
                        this.writeJUnitEOL();
                        ++this.numIgnored;
                    }
                    stringBuffer3.delete(0, stringBuffer3.length());
                    if (!this.getNextIjCommand(stringBuffer3)) {
                        bl = true;
                        break;
                    }
                    n = this.getLineType(stringBuffer3);
                }
                boolean bl2 = true;
                if (n == COMMENT) {
                    if (this.prevLineType == COMMENT) {
                        stringBuffer2.append(this.strip(stringBuffer3, IJ_COMMENT));
                        bl2 = false;
                    } else {
                        stringBuffer2.append(stringBuffer3.toString().trim());
                        boolean bl3 = bl2 = stringBuffer.length() > 0;
                    }
                }
                if (bl2 && (n != SQL_ERROR || this.prevLineType != SQL_ERROR)) {
                    if (n != COMMENT) {
                        stringBuffer2.append(stringBuffer3);
                    }
                    this.writeJavaLine(stringBuffer, stringBuffer2);
                    if (stringBuffer2.length() == 0) {
                        this.writeJUnitEOL();
                    }
                }
                this.prevLineType = n;
                stringBuffer3.delete(0, stringBuffer3.length());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            if (stringBuffer.length() > 0) {
                this.writeJavaLine(stringBuffer, stringBuffer2);
            }
            this.writeJUnitEOL();
            this.junit.write("getConnection().rollback();");
            this.writeJUnitEOL();
            this.junit.write("st.close();");
            this.junit.write("\n    }\n}");
            System.out.println("\n  ==> Ignored " + this.numIgnored + " lines and left " + this.numUnconverted + " lines unconverted.\n  ==> Output is in '" + this.jTestName + ".junit'.\n\n");
            if (this.multipleUserConnections) {
                System.out.print("Found multiple users: ");
                Enumeration<Object> enumeration = this.userConnections.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print("\"");
                    System.out.print(enumeration.nextElement());
                    System.out.print("\"");
                    System.out.print(enumeration.hasMoreElements() ? ", " : "");
                }
            }
            System.out.println("\n\nDone.\n");
            this.junit.flush();
        }
        catch (Exception exception) {
            if (this.junit != null) {
                this.junit.flush();
            }
            throw exception;
        }
    }

    private boolean loadIJScript(String string) throws Exception {
        try {
            this.ijScript = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            this.jTestName = string.endsWith(".out") ? string.substring(0, string.indexOf(".")) : string;
            this.jTestName = this.jTestName.replaceAll("[.]", "_");
            this.junit = new BufferedWriter(new FileWriter(this.jTestName + ".junit"));
        }
        catch (IOException iOException) {
            System.out.println("-=- Could not find IJ master: '" + string + "'");
            return false;
        }
        return true;
    }

    private void writeJavaLine(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Exception {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return;
        }
        boolean bl = true;
        this.strip(stringBuffer, IJ_PROMPT);
        if (this.prevLineType == COMMENT) {
            this.strip(stringBuffer, IJ_COMMENT);
            this.junit.write(JAVA_COMMENT);
            this.writeMaxLenLine(stringBuffer, "// ", null);
            this.writeJUnitEOL();
        } else if (this.prevLineType == IJ_COMMAND) {
            this.junit.write("[**:: UNCONVERTED ::**] ");
            this.junit.write(stringBuffer.toString());
            this.writeJUnitEOL();
            ++this.numUnconverted;
        } else if (this.prevLineType >= 0) {
            this.writeJDBCCode(stringBuffer, stringBuffer2);
        } else if (this.prevLineType == SQL_WARNING) {
            this.writeAssertWarning(stringBuffer);
            this.writeJUnitEOL();
        } else {
            String string = stringBuffer.toString();
            if (string.trim().length() > 0) {
                this.junit.write("[**:: UNCONVERTED ::**] ");
                this.junit.write(string);
                this.writeJUnitEOL();
                ++this.numUnconverted;
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.writeJUnitEOL();
        }
        stringBuffer.delete(0, stringBuffer.length());
    }

    private void writeJDBCCode(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Exception {
        int n = this.getLineType(stringBuffer2);
        boolean bl = n != SQL_ERROR;
        String string = "";
        if (!bl) {
            string = "    ";
        }
        if (this.prevLineType == EXEC_QUERY) {
            if (bl) {
                this.junit.write("rs = ");
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(".executeQuery(");
                this.writeJUnitEOL();
                this.writeQuotedLine(stringBuffer, string);
                this.writeJUnitEOL();
                this.writeAssertResultSet(stringBuffer2);
            } else {
                this.writeFailStatement(stringBuffer, null, stringBuffer2, false);
            }
        } else if (this.prevLineType == EXEC_DDL_WITH_ROW_COUNT || this.prevLineType == EXEC_DDL_NO_ROW_COUNT) {
            if (bl) {
                if (n == ROW_COUNT && this.prevLineType == EXEC_DDL_WITH_ROW_COUNT) {
                    this.writeAssertDDLCount(stringBuffer, stringBuffer2, STMT_OBJECT_NAME);
                } else {
                    this.junit.write(STMT_OBJECT_NAME);
                    this.junit.write(".executeUpdate(");
                    this.writeJUnitEOL();
                    this.writeQuotedLine(stringBuffer, string);
                    stringBuffer2.delete(0, stringBuffer2.length());
                }
            } else {
                this.writeFailStatement(stringBuffer, null, stringBuffer2, false);
            }
        } else if (this.prevLineType == PREPARE) {
            stringBuffer.delete(0, stringBuffer.indexOf("'") + 1);
            stringBuffer.delete(stringBuffer.lastIndexOf("'"), stringBuffer.length());
            if (bl) {
                this.junit.write(string);
                this.junit.write(PSTMT_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write("prepareStatement(");
                this.writeJUnitEOL();
                this.writeQuotedLine(stringBuffer, string);
                this.writeJUnitEOL();
            } else {
                this.writeFailStatement(stringBuffer, null, stringBuffer2, true);
            }
        } else if (this.prevLineType == P_EXECUTE) {
            if (stringBuffer.indexOf("'") != -1) {
                stringBuffer.delete(0, stringBuffer.indexOf("'") + 1);
                stringBuffer.delete(stringBuffer.lastIndexOf("'"), stringBuffer.length());
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(".executeQuery(");
                this.writeJUnitEOL();
                this.collapseQuotes(stringBuffer, '\'');
                this.writeQuotedLine(stringBuffer, string);
                this.writeJUnitEOL();
                this.writeJUnitEOL();
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(".next();");
                this.writeJUnitEOL();
                this.junit.write(RS_META_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(".getMetaData();");
                this.writeJUnitEOL();
                this.junit.write("for (int i = 1; i <= ");
                this.junit.write(RS_META_OBJECT_NAME);
                this.junit.write(".getColumnCount(); i++)");
                this.writeJUnitEOL();
                this.junit.write("    ");
                this.junit.write(PSTMT_OBJECT_NAME);
                this.junit.write(".setObject(i, ");
                this.junit.write(RS_OBJECT_NAME);
                this.junit.write(".getObject(i));");
                this.writeJUnitEOL();
                this.writeJUnitEOL();
            }
            if (bl) {
                if (n == ROW_COUNT) {
                    this.writeAssertDDLCount(null, stringBuffer2, PSTMT_OBJECT_NAME);
                } else {
                    this.junit.write("rs = ");
                    this.junit.write(PSTMT_OBJECT_NAME);
                    this.junit.write(".executeQuery();");
                    this.writeAssertResultSet(stringBuffer2);
                }
            } else {
                this.writeFailStatement(null, PSTMT_OBJECT_NAME, stringBuffer2, false);
            }
        } else if (this.prevLineType == CALL_STMT) {
            this.junit.write(CSTMT_OBJECT_NAME);
            this.junit.write(" = prepareCall(");
            this.writeJUnitEOL();
            this.writeQuotedLine(stringBuffer, "");
            if (bl) {
                this.writeJUnitEOL();
                this.writeAssertDDLCount(null, stringBuffer2, CSTMT_OBJECT_NAME);
            } else {
                this.writeJUnitEOL();
                this.writeFailStatement(null, CSTMT_OBJECT_NAME, stringBuffer2, false);
            }
        } else if (this.prevLineType == AUTOCOMMIT) {
            this.junit.write(CONN_OBJECT_NAME + ".setAutoCommit(");
            this.junit.write(stringBuffer.indexOf(" off") == -1 ? "true" : "false");
            this.junit.write(");");
            this.writeJUnitEOL();
        } else if (this.prevLineType == COMMIT) {
            this.junit.write(CONN_OBJECT_NAME + ".commit();");
        } else if (this.prevLineType == ROLLBACK) {
            this.junit.write(CONN_OBJECT_NAME + ".rollback();");
            this.writeJUnitEOL();
        } else if (this.prevLineType == GET_CURSOR) {
            this.writeGetCursor(stringBuffer, string);
        } else if (this.prevLineType == CURSOR_NEXT) {
            this.junit.write(stringBuffer.substring(stringBuffer.lastIndexOf(" ") + 1));
            this.junit.write(".next();");
            this.writeJUnitEOL();
        } else if (this.prevLineType == CURSOR_CLOSE) {
            String string2 = stringBuffer.substring(stringBuffer.lastIndexOf(" ") + 1).trim();
            this.junit.write(string2);
            this.junit.write(".close();");
            this.writeJUnitEOL();
            this.junit.write("ps_");
            this.junit.write(string2);
            this.junit.write(".close();");
            this.writeJUnitEOL();
        } else if (this.prevLineType == CONNECT) {
            this.multipleUserConnections = true;
            int n2 = 0;
            boolean bl2 = false;
            if (stringBuffer.indexOf("user=") > 0) {
                n2 = stringBuffer.indexOf("user=") + 4;
                if (stringBuffer.indexOf(" as ") < 0) {
                    bl2 = true;
                }
            } else {
                n2 = stringBuffer.indexOf("'", stringBuffer.indexOf("user") + 1);
            }
            if (bl2) {
                CONN_OBJECT_NAME = "CONNECTION" + this.anonymousCount;
                ++this.anonymousCount;
            } else {
                int n3 = stringBuffer.indexOf(" as ");
                CONN_OBJECT_NAME = stringBuffer.substring(n3 + 4, stringBuffer.length());
            }
            STMT_OBJECT_NAME = "st_" + CONN_OBJECT_NAME;
            USER_NAME = stringBuffer.substring(n2 + 1, stringBuffer.indexOf("'", n2 + 1));
            if (this.userConnections.get(USER_NAME) == null) {
                this.junit.write("Connection ");
                this.junit.write(CONN_OBJECT_NAME);
                this.junit.write(" = openUserConnection(\"");
                this.junit.write(USER_NAME);
                this.junit.write("\");");
                this.writeJUnitEOL();
                this.junit.write("Statement ");
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(" = ");
                this.junit.write(CONN_OBJECT_NAME);
                this.junit.write(".createStatement();");
                this.writeJUnitEOL();
            }
            this.userConnections.setProperty(CONN_OBJECT_NAME, USER_NAME);
            ++this.usersConnected;
            if (this.usersConnected > 1) {
                IJ_PROMPT = "ij(" + CONN_OBJECT_NAME.toUpperCase() + ")>";
            }
        }
    }

    private void writeFailStatement(StringBuffer stringBuffer, String string, StringBuffer stringBuffer2, boolean bl) throws Exception {
        String string2 = this.extractSQLState(stringBuffer2);
        if (bl) {
            this.junit.write("assertCompileError(\"");
        } else {
            this.junit.write("assertStatementError(\"");
        }
        this.junit.write(string2);
        this.junit.write("\", ");
        if (stringBuffer != null) {
            if (!bl) {
                this.junit.write(STMT_OBJECT_NAME);
                this.junit.write(",");
            }
            this.writeJUnitEOL();
            this.writeQuotedLine(stringBuffer, "");
        } else {
            this.junit.write(string);
            this.junit.write(");");
        }
    }

    private void writeAssertDDLCount(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) throws Exception {
        this.junit.write("assertUpdateCount(");
        this.junit.write(string);
        this.junit.write(", ");
        this.junit.write(this.extractRowCount(stringBuffer2));
        if (stringBuffer != null) {
            this.junit.write(",");
            this.writeJUnitEOL();
            this.writeQuotedLine(stringBuffer, "");
        } else {
            this.junit.write(");");
        }
    }

    private String extractRowCount(StringBuffer stringBuffer) throws Exception {
        int n = this.getLineType(stringBuffer);
        if (n != ROW_COUNT) {
            System.out.println("OOPS, tried to extract row count from " + stringBuffer);
            return "";
        }
        String string = stringBuffer.substring(0, stringBuffer.indexOf(" ")).trim();
        stringBuffer.delete(0, stringBuffer.length());
        return string;
    }

    private void writeGetCursor(StringBuffer stringBuffer, String string) throws Exception {
        int n;
        int n2 = stringBuffer.indexOf("cursor") + 7;
        if (n2 < 0) {
            n2 = stringBuffer.indexOf("CURSOR") + 7;
        }
        if ((n = stringBuffer.indexOf(" as ")) < 0) {
            n = stringBuffer.indexOf(" AS ");
        }
        String string2 = stringBuffer.substring(n2, n).trim();
        this.junit.write("PreparedStatement ps_");
        this.junit.write(string2);
        this.junit.write(" = prepareStatement(");
        this.writeJUnitEOL();
        stringBuffer.delete(0, stringBuffer.indexOf("'") + 1);
        stringBuffer.delete(stringBuffer.lastIndexOf("'"), stringBuffer.length());
        this.collapseQuotes(stringBuffer, '\'');
        this.writeQuotedLine(stringBuffer, string);
        this.writeJUnitEOL();
        this.writeJUnitEOL();
        this.junit.write("ResultSet ");
        this.junit.write(string2);
        this.junit.write(" = ps_");
        this.junit.write(string2);
        this.junit.write(".executeQuery();");
        this.writeJUnitEOL();
    }

    private void writeMaxLenLine(StringBuffer stringBuffer, String string, String string2) throws Exception {
        if (stringBuffer.length() <= LINE_LENGTH) {
            this.junit.write(stringBuffer.toString());
            return;
        }
        int n = string == null ? 0 : string.length();
        int n2 = string2 == null ? 0 : string2.length();
        int n3 = -1;
        boolean bl = true;
        while (stringBuffer.length() > 0) {
            if (!bl) {
                this.writeJUnitEOL();
                if (n > 0) {
                    this.junit.write(string);
                }
            }
            if ((n3 = stringBuffer.indexOf("\n")) != -1) {
                this.writeMaxLenLine(new StringBuffer(stringBuffer.substring(0, n3)), string, string2);
                ++n3;
            } else if (stringBuffer.length() <= LINE_LENGTH) {
                this.junit.write(stringBuffer.toString());
                n3 = stringBuffer.length();
            } else {
                String string3 = stringBuffer.toString().substring(0, LINE_LENGTH - n - n2);
                n3 = string3.lastIndexOf(" ") + 1;
                if (n3 == 0) {
                    n3 = string3.length();
                }
                this.junit.write(string3.substring(0, n3));
            }
            stringBuffer.delete(0, n3);
            if (n2 > 0 && stringBuffer.length() > 0) {
                this.junit.write(string2);
            }
            bl = false;
        }
    }

    private void escapeQuotes(StringBuffer stringBuffer) {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return;
        }
        int n = stringBuffer.length();
        for (int i = n - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '\"') continue;
            stringBuffer.replace(i, i + 1, "\\\"");
        }
    }

    private void collapseQuotes(StringBuffer stringBuffer, char c) {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return;
        }
        int n = stringBuffer.length();
        for (int i = n - 1; i >= 1; --i) {
            if (stringBuffer.charAt(i) != c || stringBuffer.charAt(i - 1) != c) continue;
            stringBuffer.deleteCharAt(i);
            --i;
        }
    }

    private String strip(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (!string.trim().startsWith(string2)) {
            return string;
        }
        return string.substring(string.indexOf(string2) + string2.length()).trim();
    }

    private StringBuffer strip(StringBuffer stringBuffer, String string) {
        if (string == null || string.length() == 0) {
            return stringBuffer;
        }
        if (stringBuffer.length() == 0) {
            return stringBuffer;
        }
        int n = 0;
        while (Character.isWhitespace(stringBuffer.charAt(n))) {
            ++n;
        }
        int n2 = string.length();
        boolean bl = true;
        for (int i = 0; i < n2 && bl; ++i) {
            if (stringBuffer.charAt(n + i) == string.charAt(i)) continue;
            bl = false;
        }
        if (bl) {
            stringBuffer.delete(0, n + n2);
        }
        return stringBuffer;
    }

    private int getLineType(StringBuffer stringBuffer) {
        return this.getLineType(stringBuffer.toString());
    }

    private int getLineType(String string) {
        if ((string = this.strip(string, IJ_PROMPT).toLowerCase().trim()).length() == 0) {
            return BLANK_LINE;
        }
        if (string.startsWith(IJ_WARNING)) {
            return IWARNING;
        }
        if (string.startsWith(IJ_COMMENT)) {
            return COMMENT;
        }
        if (string.startsWith("error")) {
            return SQL_ERROR;
        }
        if (string.startsWith("warning")) {
            return SQL_WARNING;
        }
        if (this.isIjCommand(string)) {
            return IJ_COMMAND;
        }
        if (this.isQueryStatement(string)) {
            return EXEC_QUERY;
        }
        if (this.isDDLWithRowCount(string)) {
            return EXEC_DDL_WITH_ROW_COUNT;
        }
        if (this.isDDLNoRowCount(string)) {
            return EXEC_DDL_NO_ROW_COUNT;
        }
        if (string.startsWith("prepare")) {
            return PREPARE;
        }
        if (string.startsWith("execute")) {
            return P_EXECUTE;
        }
        if (string.startsWith("call ")) {
            return CALL_STMT;
        }
        if (Character.isDigit(string.charAt(0))) {
            int n = string.indexOf(" ");
            if (n > 0 && string.substring(n).trim().startsWith("row")) {
                return ROW_COUNT;
            }
            return UNKNOWN_LINE;
        }
        if (string.startsWith("autocommit")) {
            return AUTOCOMMIT;
        }
        if (string.startsWith("commit")) {
            return COMMIT;
        }
        if (string.startsWith("rollback")) {
            return ROLLBACK;
        }
        if (string.startsWith("set schema")) {
            return SET_SCHEMA;
        }
        if (string.startsWith("grant ")) {
            return GRANT;
        }
        if (string.startsWith("revoke")) {
            return REVOKE;
        }
        if (string.startsWith("remove")) {
            return REMOVE;
        }
        if (string.startsWith("get cursor")) {
            return GET_CURSOR;
        }
        if (string.startsWith("next ")) {
            return CURSOR_NEXT;
        }
        if (string.startsWith("close")) {
            return CURSOR_CLOSE;
        }
        if (string.startsWith("connect")) {
            return CONNECT;
        }
        if (string.startsWith("set connection")) {
            return SET_CONNECTION;
        }
        return UNKNOWN_LINE;
    }

    private boolean isDDLWithRowCount(String string) {
        for (int i = 0; i < DDL_RC_COMMANDS.length; ++i) {
            if (!string.startsWith(DDL_RC_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDDLNoRowCount(String string) {
        for (int i = 0; i < DDL_NO_RC_COMMANDS.length; ++i) {
            if (!string.startsWith(DDL_NO_RC_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isQueryStatement(String string) {
        for (int i = 0; i < QUERY_COMMANDS.length; ++i) {
            if (!string.startsWith(QUERY_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isIjCommand(String string) {
        for (int i = 0; i < IJ_COMMANDS.length; ++i) {
            if (!string.startsWith(IJ_COMMANDS[i])) continue;
            return true;
        }
        return false;
    }

    private void writeAssertResultSet(StringBuffer stringBuffer) throws Exception {
        while (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer.deleteCharAt(0);
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuffer.toString()));
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringTokenizer stringTokenizer = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (n != 1) {
                if (this.getLineType(string) == ROW_COUNT) {
                    --n;
                } else {
                    if (n == 0) {
                        this.writeJUnitEOL();
                        this.junit.write("expColNames = new String [] {");
                    } else if (!bl) {
                        this.writeJUnitEOL();
                        this.junit.write("expRS = new String [][]");
                        this.writeJUnitEOL();
                        this.junit.write("{");
                        bl = true;
                    }
                    if (n > 2) {
                        this.junit.write(",");
                    }
                    n2 = 0;
                    stringTokenizer = new StringTokenizer(string, "|");
                    if (n > 0) {
                        this.writeJUnitEOL();
                        this.junit.write("    {");
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer2.append(stringTokenizer.nextToken().trim());
                        this.escapeQuotes(stringBuffer2);
                        if (n2 > 0) {
                            this.junit.write(", ");
                        }
                        if (stringBuffer2.toString().equals("NULL")) {
                            this.junit.write("null");
                        } else {
                            this.junit.write("\"");
                            this.writeMaxLenLine(stringBuffer2, "        + \"", "\"");
                            this.junit.write("\"");
                        }
                        ++n2;
                        stringBuffer2.delete(0, stringBuffer2.length());
                    }
                    this.junit.write("}");
                    if (n == 0) {
                        this.junit.write(";");
                        this.writeJUnitEOL();
                        this.junit.write("JDBC.assertColumnNames(rs, expColNames);");
                        this.writeJUnitEOL();
                    }
                }
            }
            string = bufferedReader.readLine();
            ++n;
        }
        if (n == 2) {
            this.junit.write("JDBC.assertDrainResults(rs, 0);");
        } else {
            this.writeJUnitEOL();
            this.junit.write("};");
            this.writeJUnitEOL();
            this.writeJUnitEOL();
            this.junit.write("JDBC.assertFullResultSet(rs, expRS, true);");
        }
        stringBuffer.delete(0, stringBuffer.length());
    }

    private String extractSQLState(StringBuffer stringBuffer) throws Exception {
        String string;
        if (stringBuffer.indexOf("SQLSTATE") > 0) {
            string = stringBuffer.delete(0, stringBuffer.indexOf(" ", stringBuffer.indexOf("SQLSTATE")) + 1).toString().substring(0, 5);
            stringBuffer.delete(0, 6);
        } else {
            string = stringBuffer.substring(stringBuffer.indexOf(" ") + 1, stringBuffer.indexOf(":"));
            stringBuffer.delete(0, stringBuffer.length());
        }
        return string;
    }

    private void writeAssertSQLState(String string, String string2) throws Exception {
        this.junit.write("assertSQLState(\"");
        this.junit.write(string);
        this.junit.write("\", ");
        this.junit.write(string2);
        this.junit.write(");");
    }

    private void writeAssertWarning(StringBuffer stringBuffer) throws Exception {
        String string = "    ";
        if (getWarningLogic == null) {
            getWarningLogic = "if (usingEmbedded())\n" + leftMargin + "{\n" + leftMargin + string + "if ((sqlWarn == null) && (" + STMT_OBJECT_NAME + " != null))\n" + leftMargin + string + string + "sqlWarn = " + STMT_OBJECT_NAME + ".getWarnings();\n" + leftMargin + string + "if (sqlWarn == null)\n" + leftMargin + string + string + "sqlWarn = " + (this.multipleUserConnections ? CONN_OBJECT_NAME : "getConnection()") + ".getWarnings();\n" + leftMargin;
        }
        this.junit.write(getWarningLogic);
        this.junit.write(string);
        this.junit.write("assertNotNull(\"Expected warning but found none\", ");
        this.junit.write(SQL_WARN_OBJECT_NAME);
        this.junit.write(");");
        this.writeJUnitEOL();
        this.junit.write(string);
        this.writeAssertSQLState(this.extractSQLState(stringBuffer), SQL_WARN_OBJECT_NAME);
        this.writeJUnitEOL();
        this.junit.write(string);
        this.junit.write("sqlWarn = null;");
        this.writeJUnitEOL();
        this.junit.write("}");
    }

    private void writeQuotedLine(StringBuffer stringBuffer, String string) throws Exception {
        this.junit.write(string);
        this.junit.write("    \"");
        this.escapeQuotes(stringBuffer);
        this.writeMaxLenLine(stringBuffer, string + "    + \"", "\"");
        this.junit.write("\");");
    }

    private void writeJUnitEOL() throws IOException {
        this.junit.write("\n");
        this.junit.write(leftMargin);
    }

    private boolean getNextIjCommand(StringBuffer stringBuffer) throws IOException {
        int n = 0;
        boolean bl = false;
        StringBuffer stringBuffer2 = stringBuffer;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.tmpBuf.length() > 0) {
            string = this.tmpBuf.toString();
            this.tmpBuf.delete(0, this.tmpBuf.length());
            bl5 = true;
        }
        while (!bl) {
            if (!bl5) {
                string = this.ijScript.readLine();
            } else {
                bl5 = false;
            }
            while (string != null && (string = string.trim()).length() == 0) {
                string = this.ijScript.readLine();
            }
            if (string == null) {
                n = -1;
                break;
            }
            int n2 = this.getLineType(string);
            if (!bl2) {
                boolean bl6 = bl4 = bl4 || n2 > -1 && n2 != COMMENT;
            }
            if (!bl2 && string.charAt(string.length() - 1) == ';') {
                stringBuffer2.append(string.substring(0, string.length() - 1));
                if (string.indexOf("GET_RUNTIMESTATISTICS()") <= 0) break;
                this.gotRuntimeStatistics = true;
                break;
            }
            if (!bl4 && (n2 == UNKNOWN_LINE || n2 == COMMENT && !bl3 && bl2)) {
                bl2 = true;
                if (n2 == COMMENT) {
                    bl3 = true;
                }
                stringBuffer2.append(string);
                stringBuffer2.append("\n");
                continue;
            }
            if (bl2) {
                if (n2 > -1) {
                    if (this.gotRuntimeStatistics) {
                        this.gotRuntimeStatistics = false;
                        stringBuffer2.append(string);
                        stringBuffer2.append("\n");
                        continue;
                    }
                    this.tmpBuf.append(string);
                    break;
                }
                stringBuffer2.append(string);
                break;
            }
            stringBuffer2.append(string);
            if (!bl4) break;
            stringBuffer2.append(" ");
        }
        return n != -1;
    }

    private boolean haveNonCommand(String string) {
        int n = this.getLineType(string);
        return n < 0 || n == COMMENT;
    }

    private boolean ignorableLine(int n) {
        return n == IWARNING || n == BLANK_LINE;
    }

    private void writePrologue() throws IOException {
        this.junit.write("\npublic final class IJToJUnitTest extends BaseJDBCTestCase {\n\n    /**\n     * Public constructor required for running test as standalone JUnit.\n     */\n    public IJToJUnitTest(String name)\n    {\n        super(name);\n    }\n\n    public static Test suite()\n    {\n        BaseTestSuite suite = new BaseTestSuite(\"IJToJUnitTest Test\");\n        suite.addTest(TestConfiguration.defaultSuite(IJToJUnitTest.class));\n        return suite;\n    }\n\n    public void test_IJToJUnitTest() throws Exception\n    {\n        ResultSet rs = null;\n        ResultSetMetaData rsmd;\n        SQLWarning sqlWarn = null;\n\n        PreparedStatement pSt;\n        CallableStatement cSt;\n        Statement st = createStatement();\n\n        String [][] expRS;\n        String [] expColNames;\n\n".replaceAll("IJToJUnitTest", this.jTestName));
    }

    static {
        IJ_PROMPT = "ij>";
        CONN_OBJECT_NAME = "conn";
        STMT_OBJECT_NAME = "st";
        USER_NAME = "";
        DDL_NO_RC_COMMANDS = new String[]{"create", "drop", "alter", "insert", "rename", "grant ", "set schema", "revoke", "lock table"};
        DDL_RC_COMMANDS = new String[]{"update", "delete", "declare"};
        QUERY_COMMANDS = new String[]{"select", "values"};
        IJ_COMMANDS = new String[]{"show", "describe"};
        EXEC_QUERY = 0;
        EXEC_DDL_NO_ROW_COUNT = 1;
        EXEC_DDL_WITH_ROW_COUNT = 2;
        PREPARE = 3;
        P_EXECUTE = 4;
        CALL_STMT = 5;
        COMMENT = 6;
        AUTOCOMMIT = 7;
        COMMIT = 8;
        ROLLBACK = 9;
        SET_SCHEMA = 10;
        REMOVE = 11;
        GRANT = 12;
        GET_CURSOR = 13;
        CURSOR_NEXT = 14;
        CURSOR_CLOSE = 15;
        CONNECT = 16;
        SET_CONNECTION = 17;
        REVOKE = 18;
        IJ_COMMAND = 19;
        ROW_COUNT = -1;
        BLANK_LINE = -3;
        SQL_ERROR = -4;
        SQL_WARNING = -5;
        IWARNING = -7;
        UNKNOWN_LINE = -999;
        LINE_LENGTH = 60;
    }
}

