/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.crypto;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;

public class T_Cipher
extends T_Generic {
    private static final String testService = "CipherText";
    CipherProvider enEngine;
    CipherProvider deEngine;
    Key secretKey;
    byte[] IV;
    CipherFactory factory;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.crypto.CipherFactoryBuilder";
    }

    protected String getAlgorithm() {
        return "DES/CBC/NoPadding";
    }

    protected String getProvider() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("testEncryptionProvider");
            }
        });
        if (string != null) {
            return string;
        }
        return null;
    }

    @Override
    public void runTests() throws T_Fail {
        File file = new File("extinout/T_Cipher.data");
        this.deleteFile(file);
        String string = "a secret, don't tell anyone";
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.setupCiphers(string);
            int n = 8192;
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(i & 0xFF);
            }
            this.test(byArray, 0, 8, randomAccessFile);
            this.test(byArray, 8, 8, randomAccessFile);
            this.test(byArray, 1, 16, randomAccessFile);
            this.test(byArray, 0, n, randomAccessFile);
            this.test(byArray, 0, n / 2, randomAccessFile);
            this.test(byArray, 1, n / 2, randomAccessFile);
            this.test(byArray, 2, n / 2, randomAccessFile);
            this.test(byArray, 3, n / 2, randomAccessFile);
            randomAccessFile.seek(0L);
            this.check(byArray, 0, 8, randomAccessFile);
            this.check(byArray, 8, 8, randomAccessFile);
            this.check(byArray, 1, 16, randomAccessFile);
            this.check(byArray, 0, n, randomAccessFile);
            this.check(byArray, 0, n / 2, randomAccessFile);
            this.check(byArray, 1, n / 2, randomAccessFile);
            this.check(byArray, 2, n / 2, randomAccessFile);
            this.check(byArray, 3, n / 2, randomAccessFile);
            this.REPORT("starting random test");
            randomAccessFile.seek(32 + n);
            this.check(byArray, 0, n / 2, randomAccessFile);
            randomAccessFile.seek(32L);
            this.check(byArray, 0, n, randomAccessFile);
            randomAccessFile.seek(32 + 2 * n);
            this.check(byArray, 2, n / 2, randomAccessFile);
            randomAccessFile.seek(0L);
            this.check(byArray, 0, 8, randomAccessFile);
            randomAccessFile.seek(16L);
            this.check(byArray, 1, 16, randomAccessFile);
            randomAccessFile.seek(32 + 2 * n + n / 2);
            this.check(byArray, 3, n / 2, randomAccessFile);
            randomAccessFile.seek(8L);
            this.check(byArray, 8, 8, randomAccessFile);
            randomAccessFile.seek(32 + n + n / 2);
            this.check(byArray, 1, n / 2, randomAccessFile);
            randomAccessFile.close();
        }
        catch (StandardException standardException) {
            standardException.printStackTrace(System.out);
            throw T_Fail.exceptionFail(standardException);
        }
        catch (IOException iOException) {
            throw T_Fail.exceptionFail(iOException);
        }
        this.PASS("T_Cipher");
    }

    protected void setupCiphers(String string) throws T_Fail, StandardException {
        Properties properties = new Properties();
        properties.put("encryptionAlgorithm", this.getAlgorithm());
        String string2 = this.getProvider();
        if (string2 != null) {
            properties.put("encryptionProvider", this.getProvider());
        }
        properties.put("bootPassword", string);
        this.REPORT("encryption algorithm used : " + this.getAlgorithm());
        this.REPORT("encryption provider used : " + string2);
        CipherFactoryBuilder cipherFactoryBuilder = (CipherFactoryBuilder)T_Cipher.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
        this.factory = cipherFactoryBuilder.createCipherFactory(true, properties, false);
        if (this.factory == null) {
            throw T_Fail.testFailMsg("cannot find Cipher factory ");
        }
        this.enEngine = this.factory.createNewCipher(1);
        this.deEngine = this.factory.createNewCipher(2);
        if (this.enEngine == null) {
            throw T_Fail.testFailMsg("cannot create encryption engine");
        }
        if (this.deEngine == null) {
            throw T_Fail.testFailMsg("cannot create decryption engine");
        }
    }

    protected void test(byte[] byArray, int n, int n2, RandomAccessFile randomAccessFile) throws T_Fail, StandardException, IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (this.enEngine.encrypt(byArray2, 0, n2, byArray2, 0) != n2) {
            throw T_Fail.testFailMsg("encrypted text length != length");
        }
        if (this.byteArrayIdentical(byArray2, byArray, n, n2)) {
            throw T_Fail.testFailMsg("encryption just made a copy of the clear text");
        }
        randomAccessFile.write(byArray2);
        this.deEngine.decrypt(byArray2, 0, n2, byArray2, 0);
        if (!this.byteArrayIdentical(byArray2, byArray, n, n2)) {
            throw T_Fail.testFailMsg("decryption did not yield the same clear text");
        }
    }

    protected void check(byte[] byArray, int n, int n2, RandomAccessFile randomAccessFile) throws IOException, T_Fail, StandardException {
        byte[] byArray2 = new byte[n2];
        randomAccessFile.read(byArray2);
        if (this.deEngine.decrypt(byArray2, 0, n2, byArray2, 0) != n2) {
            throw T_Fail.testFailMsg("decrypted text length != length");
        }
        if (!this.byteArrayIdentical(byArray2, byArray, n, n2)) {
            throw T_Fail.testFailMsg("decryption did not yield the same clear text");
        }
    }

    protected boolean byteArrayIdentical(byte[] byArray, byte[] byArray2, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    private void deleteFile(final File file) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (file.exists()) {
                    file.delete();
                }
                return null;
            }
        });
    }

    private static Object startSystemModule(final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule((String)string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

