/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectWrapper;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.schema.loader.SchemaEntityFactory;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.schema.registries.synchronizers.RegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistrySynchronizer
implements RegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegistrySynchronizer.class);
    protected final SchemaManager schemaManager;
    protected final AttributeType moidAT;
    protected final SchemaEntityFactory factory;
    private static final Map<String, String> OBJECT_TYPE_TO_PATH = new HashMap<String, String>();

    protected AbstractRegistrySynchronizer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.moidAT = schemaManager.getAttributeType("m-oid");
        this.factory = new SchemaEntityFactory();
    }

    protected boolean isSchemaLoaded(Dn dn) throws LdapException {
        return this.schemaManager.isSchemaLoaded(this.getSchemaName(dn));
    }

    protected boolean isSchemaLoaded(String schemaName) {
        return this.schemaManager.isSchemaLoaded(schemaName);
    }

    protected boolean isSchemaEnabled(String schemaName) {
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        return schema != null && schema.isEnabled();
    }

    protected String getSchemaName(Dn dn) throws LdapException {
        int size = dn.size();
        if (size < 2) {
            throw new LdapInvalidDnException(I18n.err(I18n.ERR_276, new Object[0]));
        }
        Rdn rdn = dn.getRdn(size - 2);
        return Strings.trim(rdn.getAva().getValue().getNormalized());
    }

    protected void checkOidIsUnique(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            throw new LdapOtherException(I18n.err(I18n.ERR_335, oid));
        }
    }

    protected SchemaObject checkOidExists(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            return this.schemaManager.getGlobalOidRegistry().getSchemaObject(oid);
        }
        throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_336, oid));
    }

    protected void checkParent(Dn newParent, SchemaManager schemaManager, String objectType) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_337, new Object[0]));
        }
        Rdn rdn = newParent.getRdn();
        if (!schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_338, objectType));
        }
        if (!rdn.getValue().equalsIgnoreCase(OBJECT_TYPE_TO_PATH.get(objectType))) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_339, objectType, OBJECT_TYPE_TO_PATH.get(objectType)));
        }
    }

    protected void checkOidIsUnique(SchemaObject schemaObject) throws LdapException {
        String oid = schemaObject.getOid();
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_335, oid));
        }
    }

    protected void checkOidIsUnique(String oid) throws LdapException {
        if (this.schemaManager.getGlobalOidRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_335, oid));
        }
    }

    protected void addToSchema(SchemaObject schemaObject, String schemaName) throws LdapException {
        SchemaObjectWrapper schemaObjectWrapper;
        Set<SchemaObjectWrapper> schemaObjects;
        if (this.isSchemaLoaded(schemaName)) {
            schemaObjects = this.schemaManager.getRegistries().getObjectBySchemaName().get(schemaName);
            if (schemaObjects == null) {
                schemaObjects = this.schemaManager.getRegistries().addSchema(schemaName);
            }
            if (schemaObjects.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
                String msg = I18n.err(I18n.ERR_341, schemaObject.getName(), schemaName);
                LOG.warn(msg);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
        } else {
            String msg = I18n.err(I18n.ERR_342, schemaObject.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        schemaObjects.add(schemaObjectWrapper);
        LOG.debug("The SchemaObject {} has been added to the schema {}", (Object)schemaObject, (Object)schemaName);
    }

    protected void deleteFromSchema(SchemaObject schemaObject, String schemaName) throws LdapException {
        SchemaObjectWrapper schemaObjectWrapper;
        Set<SchemaObjectWrapper> schemaObjects;
        if (this.isSchemaLoaded(schemaName)) {
            schemaObjects = this.schemaManager.getRegistries().getObjectBySchemaName().get(schemaName);
            if (!schemaObjects.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
                String msg = I18n.err(I18n.ERR_343, schemaObject.getName(), schemaName);
                LOG.warn(msg);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
        } else {
            String msg = I18n.err(I18n.ERR_342, schemaObject.getName(), schemaName);
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        schemaObjects.remove(schemaObjectWrapper);
        LOG.debug("The SchemaObject {} has been removed from the schema {}", (Object)schemaObject, (Object)schemaName);
    }

    protected Set<String> getOids(Set<Entry> results) {
        HashSet<String> oids = new HashSet<String>(results.size());
        for (Entry result : results) {
            Dn dn = result.getDn();
            oids.add(dn.getRdn().getValue());
        }
        return oids;
    }

    protected String getOid(Entry entry) throws LdapException {
        Attribute oid = entry.get(this.moidAT);
        if (oid == null) {
            return null;
        }
        return oid.getString();
    }

    protected void unregisterOids(SchemaObject obj) throws LdapException {
        this.schemaManager.getGlobalOidRegistry().unregister(obj.getOid());
    }

    protected void registerOids(SchemaObject obj) throws LdapException {
        this.schemaManager.getGlobalOidRegistry().register(obj);
    }

    protected String getReferenced(SchemaObject schemaObject) {
        StringBuilder sb = new StringBuilder();
        Set<SchemaObjectWrapper> useds = this.schemaManager.getRegistries().getUsedBy(schemaObject);
        for (SchemaObjectWrapper used : useds) {
            sb.append(used);
            sb.append('\n');
        }
        return sb.toString();
    }

    static {
        OBJECT_TYPE_TO_PATH.put("AttributeType", "ou=attributetypes".substring(3));
        OBJECT_TYPE_TO_PATH.put("Comparator", "ou=comparators".substring(3));
        OBJECT_TYPE_TO_PATH.put("DitContentRule", "ou=ditcontentrules".substring(3));
        OBJECT_TYPE_TO_PATH.put("DitStructureRule", "ou=ditstructurerules".substring(3));
        OBJECT_TYPE_TO_PATH.put("MatchingRule", "ou=matchingrules".substring(3));
        OBJECT_TYPE_TO_PATH.put("MatchingRuleUse", "ou=matchingruleuse".substring(3));
        OBJECT_TYPE_TO_PATH.put("NameForm", "ou=nameforms".substring(3));
        OBJECT_TYPE_TO_PATH.put("Normalizer", "ou=normalizers".substring(3));
        OBJECT_TYPE_TO_PATH.put("ObjectCLass", "ou=objectclasses".substring(3));
        OBJECT_TYPE_TO_PATH.put("Syntax", "ou=syntaxes".substring(3));
        OBJECT_TYPE_TO_PATH.put("SyntaxChecker", "ou=syntaxcheckers".substring(3));
    }
}

