/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.task;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetUpdateBarrier;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetUpdateBarrierBroker;
import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatch;
import org.apache.flink.runtime.iterative.concurrent.SuperstepKickoffLatchBroker;
import org.apache.flink.runtime.iterative.io.WorksetUpdateOutputCollector;
import org.apache.flink.runtime.iterative.task.AbstractIterativeTask;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IterationTailTask<S extends Function, OT>
extends AbstractIterativeTask<S, OT> {
    private static final Logger log = LoggerFactory.getLogger(IterationTailTask.class);
    private SolutionSetUpdateBarrier solutionSetUpdateBarrier;
    private WorksetUpdateOutputCollector<OT> worksetUpdateOutputCollector;

    public IterationTailTask(Environment environment) {
        super(environment);
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        if (!this.isWorksetUpdate && !this.isSolutionSetUpdate) {
            throw new RuntimeException("The iteration tail doesn't update workset or the solution set.");
        }
        Collector outputCollector = null;
        if (this.isWorksetUpdate) {
            outputCollector = this.createWorksetUpdateOutputCollector();
            if (this.isWorksetIteration) {
                this.worksetUpdateOutputCollector = (WorksetUpdateOutputCollector)outputCollector;
            }
        }
        if (this.isSolutionSetUpdate) {
            outputCollector = this.isWorksetIteration ? this.createSolutionSetUpdateOutputCollector(outputCollector) : new Collector<OT>(){

                @Override
                public void collect(OT record) {
                }

                @Override
                public void close() {
                }
            };
            if (!this.isWorksetUpdate) {
                this.solutionSetUpdateBarrier = SolutionSetUpdateBarrierBroker.instance().get(this.brokerKey());
            }
        }
        this.setLastOutputCollector(outputCollector);
    }

    @Override
    public void run() throws Exception {
        SuperstepKickoffLatch nextSuperStepLatch = SuperstepKickoffLatchBroker.instance().get(this.brokerKey());
        while (this.running && !this.terminationRequested()) {
            if (log.isInfoEnabled()) {
                log.info(this.formatLogString("starting iteration [" + this.currentIteration() + "]"));
            }
            super.run();
            this.verifyEndOfSuperstepState();
            if (this.isWorksetUpdate && this.isWorksetIteration) {
                long numCollected = this.worksetUpdateOutputCollector.getElementsCollectedAndReset();
                this.worksetAggregator.aggregate(numCollected);
            }
            if (log.isInfoEnabled()) {
                log.info(this.formatLogString("finishing iteration [" + this.currentIteration() + "]"));
            }
            if (this.isWorksetUpdate) {
                this.worksetBackChannel.notifyOfEndOfSuperstep();
            } else if (this.isSolutionSetUpdate) {
                this.solutionSetUpdateBarrier.notifySolutionSetUpdate();
            }
            boolean terminate = nextSuperStepLatch.awaitStartOfSuperstepOrTermination(this.currentIteration() + 1);
            if (terminate) {
                this.requestTermination();
                continue;
            }
            this.incrementIterationCounter();
        }
    }
}

