/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.configuration;

import java.nio.file.Path;
import org.apache.jena.geosparql.geof.topological.RelateFF;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.function_registration.Egenhofer;
import org.apache.jena.geosparql.implementation.function_registration.GeometryProperty;
import org.apache.jena.geosparql.implementation.function_registration.NonTopological;
import org.apache.jena.geosparql.implementation.function_registration.RCC8;
import org.apache.jena.geosparql.implementation.function_registration.Relate;
import org.apache.jena.geosparql.implementation.function_registration.SimpleFeatures;
import org.apache.jena.geosparql.implementation.function_registration.Spatial;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.geosparql.implementation.index.GeometryTransformIndex;
import org.apache.jena.geosparql.implementation.index.IndexConfiguration;
import org.apache.jena.geosparql.implementation.index.QueryRewriteIndex;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.compat.SpatialIndexIo;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexIoKryo;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexLib;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sys.JenaSystem;

public class GeoSPARQLConfig {
    private static boolean IS_FUNCTIONS_REGISTERED;
    private static boolean IS_QUERY_REWRITE_ENABLED;
    public static int DECIMAL_PLACES_PRECISION;
    public static int PRECISION_MODEL_SCALE_FACTOR;
    public static boolean ALLOW_GEOMETRY_SRS_TRANSFORMATION;

    public static final void setupMemoryIndex() {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, true);
    }

    public static final void setupMemoryIndex(Boolean isQueryRewriteEnabled) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, isQueryRewriteEnabled);
    }

    public static final void setupMemoryIndex(Integer geometryLiteralIndex, Integer geometryTransformIndex, Integer queryRewriteIndex, Long geometryLiteralIndexExpiry, Long geometryTransformIndexExpiry, Long queryRewriteIndexExpiry, Boolean isQueryRewriteEnabled) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.MEMORY, isQueryRewriteEnabled);
        GeometryLiteralIndex.reset(geometryLiteralIndex, geometryLiteralIndexExpiry);
        GeometryTransformIndex.reset(geometryTransformIndex, geometryTransformIndexExpiry);
        QueryRewriteIndex.setMaxSize(queryRewriteIndex);
        QueryRewriteIndex.setExpiry(queryRewriteIndexExpiry);
    }

    public static final void setupNoIndex() {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.NONE, true);
    }

    public static final void setupNoIndex(Boolean isQueryRewriteEnabled) {
        GeoSPARQLConfig.setup(IndexConfiguration.IndexOption.NONE, isQueryRewriteEnabled);
    }

    public static final void setup(IndexConfiguration.IndexOption indexOption) {
        GeoSPARQLConfig.setup(indexOption, true);
    }

    public static final void setup(IndexConfiguration.IndexOption indexOption, Boolean isQueryRewriteEnabled) {
        IS_QUERY_REWRITE_ENABLED = isQueryRewriteEnabled;
        IndexConfiguration.setConfig(indexOption);
        GeoSPARQLConfig.loadFunctions();
    }

    public static final void loadFunctions() {
        if (!IS_FUNCTIONS_REGISTERED) {
            IS_FUNCTIONS_REGISTERED = true;
            SRSRegistry.setupDefaultSRS();
            GeometryDatatype.registerDatatypes();
            PropertyFunctionRegistry propertyRegistry = PropertyFunctionRegistry.get();
            FunctionRegistry functionRegistry = FunctionRegistry.get();
            NonTopological.loadFilterFunctions(functionRegistry);
            functionRegistry.put("http://www.opengis.net/ont/geosparql#relate", RelateFF.class);
            SimpleFeatures.loadPropertyFunctions(propertyRegistry);
            SimpleFeatures.loadFilterFunctions(functionRegistry);
            Egenhofer.loadPropertyFunctions(propertyRegistry);
            Egenhofer.loadFilterFunctions(functionRegistry);
            RCC8.loadPropertyFunctions(propertyRegistry);
            RCC8.loadFilterFunctions(functionRegistry);
            Relate.loadRelateFunction(functionRegistry);
            GeometryProperty.loadPropertyFunctions(propertyRegistry);
            GeometryProperty.loadFilterFunctions(functionRegistry);
            Spatial.loadPropertyFunctions(propertyRegistry);
            Spatial.loadFilterFunctions(functionRegistry);
        }
    }

    public static final Boolean isFunctionRegistered() {
        return IS_FUNCTIONS_REGISTERED;
    }

    public static final void reset() {
        IndexConfiguration.resetIndexesAndRegistries();
    }

    public static Boolean isQueryRewriteEnabled() {
        return IS_QUERY_REWRITE_ENABLED;
    }

    public static final void setupQueryRewriteIndex(Dataset dataset, String queryRewriteLabel, int maxSize, long expiryInterval) {
        QueryRewriteIndex.prepare(dataset, queryRewriteLabel, maxSize, expiryInterval);
    }

    public static final void setupSpatialIndex(Dataset dataset) throws SpatialIndexException {
        SpatialIndexLib.buildSpatialIndex(dataset.asDatasetGraph());
    }

    public static final void setupPrecomputedSpatialIndex(Dataset dataset, Path spatialIndexFile) throws SpatialIndexException {
        SpatialIndex si = SpatialIndexIo.load(spatialIndexFile);
        SpatialIndexLib.setSpatialIndex(dataset, si);
    }

    public static final void setupSpatialIndex(Dataset dataset, Path spatialIndexFile) throws SpatialIndexException {
        SpatialIndexIoKryo.loadOrBuildSpatialIndex(dataset, spatialIndexFile);
    }

    public static final void setupSpatialIndex(Dataset dataset, String srsURI, Path spatialIndexFile) throws SpatialIndexException {
        SpatialIndexIoKryo.loadOrBuildSpatialIndex(dataset, srsURI, spatialIndexFile);
    }

    public static final void setCalculationPrecision(int decimalPlaces) {
        DECIMAL_PLACES_PRECISION = decimalPlaces;
    }

    public static final void setPrecisionModelScaleFactor(int scaleFactor) {
        PRECISION_MODEL_SCALE_FACTOR = scaleFactor;
    }

    public static final void allowGeometrySRSTransformation(boolean allowTransformation) {
        ALLOW_GEOMETRY_SRS_TRANSFORMATION = allowTransformation;
    }

    static {
        JenaSystem.init();
        IS_FUNCTIONS_REGISTERED = false;
        IS_QUERY_REWRITE_ENABLED = true;
        DECIMAL_PLACES_PRECISION = 6;
        PRECISION_MODEL_SCALE_FACTOR = 1000000;
        ALLOW_GEOMETRY_SRS_TRANSFORMATION = true;
    }
}

