/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.great_circle;

import org.apache.jena.geosparql.configuration.GeoSPARQLOperations;

public class LatLonPoint {
    private final double lat;
    private final double lon;

    public LatLonPoint(double lat, double lon) {
        this.lat = GeoSPARQLOperations.cleanUpPrecision(lat);
        this.lon = GeoSPARQLOperations.cleanUpPrecision(lon);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLonPoint other = (LatLonPoint)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        return Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(other.lon);
    }

    public String toString() {
        return "LatLonPoint{lat=" + this.lat + ", lon=" + this.lon + "}";
    }
}

