/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.Iterator;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionDatasetBuilder;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.util.Context;

public interface QueryExecution
extends AutoCloseable {
    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecution.dataset(dataset).query(query2).build();
    }

    public static QueryExecution create(String query2, Model model) {
        return QueryExecution.model(model).query(query2).build();
    }

    public static QueryExecution create(String query2, Dataset dataset) {
        return QueryExecution.dataset(dataset).query(query2).build();
    }

    public static QueryExecution create(Query query2, Model model) {
        return QueryExecution.model(model).query(query2).build();
    }

    public static QueryExecution service(String endpointURL, Query query2) {
        return (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecution.service(endpointURL).query(query2)).build();
    }

    public static QueryExecutionHTTP service(String endpointURL, String queryString) {
        return (QueryExecutionHTTP)((QueryExecutionHTTPBuilder)QueryExecution.service(endpointURL).query(queryString)).build();
    }

    public static QueryExecutionDatasetBuilder dataset(Dataset dataset) {
        return QueryExecutionDatasetBuilder.create().dataset(dataset);
    }

    public static QueryExecutionDatasetBuilder model(Model model) {
        return QueryExecutionDatasetBuilder.create().model(model);
    }

    public static QueryExecutionHTTPBuilder service(String serviceURL) {
        return (QueryExecutionHTTPBuilder)QueryExecutionHTTPBuilder.create().endpoint(serviceURL);
    }

    public static QueryExecutionDatasetBuilder create() {
        return QueryExecutionDatasetBuilder.create();
    }

    public Dataset getDataset();

    public Context getContext();

    public Query getQuery();

    public String getQueryString();

    public ResultSet execSelect();

    public Model execConstruct();

    public Model execConstruct(Model var1);

    public Iterator<Triple> execConstructTriples();

    public Iterator<Quad> execConstructQuads();

    public Dataset execConstructDataset();

    public Dataset execConstructDataset(Dataset var1);

    public Model execDescribe();

    public Model execDescribe(Model var1);

    public Iterator<Triple> execDescribeTriples();

    public boolean execAsk();

    public JsonArray execJson();

    public Iterator<JsonObject> execJsonItems();

    public void abort();

    @Override
    public void close();

    public boolean isClosed();

    public long getTimeout1();

    public long getTimeout2();
}

