/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;

public class WebContainerLoginModule
extends AbstractLoginModule {
    protected static final Logger LOG = LogManager.getLogger(WebContainerLoginModule.class);

    @Override
    public boolean login() throws LoginException {
        HttpRequestCallback rcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{rcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = rcb.getRequest();
            if (request == null) {
                throw new LoginException("No Http request supplied.");
            }
            HttpSession session = request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            Principal principal = request.getUserPrincipal();
            if (principal == null) {
                LOG.debug("No userPrincipal found for session ID={}", (Object)sid);
                String userId = request.getRemoteUser();
                if (userId == null) {
                    LOG.debug("No remoteUser found for session ID={}", (Object)sid);
                    throw new FailedLoginException("No remote user found");
                }
                principal = new WikiPrincipal(userId, "loginName");
            }
            LOG.debug("Logged in container principal {}.", (Object)principal.getName());
            this.m_principals.add(principal);
            return true;
        }
        catch (IOException e) {
            LOG.error("IOException: {}", (Object)e.getMessage());
            return false;
        }
        catch (UnsupportedCallbackException e) {
            LOG.error("UnsupportedCallbackException: {}", (Object)e.getMessage());
            return false;
        }
    }
}

