/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.wiki.auth.permissions.PermissionChecks;

public class AllPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 1L;
    private boolean m_notEmpty;
    private boolean m_readOnly;
    protected final Hashtable<Permission, Permission> m_permissions = new Hashtable();

    @Override
    public void add(Permission permission) {
        if (!PermissionChecks.isJSPWikiPermission(permission)) {
            throw new IllegalArgumentException("Permission must be of type org.apache.wiki.permissions.*Permission.");
        }
        if (this.m_readOnly) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.m_notEmpty = true;
        this.m_permissions.put(permission, permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.m_permissions.elements();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!this.m_notEmpty) {
            return false;
        }
        if (!PermissionChecks.isJSPWikiPermission(permission)) {
            return false;
        }
        Enumeration<Permission> permEnum = this.m_permissions.elements();
        while (permEnum.hasMoreElements()) {
            Permission storedPermission = permEnum.nextElement();
            if (!storedPermission.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly() {
        this.m_readOnly = true;
    }
}

