/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.search.SearchMatcher;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.search.SearchResultComparator;

public class BasicSearchProvider
implements SearchProvider {
    private static final Logger LOG = LogManager.getLogger(BasicSearchProvider.class);
    private Engine m_engine;

    public void initialize(Engine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
    }

    @Override
    public void pageRemoved(Page page) {
    }

    @Override
    public void reindexPage(Page page) {
    }

    public QueryItem[] parseQuery(String query) {
        StringTokenizer st = new StringTokenizer(query, " \t,");
        QueryItem[] items = new QueryItem[st.countTokens()];
        int word = 0;
        LOG.debug("Expecting " + items.length + " items");
        while (st.hasMoreTokens()) {
            LOG.debug("Item " + word);
            String token = st.nextToken().toLowerCase();
            items[word] = new QueryItem();
            switch (token.charAt(0)) {
                case '+': {
                    items[word].type = 1;
                    token = token.substring(1);
                    LOG.debug("Required word: " + token);
                    break;
                }
                case '-': {
                    items[word].type = -1;
                    token = token.substring(1);
                    LOG.debug("Forbidden word: " + token);
                    break;
                }
                default: {
                    items[word].type = 0;
                    LOG.debug("Requested word: " + token);
                }
            }
            items[word++].word = token;
        }
        return items;
    }

    private String attachmentNames(Page page) {
        if (((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).hasAttachments(page)) {
            List<Attachment> attachments;
            try {
                attachments = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).listAttachments(page);
            }
            catch (ProviderException e) {
                LOG.error("Unable to get attachments for page", (Throwable)e);
                return "";
            }
            StringBuilder attachmentNames = new StringBuilder();
            Iterator<Attachment> it = attachments.iterator();
            while (it.hasNext()) {
                Attachment att = it.next();
                attachmentNames.append(att.getName());
                if (!it.hasNext()) continue;
                attachmentNames.append(" ");
            }
            return attachmentNames.toString();
        }
        return "";
    }

    private Collection<org.apache.wiki.api.search.SearchResult> findPages(QueryItem[] query, Context wikiContext) {
        Collection<Page> allPages;
        TreeSet<org.apache.wiki.api.search.SearchResult> res = new TreeSet<org.apache.wiki.api.search.SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        try {
            allPages = ((PageManager)this.m_engine.getManager(PageManager.class)).getAllPages();
        }
        catch (ProviderException pe) {
            LOG.error("Unable to retrieve page list", (Throwable)pe);
            return null;
        }
        AuthorizationManager mgr = (AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class);
        for (Page page : allPages) {
            try {
                String pageContent;
                String pageName;
                SearchResult comparison;
                if (page == null) continue;
                PagePermission pp = new PagePermission(page, "view");
                if (wikiContext != null && !mgr.checkPermission(wikiContext.getWikiSession(), pp) || (comparison = matcher.matchPageContent(pageName = page.getName(), pageContent = ((PageManager)this.m_engine.getManager(PageManager.class)).getPageText(pageName, -1) + this.attachmentNames(page))) == null) continue;
                res.add(comparison);
            }
            catch (ProviderException pe) {
                LOG.error("Unable to retrieve page from cache", (Throwable)pe);
            }
            catch (IOException ioe) {
                LOG.error("Failed to search page", (Throwable)ioe);
            }
        }
        return res;
    }

    @Override
    public Collection<org.apache.wiki.api.search.SearchResult> findPages(String query, Context wikiContext) {
        return this.findPages(this.parseQuery(query), wikiContext);
    }

    public String getProviderInfo() {
        return "BasicSearchProvider";
    }
}

