/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.boot.principal;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;

public class GroupPrincipal
implements Group {
    private String name;
    private Hashtable<String, Principal> members = new Hashtable();

    public GroupPrincipal(String name) {
        assert (name != null);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupPrincipal)) {
            return false;
        }
        GroupPrincipal that = (GroupPrincipal)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "GroupPrincipal[" + this.name + "]";
    }

    public boolean addMember(Principal user) {
        this.members.put(user.getName(), user);
        return true;
    }

    public boolean removeMember(Principal user) {
        this.members.remove(user.getName());
        return true;
    }

    public boolean isMember(Principal member) {
        return this.members.contains(member.getName());
    }

    public Enumeration<? extends Principal> members() {
        return this.members.elements();
    }
}

