/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.service.internal.PaxLoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class JdkHandler
extends Handler {
    private static final SecurityManagerEx securityManager = new SecurityManagerEx();
    private PaxLoggingService m_logService;

    public JdkHandler(PaxLoggingService logService) {
        this.m_logService = logService;
        this.setFormatter(new SimpleFormatter());
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        Level level = record.getLevel();
        String loggerName = record.getLoggerName();
        Bundle callerBundle = this.getCallerBundle();
        String fqcn = Logger.class.getName();
        PaxLoggerImpl logger = (PaxLoggerImpl)this.m_logService.getLogger(callerBundle, loggerName, fqcn);
        try {
            message = this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            message = record.getMessage();
        }
        Throwable throwable = record.getThrown();
        int levelInt = level.intValue();
        if (levelInt <= Level.FINEST.intValue()) {
            logger.trace(message, throwable);
        } else if (levelInt <= Level.FINE.intValue()) {
            logger.debug(message, throwable);
        } else if (levelInt <= Level.INFO.intValue()) {
            logger.inform(message, throwable);
        } else if (levelInt <= Level.WARNING.intValue()) {
            logger.warn(message, throwable);
        } else {
            logger.error(message, throwable);
        }
    }

    private Bundle getCallerBundle() {
        Bundle ret = null;
        Class[] classCtx = securityManager.getClassContext();
        for (int i = 0; i < classCtx.length; ++i) {
            if (classCtx[i].getName().startsWith("org.ops4j.pax.logging") || classCtx[i].getName().startsWith("java.util.logging")) continue;
            ret = FrameworkUtil.getBundle((Class)classCtx[i]);
            break;
        }
        return ret;
    }

    static class SecurityManagerEx
    extends SecurityManager {
        SecurityManagerEx() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

