/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.ldap.LDAPCache;
import org.apache.karaf.jaas.modules.ldap.LDAPOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPBackingEngine
implements BackingEngine {
    private LDAPCache cache;
    private LDAPOptions options;
    private static Logger LOGGER = LoggerFactory.getLogger(LDAPBackingEngine.class);

    public LDAPBackingEngine(Map<String, ?> options) {
        this.options = new LDAPOptions(options);
        this.cache = LDAPCache.getCache(this.options);
    }

    @Override
    public void addUser(String username, String password) {
        throw new UnsupportedOperationException("Adding a user is not supporting in LDAP");
    }

    @Override
    public void deleteUser(String username) {
        throw new UnsupportedOperationException("Deleting a user is not supporting in LDAP");
    }

    @Override
    public UserPrincipal lookupUser(String username) {
        DirContext context = null;
        try {
            context = this.cache.open();
            SearchControls controls = new SearchControls();
            if (this.options.getUserSearchSubtree()) {
                controls.setSearchScope(2);
            } else {
                controls.setSearchScope(1);
            }
            String filter = this.options.getUserFilter();
            filter = filter.replaceAll(Pattern.quote("%u"), username);
            filter = filter.replace("\\", "\\\\");
            LOGGER.debug("Looking for user {} in LDAP with", (Object)username);
            LOGGER.debug("   base DN: {}", (Object)this.options.getUserBaseDn());
            LOGGER.debug("   filter: {}", (Object)filter);
            NamingEnumeration<SearchResult> namingEnumeration = context.search(this.options.getUserBaseDn(), filter, controls);
            if (namingEnumeration.hasMore()) {
                return new UserPrincipal(username);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserPrincipal> listUsers() {
        DirContext context = null;
        ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
        try {
            context = this.cache.open();
            SearchControls controls = new SearchControls();
            if (this.options.getUserSearchSubtree()) {
                controls.setSearchScope(2);
            } else {
                controls.setSearchScope(1);
            }
            String filter = this.options.getUserFilter();
            filter = filter.replaceAll(Pattern.quote("%u"), "*");
            filter = filter.replace("\\", "\\\\");
            LOGGER.debug("Looking for the users in LDAP with ");
            LOGGER.debug("  base DN: " + this.options.getUserBaseDn());
            LOGGER.debug("  filter: " + filter);
            NamingEnumeration<SearchResult> namingEnumeration = context.search(this.options.getUserBaseDn(), filter, controls);
            try {
                while (namingEnumeration.hasMore()) {
                    String userDN;
                    SearchResult result = namingEnumeration.next();
                    String userDNNamespace = result.getNameInNamespace();
                    int indexOfUserBaseDN = userDNNamespace.toLowerCase().indexOf("," + this.options.getUserBaseDn().toLowerCase());
                    String userName = userDN = indexOfUserBaseDN > 0 ? userDNNamespace.substring(0, indexOfUserBaseDN) : result.getName();
                    if (userDN.contains("=")) {
                        userName = userDN.split("=")[1];
                    }
                    users.add(new UserPrincipal(userName));
                }
            }
            finally {
                if (namingEnumeration != null) {
                    try {
                        namingEnumeration.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
            return users;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<GroupPrincipal> listGroups(UserPrincipal user) {
        return Collections.emptyList();
    }

    @Override
    public Map<GroupPrincipal, String> listGroups() {
        return Collections.emptyMap();
    }

    @Override
    public void addGroup(String username, String group) {
        throw new UnsupportedOperationException("Adding a group is not supporting in LDAP");
    }

    @Override
    public void createGroup(String group) {
        throw new UnsupportedOperationException("Creating a group is not supporting in LDAP");
    }

    @Override
    public void deleteGroup(String username, String group) {
        throw new UnsupportedOperationException("Deleting a group is not supporting in LDAP");
    }

    @Override
    public List<RolePrincipal> listRoles(Principal principal) {
        try {
            String[] userAndNameSpace = this.cache.getUserDnAndNamespace(principal.getName());
            if (userAndNameSpace == null || userAndNameSpace.length < 2) {
                return Collections.emptyList();
            }
            ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
            for (String role : this.cache.getUserRoles(principal.getName(), userAndNameSpace[0], userAndNameSpace[1])) {
                roles.add(new RolePrincipal(role));
            }
            return roles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addRole(String username, String role) {
        throw new UnsupportedOperationException("Adding a role is not supporting in LDAP");
    }

    @Override
    public void deleteRole(String username, String role) {
        throw new UnsupportedOperationException("Deleting a role is not supporting in LDAP");
    }

    @Override
    public void addGroupRole(String group, String role) {
        throw new UnsupportedOperationException("Adding a group role is not supporting in LDAP");
    }

    @Override
    public void deleteGroupRole(String group, String role) {
        throw new UnsupportedOperationException("Deleting a group role is not supporting in LDAP");
    }
}

