/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;

public abstract class HtmlMessageRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlMessageRendererBase.class.getName());

    protected abstract String getSummary(FacesContext var1, UIComponent var2, FacesMessage var3, String var4);

    protected abstract String getDetail(FacesContext var1, UIComponent var2, FacesMessage var3, String var4);

    protected void renderMessage(FacesContext facesContext, UIComponent message) throws IOException {
        this.renderMessage(facesContext, message, false);
    }

    protected void renderMessage(FacesContext facesContext, UIComponent message, boolean alwaysRenderSpan) throws IOException {
        this.renderMessage(facesContext, message, alwaysRenderSpan, false);
    }

    protected void renderMessage(FacesContext facesContext, UIComponent message, boolean alwaysRenderSpan, boolean renderDivWhenNoMessagesAndIdSet) throws IOException {
        String forAttr = this.getFor(message);
        if (forAttr == null) {
            log.severe("Attribute 'for' of UIMessage must not be null");
            return;
        }
        UIComponent forComponent = message.findComponent(forAttr);
        if (forComponent == null) {
            log.severe("Could not render Message. Unable to find component '" + forAttr + "' (calling findComponent on component '" + message.getClientId(facesContext) + "'). If the provided id was correct, wrap the message and its component into an h:panelGroup or h:panelGrid.");
            return;
        }
        String clientId = forComponent.getClientId(facesContext);
        Iterator<FacesMessage> messageIterator = facesContext.getMessages(clientId);
        if (!messageIterator.hasNext()) {
            if (alwaysRenderSpan) {
                ResponseWriter writer = facesContext.getResponseWriter();
                writer.startElement("span", message);
                writer.writeAttribute("id", clientId + "_msgFor", null);
                HtmlRendererUtils.renderHTMLStringAttribute(writer, message, "style", "style");
                HtmlRendererUtils.renderHTMLStringAttribute(writer, message, "styleClass", "class");
                writer.endElement("span");
            } else if (renderDivWhenNoMessagesAndIdSet && message.getId() != null && !message.getId().startsWith("j_id")) {
                ResponseWriter writer = facesContext.getResponseWriter();
                writer.startElement("span", message);
                writer.writeAttribute("id", message.getClientId(facesContext), null);
                writer.endElement("span");
            }
            return;
        }
        FacesMessage facesMessage = messageIterator.next();
        if (!this.isRedisplay(message)) {
            while (facesMessage.isRendered()) {
                if (messageIterator.hasNext()) {
                    facesMessage = messageIterator.next();
                    continue;
                }
                return;
            }
        }
        this.renderSingleFacesMessage(facesContext, message, facesMessage, clientId);
    }

    protected void renderSingleFacesMessage(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String messageClientId) throws IOException {
        this.renderSingleFacesMessage(facesContext, message, facesMessage, messageClientId, true);
    }

    protected void renderSingleFacesMessage(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String messageClientId, boolean renderId) throws IOException {
        this.renderSingleFacesMessage(facesContext, message, facesMessage, messageClientId, renderId, true);
    }

    protected void renderSingleFacesMessage(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String messageClientId, boolean renderId, boolean renderStyleAndStyleClass) throws IOException {
        Map<String, List<ClientBehavior>> behaviors = null;
        if (message instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)message)).getClientBehaviors();
        }
        boolean wrapSpan = message.getId() != null && !message.getId().startsWith("j_id") || behaviors != null && !behaviors.isEmpty();
        this.renderSingleFacesMessage(facesContext, message, facesMessage, messageClientId, renderId, renderStyleAndStyleClass, wrapSpan);
    }

    protected void renderSingleFacesMessage(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String messageClientId, boolean renderId, boolean renderStyleAndStyleClass, boolean wrapSpan) throws IOException {
        boolean showDetail;
        String[] styleAndClass = HtmlMessageRendererBase.getStyleAndStyleClass(message, facesMessage.getSeverity());
        String style = styleAndClass[0];
        String styleClass = styleAndClass[1];
        String summary = this.getSummary(facesContext, message, facesMessage, messageClientId);
        String detail = this.getDetail(facesContext, message, facesMessage, messageClientId);
        String title = this.getTitle(message);
        boolean tooltip = this.isTooltip(message);
        boolean showSummary = this.isShowSummary(message) && summary != null;
        boolean bl = showDetail = this.isShowDetail(message) && detail != null;
        if (title == null && tooltip) {
            title = showDetail ? detail : (detail != null ? detail : summary);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean span = false;
        Map<String, List<ClientBehavior>> behaviors = null;
        if (message instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)message)).getClientBehaviors();
            boolean bl2 = wrapSpan = wrapSpan || !behaviors.isEmpty();
        }
        if (wrapSpan) {
            span = true;
            writer.startElement("span", message);
            if (behaviors != null && !behaviors.isEmpty()) {
                writer.writeAttribute("id", message.getClientId(facesContext), null);
            } else if (renderId) {
                HtmlRendererUtils.writeIdIfNecessary(writer, message, facesContext);
            }
            if (message instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)message)).getClientBehaviors();
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(message), message);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, CommonPropertyUtils.getCommonPropertiesMarked(message), CommonEventUtils.getCommonEventsMarked(message), message, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, message, behaviors);
                }
                HtmlRendererUtils.renderHTMLAttributes(writer, message, HTML.UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE_AND_TITLE);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, message, HTML.MESSAGE_PASSTHROUGH_ATTRIBUTES_WITHOUT_TITLE_STYLE_AND_STYLE_CLASS);
            }
        } else {
            span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, message, "span", HTML.MESSAGE_PASSTHROUGH_ATTRIBUTES_WITHOUT_TITLE_STYLE_AND_STYLE_CLASS);
        }
        span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "span", "title", title, span);
        if (renderStyleAndStyleClass) {
            span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "span", "style", style, span);
            span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "span", "styleClass", styleClass, span);
            span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "role", "role", message.getAttributes().get("role"), span);
        }
        if (showSummary && (title != null || !tooltip)) {
            writer.writeText(summary, null);
            if (showDetail) {
                writer.writeText(" ", null);
            }
        }
        if (showDetail) {
            writer.writeText(detail, null);
        }
        if (span) {
            writer.endElement("span");
        }
        facesMessage.rendered();
    }

    public static String[] getStyleAndStyleClass(UIComponent message, FacesMessage.Severity severity) {
        String style = null;
        String styleClass = null;
        if (message instanceof HtmlMessage) {
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = ((HtmlMessage)message).getInfoStyle();
                styleClass = ((HtmlMessage)message).getInfoClass();
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = ((HtmlMessage)message).getWarnStyle();
                styleClass = ((HtmlMessage)message).getWarnClass();
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = ((HtmlMessage)message).getErrorStyle();
                styleClass = ((HtmlMessage)message).getErrorClass();
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = ((HtmlMessage)message).getFatalStyle();
                styleClass = ((HtmlMessage)message).getFatalClass();
            }
            if (style == null) {
                style = ((HtmlMessage)message).getStyle();
            }
            if (styleClass == null) {
                styleClass = ((HtmlMessage)message).getStyleClass();
            }
        } else {
            Map<String, Object> attr = message.getAttributes();
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = (String)attr.get("infoStyle");
                styleClass = (String)attr.get("infoClass");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = (String)attr.get("warnStyle");
                styleClass = (String)attr.get("warnClass");
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = (String)attr.get("errorStyle");
                styleClass = (String)attr.get("errorClass");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = (String)attr.get("fatalStyle");
                styleClass = (String)attr.get("fatalClass");
            }
            if (style == null) {
                style = (String)attr.get("style");
            }
            if (styleClass == null) {
                styleClass = (String)attr.get("styleClass");
            }
        }
        return new String[]{style, styleClass};
    }

    protected String getFor(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    protected String getTitle(UIComponent component) {
        if (component instanceof HtmlMessage) {
            return ((HtmlMessage)component).getTitle();
        }
        return (String)component.getAttributes().get("title");
    }

    protected boolean isTooltip(UIComponent component) {
        if (component instanceof HtmlMessage) {
            return ((HtmlMessage)component).isTooltip();
        }
        return RendererUtils.getBooleanAttribute(component, "tooltip", false);
    }

    protected boolean isShowSummary(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).isShowSummary();
        }
        return RendererUtils.getBooleanAttribute(component, "showSummary", false);
    }

    protected boolean isShowDetail(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).isShowDetail();
        }
        return RendererUtils.getBooleanAttribute(component, "showDetail", false);
    }

    protected boolean isRedisplay(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).isRedisplay();
        }
        return RendererUtils.getBooleanAttribute(component, "redisplay", true);
    }
}

