/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.builder.FlowDefinition;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.flow.cdi.FlowBuilderFactoryBean;

public class FlowBuilderCDIExtension
implements Extension {
    private List<Producer<Flow>> flowProducers = new ArrayList<Producer<Flow>>();

    public List<Producer<Flow>> getFlowProducers() {
        return this.flowProducers;
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType flowDiscoveryHelper = beanManager.createAnnotatedType(FlowBuilderFactoryBean.class);
        event.addAnnotatedType(flowDiscoveryHelper, flowDiscoveryHelper.getJavaClass().getName());
    }

    <T> void findFlowDefinition(@Observes ProcessProducer<T, Flow> processProducer) {
        if (processProducer.getAnnotatedMember().isAnnotationPresent(FlowDefinition.class)) {
            this.flowProducers.add((Producer<Flow>)processProducer.getProducer());
        }
    }
}

