/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.FlowScoped;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.flow.FlowReference;
import org.apache.myfaces.flow.FlowUtils;
import org.apache.myfaces.flow.cdi.FlowScopeContextualStorageHolder;

@Typed
public class FlowScopeContext
implements Context {
    private final boolean passivatingScope;
    private BeanManager beanManager;
    private Map<Class, FlowReference> flowBeanReferences;

    public FlowScopeContext(BeanManager beanManager, Map<Class, FlowReference> flowBeanReferences) {
        this.beanManager = beanManager;
        this.flowBeanReferences = flowBeanReferences;
        this.passivatingScope = beanManager.isPassivatingScope(this.getScope());
    }

    protected FlowScopeContextualStorageHolder getStorageHolder(FacesContext facesContext) {
        return FlowScopeContextualStorageHolder.getInstance(facesContext, true);
    }

    public String getCurrentClientWindowFlowId(FacesContext facesContext) {
        String flowMapKey = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        if (flow != null) {
            flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        }
        return flowMapKey;
    }

    public Class<? extends Annotation> getScope() {
        return FlowScoped.class;
    }

    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        if (facesContext == null) {
            return false;
        }
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        return flow != null;
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    public boolean isPassivatingScope() {
        return this.passivatingScope;
    }

    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        FlowReference reference = this.flowBeanReferences.get(((Bean)bean).getBeanClass());
        if (reference != null) {
            String flowMapKey = FlowUtils.getFlowMapKey(facesContext, reference);
            if (flowMapKey != null) {
                Map<Object, ContextualInstanceInfo<?>> contextMap;
                ContextualInstanceInfo<?> contextualInstanceInfo;
                ContextualStorage storage = this.getContextualStorage(facesContext, false, flowMapKey);
                if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                    return (T)contextualInstanceInfo.getContextualInstance();
                }
            } else {
                throw new IllegalStateException("Flow " + reference.getId() + " cannot be found when resolving bean " + bean.toString());
            }
        }
        List<String> activeFlowMapKeys = this.getStorageHolder(facesContext).getActiveFlowMapKeys(facesContext);
        for (String flowMapKey : activeFlowMapKeys) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(facesContext, false, flowMapKey);
            if (storage == null || (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) == null) continue;
            return (T)contextualInstanceInfo.getContextualInstance();
        }
        return null;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (this.passivatingScope && !(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        FlowReference reference = this.flowBeanReferences.get(((Bean)bean).getBeanClass());
        if (reference != null) {
            Object instance2;
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            String flowMapKey = FlowUtils.getFlowMapKey(facesContext, reference);
            if (flowMapKey == null) {
                throw new IllegalStateException("Flow " + reference.getId() + " cannot be found when resolving bean " + bean.toString());
            }
            ContextualStorage storage = this.getContextualStorage(facesContext, false, flowMapKey);
            if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                return (T)contextualInstanceInfo.getContextualInstance();
            }
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            Flow flow = flowHandler.getFlow(facesContext, reference.getDocumentId() == null ? "" : reference.getDocumentId(), reference.getId());
            if (flow == null) {
                throw new IllegalStateException(bean.toString() + "cannot be created because flow " + reference.getId() + " is not registered");
            }
            if (!flowHandler.isActive(facesContext, flow.getDefiningDocumentId(), flow.getId())) {
                throw new IllegalStateException(bean.toString() + "cannot be created if flow " + reference.getId() + " is not active");
            }
            storage = this.getContextualStorage(facesContext, true, flowMapKey);
            Map<Object, ContextualInstanceInfo<?>> contextMap2 = storage.getStorage();
            ContextualInstanceInfo<?> contextualInstanceInfo2 = contextMap2.get(storage.getBeanKey(bean));
            if (contextualInstanceInfo2 != null && (instance2 = contextualInstanceInfo2.getContextualInstance()) != null) {
                return (T)instance2;
            }
            return storage.createContextualInstance(bean, creationalContext);
        }
        List<String> activeFlowMapKeys = this.getStorageHolder(facesContext).getActiveFlowMapKeys(facesContext);
        for (String flowMapKey : activeFlowMapKeys) {
            Object instance3;
            ContextualStorage storage = this.getContextualStorage(facesContext, true, flowMapKey);
            Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
            ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
            if (contextualInstanceInfo == null || (instance3 = contextualInstanceInfo.getContextualInstance()) == null) continue;
            return (T)instance3;
        }
        ContextualStorage storage = this.getContextualStorage(facesContext, true, this.getCurrentClientWindowFlowId(facesContext));
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    protected ContextualStorage getContextualStorage(FacesContext context, boolean createIfNotExist, String clientWindowFlowId) {
        if (clientWindowFlowId == null) {
            throw new ContextNotActiveException(this.getClass().getName() + ": no current active flow");
        }
        return this.getStorageHolder(context).getContextualStorage(clientWindowFlowId, createIfNotExist);
    }

    public static void destroyAll(FacesContext facesContext) {
        FlowScopeContextualStorageHolder manager = FlowScopeContextualStorageHolder.getInstance(facesContext);
        if (manager != null) {
            manager.destroyAll(facesContext);
        }
    }
}

