/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.DataInput;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClassByteCodeAnnotationFilter {
    private static final Logger log = Logger.getLogger(ClassByteCodeAnnotationFilter.class.getName());
    private static final int CP_INFO_CLASS = 7;
    private static final int CP_INFO_FIELD_REF = 9;
    private static final int CP_INFO_METHOD_REF = 10;
    private static final int CP_INFO_INTERFACE_REF = 11;
    private static final int CP_INFO_STRING = 8;
    private static final int CP_INFO_INTEGER = 3;
    private static final int CP_INFO_FLOAT = 4;
    private static final int CP_INFO_LONG = 5;
    private static final int CP_INFO_DOUBLE = 6;
    private static final int CP_INFO_NAME_AND_TYPE = 12;
    private static final int CP_INFO_UTF8 = 1;
    private static final int CP_INFO_METHOD_HANDLE = 15;
    private static final int CP_INFO_METHOD_TYPE = 16;
    private static final int CP_INFO_INVOKE_DYNAMIC = 18;

    ClassByteCodeAnnotationFilter() {
    }

    public static boolean couldContainAnnotationsOnClassDef(DataInput in, Set<String> byteCodeAnnotationsNames) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            return false;
        }
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        if (majorVersion < 49) {
            return false;
        }
        int constantsPoolCount = in.readUnsignedShort();
        block12: for (int i = 1; i < constantsPoolCount; ++i) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 1: {
                    String name = in.readUTF();
                    if (!byteCodeAnnotationsNames.contains(name)) continue block12;
                    return true;
                }
                case 7: {
                    in.readUnsignedShort();
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block12;
                }
                case 8: {
                    in.readUnsignedShort();
                    continue block12;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    continue block12;
                }
                case 5: 
                case 6: {
                    in.readInt();
                    in.readInt();
                    ++i;
                    continue block12;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block12;
                }
                case 15: {
                    in.readUnsignedByte();
                    in.readUnsignedShort();
                    continue block12;
                }
                case 16: {
                    in.readUnsignedShort();
                    continue block12;
                }
                case 18: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block12;
                }
                default: {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning("Unknown tag in constants pool: " + tag);
                    }
                    i = constantsPoolCount;
                }
            }
        }
        return false;
    }
}

