/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.config.view.View;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.startup.CodiStartupBroadcaster;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.InlineViewConfigRoot;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.DefaultViewConfigExtractor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewControllerWrapper;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.ViewConfigExtractor;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.phase.ViewControllerInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConfigExtension
implements Extension,
Deactivatable {
    private Logger logger = Logger.getLogger(ViewConfigExtension.class.getName());

    public void processPageDefinitions(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated()) {
            return;
        }
        CodiStartupBroadcaster.broadcastStartup();
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(InlineViewConfigRoot.class)) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(InlineViewConfigRoot.class.getName() + " found at " + processAnnotatedType.getAnnotatedType().getJavaClass().getName());
            }
            this.setInlineViewConfigRootMarker(processAnnotatedType.getAnnotatedType().getJavaClass());
            this.vetoBean(processAnnotatedType);
            return;
        }
        this.beginViewConfigExtraction();
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(Page.class)) {
            this.validateViewConfigDefinition(processAnnotatedType.getAnnotatedType().getJavaClass());
            Class beanClass = processAnnotatedType.getAnnotatedType().getJavaClass();
            ViewConfigExtractor viewConfigExtractor = this.getViewConfigExtractor();
            if (this.isInlineViewConfig(viewConfigExtractor, beanClass)) {
                this.addInlinePageDefinition(viewConfigExtractor, beanClass);
            } else {
                this.addPageDefinition(beanClass);
                this.vetoBean(processAnnotatedType);
            }
        }
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(View.class) && !processAnnotatedType.getAnnotatedType().getJavaClass().equals(ViewControllerInterceptor.class)) {
            this.addPageBean(processAnnotatedType.getAnnotatedType());
            processAnnotatedType.setAnnotatedType((AnnotatedType)new ViewControllerWrapper(processAnnotatedType.getAnnotatedType()));
        }
        this.endViewConfigExtraction();
    }

    protected void beginViewConfigExtraction() {
        ViewConfigCache.activateWriteMode();
    }

    protected void endViewConfigExtraction() {
        ViewConfigCache.deactivateWriteMode();
    }

    protected void setInlineViewConfigRootMarker(Class markerClass) {
        ViewConfigCache.setInlineViewConfigRootMarker(markerClass);
    }

    protected void addPageDefinition(Class<? extends ViewConfig> pageDefinitionClass) {
        ViewConfigDescriptor newEntry;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(pageDefinitionClass.getName() + " will be used as page-definition.");
        }
        if ((newEntry = this.createViewConfigDescriptor(pageDefinitionClass)) != null) {
            ViewConfigDescriptor existingDescriptor = ViewConfigCache.getViewConfigDescriptor(newEntry.getViewConfig());
            if (existingDescriptor instanceof EditableViewConfigDescriptor && ((EditableViewConfigDescriptor)existingDescriptor).isPartialViewConfig()) {
                for (PageBeanDescriptor pageBeanDescriptor : existingDescriptor.getPageBeanDescriptors()) {
                    if (!(newEntry instanceof EditableViewConfigDescriptor)) continue;
                    ((EditableViewConfigDescriptor)newEntry).addPageBean(pageBeanDescriptor.getBeanClass());
                }
                ViewConfigCache.replaceViewConfigDescriptor(newEntry.getViewId(), newEntry);
                return;
            }
            ViewConfigCache.addViewConfigDescriptor(newEntry.getViewId(), newEntry);
        }
    }

    protected boolean isInlineViewConfig(Class<? extends ViewConfig> beanClass) {
        return this.isInlineViewConfig(this.getViewConfigExtractor(), beanClass);
    }

    private boolean isInlineViewConfig(ViewConfigExtractor viewConfigExtractor, Class<? extends ViewConfig> beanClass) {
        return viewConfigExtractor.isInlineViewConfig(beanClass);
    }

    protected void addInlinePageDefinition(Class<? extends ViewConfig> beanClass) {
        this.addInlinePageDefinition(this.getViewConfigExtractor(), beanClass);
    }

    private void addInlinePageDefinition(ViewConfigExtractor viewConfigExtractor, Class<? extends ViewConfig> beanClass) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(beanClass.getName() + " will be used as inline-page-definition.");
        }
        ViewConfigCache.queueInlineViewConfig(viewConfigExtractor, beanClass);
    }

    private void addPageBean(AnnotatedType annotatedType) {
        View view = (View)annotatedType.getAnnotation(View.class);
        if (!"".equals(view.inline()[0])) {
            throw new IllegalStateException("Definition error at: " + annotatedType.getJavaClass().getName() + " it isn't allowed to define a class level @" + View.class.getName() + " without a typesafe view config. Please don't use @View(inline=\"...\") for this use-case!");
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(annotatedType.getJavaClass().getName() + " will be used as page-bean.");
        }
        for (Class viewConfigClass : view.value()) {
            ViewConfigDescriptor viewConfigDescriptor = ViewConfigCache.getViewConfigDescriptor(viewConfigClass);
            if (viewConfigDescriptor == null) {
                ViewConfigDescriptor entry = this.createViewConfigDescriptor(viewConfigClass);
                if (entry == null) continue;
                if (entry instanceof EditableViewConfigDescriptor) {
                    ((EditableViewConfigDescriptor)entry).addPageBean(annotatedType.getJavaClass());
                    ((EditableViewConfigDescriptor)entry).setPartialViewConfig(true);
                }
                ViewConfigCache.addViewConfigDescriptor(entry.getViewId(), entry);
                continue;
            }
            if (!(viewConfigDescriptor instanceof EditableViewConfigDescriptor)) continue;
            ((EditableViewConfigDescriptor)viewConfigDescriptor).addPageBean(annotatedType.getJavaClass());
        }
    }

    protected ViewConfigDescriptor createViewConfigDescriptor(Class<? extends ViewConfig> viewDefinitionClass) {
        if (Modifier.isAbstract(viewDefinitionClass.getModifiers())) {
            return null;
        }
        EditableViewConfigDescriptor result = this.getViewConfigExtractor().extractViewConfig(viewDefinitionClass);
        return result;
    }

    private void validateViewConfigDefinition(Class beanClass) {
        if (!ViewConfig.class.isAssignableFrom(beanClass)) {
            throw new IllegalArgumentException("the page definition " + beanClass.getName() + " has to implement " + ViewConfig.class.getName());
        }
    }

    private ViewConfigExtractor getViewConfigExtractor() {
        DefaultViewConfigExtractor defaultViewConfigExtractor = new DefaultViewConfigExtractor();
        ViewConfigExtractor viewConfigExtractor = (ViewConfigExtractor)CodiUtils.lookupFromEnvironment(ViewConfigExtractor.class, (Serializable[])new ViewConfigExtractor[]{defaultViewConfigExtractor});
        if (viewConfigExtractor == null) {
            viewConfigExtractor = defaultViewConfigExtractor;
        }
        return viewConfigExtractor;
    }

    private void vetoBean(ProcessAnnotatedType processAnnotatedType) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(processAnnotatedType.getAnnotatedType().getJavaClass().getName() + " won't be used as CDI bean");
        }
        processAnnotatedType.veto();
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(this.getClass());
    }
}

