/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval;

import java.beans.Introspector;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
class BeanAwareConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private ConstraintValidatorFactory constraintValidatorFactory;

    public BeanAwareConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.setConstraintValidatorFactory(constraintValidatorFactory);
    }

    public void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        if (constraintValidatorFactory == null) {
            throw new IllegalStateException("null is not allowed here");
        }
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    @ToDo(value=Priority.MEDIUM, description="allow the registration of a custom prefix")
    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> targetClass) {
        String validatorClassName = targetClass.getSimpleName();
        Object result = ExtValUtils.getELHelper().getBean(this.createBeanName(validatorClassName));
        if (result != null && targetClass.isAssignableFrom(result.getClass())) {
            return (T)((ConstraintValidator)result);
        }
        return (T)this.constraintValidatorFactory.getInstance(targetClass);
    }

    private String createBeanName(String validatorClassName) {
        return Introspector.decapitalize(validatorClassName);
    }
}

