/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class OnDemandFunctionSet
implements FunctionLibrary {
    private final Configuration config;
    private final NamespaceUri namespace;
    private final String libraryClass;
    private FunctionLibrary library;

    public OnDemandFunctionSet(Configuration config, NamespaceUri namespace, String libraryClass) {
        this.config = config;
        this.namespace = namespace;
        this.libraryClass = libraryClass;
    }

    private boolean load(SymbolicName.F functionName, List<String> reasons) {
        if (functionName.getComponentName().hasURI(this.namespace)) {
            if (this.library == null) {
                try {
                    Object lib = this.config.getDynamicLoader().getInstance(this.libraryClass, null);
                    if (!(lib instanceof FunctionLibrary)) {
                        if (reasons != null) {
                            reasons.add("Class " + this.libraryClass + " was loaded but it is not a FunctionLibrary");
                        }
                        return false;
                    }
                    this.library = (FunctionLibrary)lib;
                }
                catch (XPathException e) {
                    if (reasons != null) {
                        reasons.add("Failed to load class " + this.libraryClass + ": " + e.getMessage());
                    }
                    return false;
                }
            }
            this.library.setConfiguration(this.config);
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        boolean match = this.load(functionName, null);
        return match && this.library.isAvailable(functionName, languageLevel);
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) throws XPathException {
        boolean match = this.load(functionName, reasons);
        if (match) {
            if (keywords != null && !keywords.isEmpty()) {
                reasons.add("Calls to Saxon SQL functions cannot use keyword arguments");
                return null;
            }
            return this.library.bind(functionName, staticArgs, null, env, reasons);
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        boolean match = this.load(functionName, null);
        if (match) {
            return this.library.getFunctionItem(functionName, staticContext);
        }
        return null;
    }
}

