/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.config.localization;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.royale.compiler.internal.config.localization.ILocalizedText;
import org.apache.royale.compiler.internal.config.localization.ILocalizer;

public class LocalizationManager {
    private Locale locale = Locale.getDefault();
    private List<ILocalizer> localizers = new LinkedList<ILocalizer>();
    private static LocalizationManager instance = new LocalizationManager();

    public static LocalizationManager get() {
        return instance;
    }

    private LocalizationManager() {
    }

    public void addLocalizer(ILocalizer localizer) {
        this.localizers.add(localizer);
    }

    private ILocalizedText getLocalizedTextInner(Locale locale, String id) {
        for (ILocalizer localizer : this.localizers) {
            ILocalizedText text = localizer.getLocalizedText(locale, id);
            if (text == null) continue;
            return text;
        }
        return null;
    }

    private ILocalizedText getLocalizedText(Locale locale, String id) {
        ILocalizedText t = this.getLocalizedTextInner(locale, id);
        if (t == null && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
            t = this.getLocalizedTextInner(new Locale(locale.getLanguage(), locale.getCountry()), id);
        }
        if (t == null && locale.getCountry().length() > 0) {
            t = this.getLocalizedTextInner(new Locale(locale.getLanguage()), id);
        }
        return t;
    }

    protected static String replaceInlineReferences(String text, Map<String, Object> parameters) {
        int o;
        if (parameters == null) {
            return text;
        }
        int depth = 100;
        while (depth-- > 0 && (o = text.indexOf("${")) != -1 && (o < 1 || text.charAt(o - 1) != '$' || (o = text.indexOf("${", o + 2)) != -1)) {
            int c = text.indexOf("}", o);
            if (c == -1) {
                return null;
            }
            String name = text.substring(o + 2, c);
            String value = null;
            if (parameters.containsKey(name) && parameters.get(name) != null) {
                value = parameters.get(name).toString();
            }
            if (value == null) {
                value = "";
            }
            text = text.substring(0, o) + value + text.substring(c + 1);
        }
        return text.replaceAll("[$][$][{]", "\\${");
    }

    public String getLocalizedTextString(String id) {
        return this.getLocalizedTextString(id, Collections.emptyMap());
    }

    public String getLocalizedTextString(String id, Map<String, Object> parameters) {
        return this.getLocalizedTextString(this.locale, id, parameters);
    }

    public String getLocalizedTextString(Locale locale, String id, Map<String, Object> parameters) {
        ILocalizedText t = this.getLocalizedText(locale, id);
        if (t == null && !locale.equals(locale)) {
            t = this.getLocalizedText(locale, id);
        }
        if (t == null && !locale.getLanguage().equals("en")) {
            t = this.getLocalizedText(new Locale("en"), id);
        }
        return t == null ? null : t.format(parameters);
    }

    public String getLocalizedTextString(Object object) {
        String s = this.getLocalizedTextString(this.locale, object);
        return s;
    }

    public String getLocalizedTextString(Locale locale, Object object) {
        String subid;
        String id = object.getClass().getName().replaceAll("\\$", ".");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Class<?> c = object.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                try {
                    parameters.put(f.getName(), f.get(object));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        String s = null;
        if (parameters.containsKey("id") && parameters.get("id") != null && (subid = parameters.get("id").toString()).length() > 0) {
            s = this.getLocalizedTextString(locale, id + "." + subid, parameters);
        }
        if (s == null) {
            s = this.getLocalizedTextString(locale, id, parameters);
        }
        if (s == null) {
            s = id;
            if (parameters != null) {
                s = s + "[";
                Iterator it = parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    s = s + (String)e.getKey();
                    if (e.getValue() != null) {
                        s = s + "='" + e.getValue() + "'";
                    }
                    if (!it.hasNext()) continue;
                    s = s + ", ";
                }
                s = s + "]";
            }
            return s;
        }
        return s;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

