/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import java.util.Set;

public final class FunctionBuilder {
    private static final int IS_ABSTRACT = 1;
    private static final int IS_NATIVE = 2;
    private static final int INFERRED_RETURN_TYPE = 4;
    private static final int RETURNS_OWN_INSTANCE_TYPE = 8;
    private final JSTypeRegistry registry;
    private String name = null;
    private Node sourceNode = null;
    private Node parametersNode = null;
    private JSType returnType = null;
    private JSType typeOfThis = null;
    private ObjectType setPrototypeBasedOn = null;
    private TemplateTypeMap templateTypeMap = null;
    private Set<TemplateType> constructorOnlyKeys = ImmutableSet.of();
    private FunctionType.Kind kind = FunctionType.Kind.ORDINARY;
    private int properties = 0;

    public FunctionBuilder(JSTypeRegistry registry) {
        this.registry = registry;
    }

    public FunctionBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public FunctionBuilder withSourceNode(Node sourceNode) {
        this.sourceNode = sourceNode;
        return this;
    }

    public FunctionBuilder withParamsNode(Node parametersNode) {
        this.parametersNode = parametersNode;
        return this;
    }

    FunctionBuilder withEmptyParams() {
        this.parametersNode = this.registry.createEmptyParams();
        return this;
    }

    public FunctionBuilder withReturnType(JSType returnType) {
        this.returnType = returnType;
        return this;
    }

    public FunctionBuilder withReturnType(JSType returnType, boolean inferred) {
        this.returnType = returnType;
        this.properties = inferred ? this.properties | 4 : this.properties & 0xFFFFFFFB;
        return this;
    }

    FunctionBuilder withReturnsOwnInstanceType() {
        this.properties |= 8;
        return this;
    }

    public FunctionBuilder withInferredReturnType(JSType returnType) {
        this.returnType = returnType;
        this.properties |= 4;
        return this;
    }

    public FunctionBuilder withTypeOfThis(JSType typeOfThis) {
        this.typeOfThis = typeOfThis;
        return this;
    }

    public FunctionBuilder withTemplateKeys(ImmutableList<TemplateType> templateKeys) {
        this.templateTypeMap = this.registry.createTemplateTypeMap(templateKeys, null);
        return this;
    }

    public FunctionBuilder withTemplateKeys(TemplateType ... templateKeys) {
        this.templateTypeMap = this.registry.createTemplateTypeMap(ImmutableList.copyOf(templateKeys), null);
        return this;
    }

    FunctionBuilder withExtendedTemplate(TemplateType key, JSType value) {
        this.templateTypeMap = this.templateTypeMap.extend(this.registry.createTemplateTypeMap(ImmutableList.of(key), ImmutableList.of(value)));
        return this;
    }

    FunctionBuilder withTemplateTypeMap(TemplateTypeMap templateTypeMap) {
        this.templateTypeMap = templateTypeMap;
        return this;
    }

    public FunctionBuilder withConstructorTemplateKeys(Iterable<TemplateType> constructorOnlyKeys) {
        this.constructorOnlyKeys = ImmutableSet.copyOf(constructorOnlyKeys);
        return this;
    }

    FunctionBuilder withKind(FunctionType.Kind kind) {
        this.kind = kind;
        return this;
    }

    public FunctionBuilder forConstructor() {
        this.kind = FunctionType.Kind.CONSTRUCTOR;
        return this;
    }

    public FunctionBuilder forInterface() {
        this.kind = FunctionType.Kind.INTERFACE;
        this.parametersNode = this.registry.createEmptyParams();
        return this;
    }

    FunctionBuilder forNativeType() {
        this.properties |= 2;
        return this;
    }

    public FunctionBuilder withIsAbstract(boolean isAbstract) {
        this.properties = isAbstract ? this.properties | 1 : this.properties & 0xFFFFFFFE;
        return this;
    }

    public FunctionBuilder withPrototypeBasedOn(ObjectType setPrototypeBasedOn) {
        this.setPrototypeBasedOn = setPrototypeBasedOn;
        return this;
    }

    public FunctionBuilder copyFromOtherFunction(FunctionType otherType) {
        int isNative = otherType.isNativeObjectType() ? 2 : 0;
        int isAbstract = otherType.isAbstract() ? 1 : 0;
        int inferredReturnType = otherType.isReturnTypeInferred() ? 4 : 0;
        this.name = otherType.getReferenceName();
        this.sourceNode = otherType.getSource();
        this.parametersNode = otherType.getParametersNode();
        this.returnType = otherType.getReturnType();
        this.typeOfThis = otherType.getTypeOfThis();
        this.templateTypeMap = otherType.getTemplateTypeMap();
        this.kind = otherType.getKind();
        this.properties = isNative | isAbstract | inferredReturnType;
        return this;
    }

    public FunctionType build() {
        boolean hasConstructorOnlyKeys;
        boolean inferredReturnType = (this.properties & 4) != 0;
        boolean isNative = (this.properties & 2) != 0;
        boolean isAbstract = (this.properties & 1) != 0;
        boolean returnsOwnInstanceType = (this.properties & 8) != 0;
        boolean bl = hasConstructorOnlyKeys = !this.constructorOnlyKeys.isEmpty();
        if (hasConstructorOnlyKeys) {
            this.typeOfThis = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        }
        FunctionType ft = new FunctionType(this.registry, this.name, this.sourceNode, new ArrowType(this.registry, this.parametersNode, this.returnType, inferredReturnType), this.typeOfThis, this.templateTypeMap, this.kind, isNative, isAbstract);
        if (this.setPrototypeBasedOn != null) {
            ft.setPrototypeBasedOn(this.setPrototypeBasedOn);
        }
        if (returnsOwnInstanceType) {
            ft.getInternalArrowType().returnType = ft.getInstanceType();
        }
        if (hasConstructorOnlyKeys) {
            ft.setInstanceType(new InstanceObjectType(this.registry, ft, isNative, this.templateTypeMap.remove(this.constructorOnlyKeys)));
        }
        return ft;
    }
}

