/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLHelper {
    private static Pattern URL_PATTERN = Pattern.compile("^(.*?)(\\?.*?)?(#.*)?$");
    private String m_everythingBeforeQuery;
    private String m_query;
    private String m_fragment;

    public URLHelper(String string) {
        Matcher matcher = URL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        if (matcher.matches()) {
            this.m_everythingBeforeQuery = matcher.group(1);
            this.m_query = matcher.group(2);
            if (this.m_query == null) {
                this.m_query = "";
            }
            this.m_fragment = matcher.group(3);
            if (this.m_fragment == null) {
                this.m_fragment = "";
            }
        }
    }

    public String getEverythingBeforeQuery() {
        return this.m_everythingBeforeQuery;
    }

    public void setEverythingBeforeQuery(String string) {
        URLHelper.assertValidArguments(string, this.getQuery(), this.getFragment());
        this.m_everythingBeforeQuery = string;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void setQuery(String object) {
        if (((String)object).length() > 0 && ((String)object).charAt(0) != '?') {
            object = "?" + (String)object;
        }
        URLHelper.assertValidArguments(this.getEverythingBeforeQuery(), (String)object, this.getFragment());
        this.m_query = object;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setFragment(String object) {
        if (((String)object).length() > 0 && ((String)object).charAt(0) != '#') {
            object = "#" + (String)object;
        }
        URLHelper.assertValidArguments(this.getEverythingBeforeQuery(), this.getQuery(), (String)object);
        this.m_fragment = object;
    }

    private static void assertValidArguments(String string, String string2, String string3) {
        assert (URLHelper.areArgumentsValid(string, string2, string3));
    }

    private static boolean areArgumentsValid(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        URLHelper uRLHelper = new URLHelper(string + string2 + string3);
        return uRLHelper.getEverythingBeforeQuery().equals(string) && uRLHelper.getQuery().equals(string2) && uRLHelper.getFragment().equals(string3);
    }

    public String getURL() {
        return this.m_everythingBeforeQuery + this.m_query + this.m_fragment;
    }

    public LinkedHashMap<String, String> getParameterMap() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getQuery(), "?&");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(stringTokenizer.countTokens() * 2);
        while (stringTokenizer.hasMoreElements()) {
            String string;
            String string2 = string = stringTokenizer.nextToken();
            String string3 = "";
            int n = string.indexOf(61);
            if (n != -1 && (string2 = string.substring(0, n)).length() > 0) {
                string3 = string.substring(n + 1);
            }
            linkedHashMap.put(string2, string3);
        }
        return linkedHashMap;
    }

    public void setParameterMap(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string = entry.getKey();
                String string2 = String.valueOf(entry.getValue());
                stringBuilder.append(string);
                if (string2 != null && !string2.equals("")) {
                    stringBuilder.append('=');
                    stringBuilder.append(string2);
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append('&');
            }
            this.setQuery(stringBuilder.toString());
        } else {
            this.setQuery("");
        }
    }

    public static String escapeSpace(String string) {
        return URLHelper.escapeCharacter(string, ' ', "%20");
    }

    public static String escapeCharacter(String string, char c, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = string.indexOf(58);
        int n4 = 0;
        if (n3 > -1) {
            for (n = 0; n <= n3; ++n) {
                stringBuilder.append(string.charAt(n));
            }
            n4 = ++n3;
        }
        while ((n3 = string.indexOf(c, n3)) > -1) {
            for (n = n4; n < n3; ++n) {
                stringBuilder.append(string.charAt(n));
            }
            stringBuilder.append(string2);
            n4 = ++n3;
        }
        if (n4 < n2) {
            for (n = n4; n < n2; ++n) {
                stringBuilder.append(string.charAt(n));
            }
        }
        return stringBuilder.toString();
    }
}

