/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.fxg.FXGVersion;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.AbstractFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.DefinitionNode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContentNode;
import org.apache.royale.compiler.internal.fxg.dom.GroupNode;
import org.apache.royale.compiler.internal.fxg.dom.IMaskableNode;
import org.apache.royale.compiler.internal.fxg.dom.IMaskingNode;
import org.apache.royale.compiler.internal.fxg.dom.LibraryNode;
import org.apache.royale.compiler.internal.fxg.dom.MaskPropertyNode;
import org.apache.royale.compiler.internal.fxg.dom.PlaceObjectNode;
import org.apache.royale.compiler.internal.fxg.dom.types.MaskType;
import org.apache.royale.compiler.internal.fxg.dom.types.ScalingGrid;
import org.apache.royale.compiler.problems.FXGInvalidLibraryElementProblem;
import org.apache.royale.compiler.problems.FXGInvalidMaskElementProblem;
import org.apache.royale.compiler.problems.FXGInvalidNodeAttributeProblem;
import org.apache.royale.compiler.problems.FXGInvalidVersionProblem;
import org.apache.royale.compiler.problems.FXGMultipleElementProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class GraphicNode
extends AbstractFXGNode
implements IMaskableNode {
    private String documentPath = null;
    private FXGVersion version = null;
    public Map<String, Class<? extends IFXGNode>> reservedNodes;
    public double scaleGridLeft = 0.0;
    public double scaleGridTop = 0.0;
    public double scaleGridRight = 0.0;
    public double scaleGridBottom = 0.0;
    public double viewWidth = Double.NaN;
    public double viewHeight = Double.NaN;
    public MaskType maskType = MaskType.CLIP;
    protected boolean luminosityInvert = false;
    protected boolean luminosityClip = false;
    private boolean isVersionGreaterThanCompiler = false;
    public List<GraphicContentNode> children;
    public LibraryNode library;
    public IMaskingNode mask;
    private boolean definesScaleGrid;

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> childrenRes = new ArrayList<IFXGNode>();
        childrenRes.addAll(super.getChildren());
        if (this.children != null) {
            childrenRes.addAll(this.children);
        }
        childrenRes.add(this.library);
        childrenRes.add(this.mask);
        return childrenRes;
    }

    @Override
    public boolean isVersionGreaterThanCompiler() {
        return this.isVersionGreaterThanCompiler;
    }

    public void setVersionGreaterThanCompiler(boolean versionGreaterThanCompiler) {
        this.isVersionGreaterThanCompiler = versionGreaterThanCompiler;
    }

    @Override
    public String getDocumentPath() {
        return this.documentPath;
    }

    public void setDocumentPath(String documentPath) {
        this.documentPath = documentPath;
    }

    public FXGVersion getVersion() {
        return this.version;
    }

    public void setReservedNodes(Map<String, Class<? extends IFXGNode>> reservedNodes) {
        this.reservedNodes = reservedNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof MaskPropertyNode) {
            if (this.children != null) {
                problems.add(new FXGInvalidMaskElementProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            if (this.mask == null) {
                this.mask = ((MaskPropertyNode)child).mask;
                return;
            }
            problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn(), child.getNodeName()));
            return;
        }
        if (child instanceof LibraryNode) {
            if (this.mask != null || this.children != null) {
                problems.add(new FXGInvalidLibraryElementProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            if (this.library == null) {
                this.library = (LibraryNode)child;
                return;
            }
            problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn(), child.getNodeName()));
            return;
        }
        if (!(child instanceof GraphicContentNode)) {
            super.addChild(child, problems);
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList<GraphicContentNode>();
        }
        if (child instanceof GroupNode) {
            GroupNode group = (GroupNode)child;
            if (this.definesScaleGrid) {
                group.setInsideScaleGrid(true);
            }
        }
        this.children.add((GraphicContentNode)child);
    }

    @Override
    public String getNodeName() {
        return "Graphic";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("scaleGridLeft".equals(name)) {
            this.scaleGridLeft = DOMParserHelper.parseDouble(this, value, name, this.scaleGridLeft, problems);
            this.definesScaleGrid = true;
        } else if ("scaleGridTop".equals(name)) {
            this.scaleGridTop = DOMParserHelper.parseDouble(this, value, name, this.scaleGridTop, problems);
            this.definesScaleGrid = true;
        } else if ("scaleGridRight".equals(name)) {
            this.scaleGridRight = DOMParserHelper.parseDouble(this, value, name, this.scaleGridRight, problems);
            this.definesScaleGrid = true;
        } else if ("scaleGridBottom".equals(name)) {
            this.scaleGridBottom = DOMParserHelper.parseDouble(this, value, name, this.scaleGridBottom, problems);
            this.definesScaleGrid = true;
        } else if ("viewWidth".equals(name)) {
            this.viewWidth = DOMParserHelper.parseDouble(this, value, name, this.viewWidth, problems);
        } else if ("viewHeight".equals(name)) {
            this.viewHeight = DOMParserHelper.parseDouble(this, value, name, this.viewHeight, problems);
        } else if ("version".equals(name)) {
            try {
                this.version = FXGVersion.newInstance(DOMParserHelper.parseDouble(this, value, Double.MIN_VALUE, Double.MAX_VALUE));
            }
            catch (Exception e) {
                problems.add(new FXGInvalidVersionProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), value));
                return;
            }
        } else if ("maskType".equals(name)) {
            this.maskType = DOMParserHelper.parseMaskType(this, value, this.maskType, problems);
        } else {
            if (this.version != null && this.version.equalTo(FXGVersion.v1_0)) {
                problems.add(new FXGInvalidNodeAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), name, this.getNodeName()));
                return;
            }
            if ("luminosityInvert".equals(name)) {
                this.luminosityInvert = DOMParserHelper.parseBoolean(this, value, name, this.luminosityInvert, problems);
            } else if ("luminosityClip".equals(name)) {
                this.luminosityClip = DOMParserHelper.parseBoolean(this, value, name, this.luminosityClip, problems);
            } else {
                super.setAttribute(name, value, problems);
            }
        }
    }

    @Override
    public IMaskingNode getMask() {
        return this.mask;
    }

    @Override
    public MaskType getMaskType() {
        return this.maskType;
    }

    @Override
    public boolean getLuminosityClip() {
        return this.luminosityClip;
    }

    @Override
    public boolean getLuminosityInvert() {
        return this.luminosityInvert;
    }

    public PlaceObjectNode getDefinitionInstance(String name) {
        DefinitionNode definition;
        PlaceObjectNode instance = null;
        if (this.library != null && (definition = this.library.getDefinition(name)) != null) {
            instance = new PlaceObjectNode();
            instance.definition = definition;
        }
        return instance;
    }

    public ScalingGrid getScalingGrid() {
        ScalingGrid scalingGrid = null;
        if (this.definesScaleGrid()) {
            scalingGrid = new ScalingGrid();
            scalingGrid.scaleGridLeft = this.scaleGridLeft;
            scalingGrid.scaleGridTop = this.scaleGridTop;
            scalingGrid.scaleGridRight = this.scaleGridRight;
            scalingGrid.scaleGridBottom = this.scaleGridBottom;
        }
        return scalingGrid;
    }

    public boolean definesScaleGrid() {
        return this.definesScaleGrid;
    }
}

