/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class RewriteAsyncFunctions
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String ASYNC_ARGUMENTS = "$jscomp$async$arguments";
    private static final String ASYNC_THIS = "$jscomp$async$this";
    private static final String ASYNC_SUPER_PROP_GETTER_PREFIX = "$jscomp$async$super$get$";
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_FUNCTIONS);
    private final Deque<LexicalContext> contextStack;
    private final AbstractCompiler compiler;
    private final boolean rewriteSuperPropertyReferencesWithoutSuper;
    private final JSTypeRegistry registry;
    private final AstFactory astFactory;

    private RewriteAsyncFunctions(Builder builder) {
        Preconditions.checkNotNull(builder);
        this.compiler = builder.compiler;
        this.contextStack = new ArrayDeque<LexicalContext>();
        this.contextStack.addFirst(new LexicalContext());
        this.rewriteSuperPropertyReferencesWithoutSuper = builder.rewriteSuperPropertyReferencesWithoutSuper;
        this.registry = Preconditions.checkNotNull(builder.registry);
        this.astFactory = Preconditions.checkNotNull(builder.astFactory);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.addFirst(new LexicalContext(this.contextStack.getFirst(), n));
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext context = this.contextStack.getFirst();
        switch (n.getToken()) {
            case FUNCTION: {
                Preconditions.checkState(context.function == n, "unexpected function context:\nexpected: %s\nactual: %s", (Object)n, (Object)context.function);
                Preconditions.checkState(this.contextStack.removeFirst() == context);
                if (!context.isAsyncContext()) break;
                this.convertAsyncFunction(t, context);
                break;
            }
            case NAME: {
                if (!context.mustReplaceThisAndArguments() || !n.matchesQualifiedName("arguments")) break;
                n.setString(ASYNC_ARGUMENTS);
                context.recordAsyncArgumentsReplacementWasDone();
                this.compiler.reportChangeToChangeScope(context.function);
                break;
            }
            case THIS: {
                if (!context.mustReplaceThisAndArguments()) break;
                parent.replaceChild(n, context.createThisVariableReference());
                this.compiler.reportChangeToChangeScope(context.function);
                break;
            }
            case SUPER: {
                if (!context.mustReplaceThisAndArguments()) break;
                if (!parent.isGetProp()) {
                    this.compiler.report(JSError.make(parent, Es6ToEs3Util.CANNOT_CONVERT_YET, "super expression"));
                }
                Node superDotProperty = parent;
                SuperPropertyWrapperInfo superPropertyWrapperInfo = context.getOrCreateSuperPropertyWrapperInfo(superDotProperty);
                Node getPropReplacement = superPropertyWrapperInfo.createWrapperFunctionCallNode();
                Node grandparent = superDotProperty.getParent();
                if (grandparent.isCall() && grandparent.getFirstChild() == superDotProperty) {
                    getPropReplacement = this.astFactory.createGetProp(getPropReplacement, "call");
                    grandparent.addChildAfter(this.astFactory.createThisAliasReferenceForFunction(ASYNC_THIS, context.function).useSourceInfoFrom(superDotProperty), superDotProperty);
                    context.recordAsyncThisReplacementWasDone();
                }
                getPropReplacement.useSourceInfoFromForTree(superDotProperty);
                grandparent.replaceChild(superDotProperty, getPropReplacement);
                this.compiler.reportChangeToChangeScope(context.function);
                break;
            }
            case AWAIT: {
                Preconditions.checkState(context.isAsyncContext(), "await found within non-async function body");
                Preconditions.checkState(n.hasOneChild(), "await should have 1 operand, but has %s", n.getChildCount());
                parent.replaceChild(n, this.astFactory.createYield(n.getJSType(), n.removeFirstChild()));
                break;
            }
        }
    }

    private void convertAsyncFunction(NodeTraversal t, LexicalContext functionContext) {
        Node originalFunction = Preconditions.checkNotNull(functionContext.function);
        originalFunction.setIsAsyncFunction(false);
        Node originalBody = originalFunction.getLastChild();
        if (originalFunction.isFromExterns()) {
            if (!NodeUtil.isEmptyBlock(originalBody)) {
                originalBody.replaceWith(this.astFactory.createBlock());
                NodeUtil.markFunctionsDeleted(originalBody, this.compiler);
            }
            return;
        }
        Node newBody = this.astFactory.createBlock();
        originalFunction.replaceChild(originalBody, newBody);
        if (functionContext.mustAddAsyncThisVariable) {
            newBody.addChildToBack(this.astFactory.createThisAliasDeclarationForFunction(ASYNC_THIS, functionContext.function));
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
        if (functionContext.mustAddAsyncArgumentsVariable) {
            newBody.addChildToBack(this.astFactory.createArgumentsAliasDeclaration(ASYNC_ARGUMENTS));
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
        for (SuperPropertyWrapperInfo superPropertyWrapperInfo : functionContext.superPropertyWrappers.asCollection()) {
            Node arrowFunction = functionContext.createWrapperArrowFunction(superPropertyWrapperInfo);
            Node arrowFunctionDeclarationStatement = this.astFactory.createSingleConstNameDeclaration(superPropertyWrapperInfo.wrapperFunctionName, arrowFunction);
            newBody.addChildToBack(arrowFunctionDeclarationStatement);
            this.compiler.reportChangeToChangeScope(arrowFunction);
            Node enclosingScript = t.getCurrentFile();
            NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.ARROW_FUNCTIONS);
            NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.CONST_DECLARATIONS);
        }
        if (!originalBody.isBlock()) {
            originalBody = this.astFactory.createBlock(this.astFactory.createReturn(originalBody)).useSourceInfoIfMissingFromForTree(originalBody);
        }
        Node generatorFunction = this.astFactory.createZeroArgGeneratorFunction("", originalBody, originalFunction.getJSType());
        this.compiler.reportChangeToChangeScope(generatorFunction);
        NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.GENERATORS);
        newBody.addChildToBack(this.astFactory.createReturn(this.astFactory.createJscompAsyncExecutePromiseGeneratorFunctionCall(t.getScope(), generatorFunction)));
        newBody.useSourceInfoIfMissingFromForTree(originalBody);
        this.compiler.reportChangeToEnclosingScope(newBody);
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private boolean rewriteSuperPropertyReferencesWithoutSuper = false;
        private JSTypeRegistry registry;
        private AstFactory astFactory;

        Builder(AbstractCompiler compiler) {
            Preconditions.checkNotNull(compiler);
            this.compiler = compiler;
        }

        Builder rewriteSuperPropertyReferencesWithoutSuper(boolean value) {
            this.rewriteSuperPropertyReferencesWithoutSuper = value;
            return this;
        }

        RewriteAsyncFunctions build() {
            this.astFactory = this.compiler.createAstFactory();
            this.registry = this.compiler.getTypeRegistry();
            return new RewriteAsyncFunctions(this);
        }
    }

    private final class LexicalContext {
        @Nullable
        final Node function;
        @Nullable
        final LexicalContext asyncThisAndArgumentsContext;
        final SuperPropertyWrappers superPropertyWrappers;
        boolean mustAddAsyncThisVariable;
        boolean mustAddAsyncArgumentsVariable;

        LexicalContext() {
            this.superPropertyWrappers = new SuperPropertyWrappers();
            this.mustAddAsyncThisVariable = false;
            this.mustAddAsyncArgumentsVariable = false;
            this.function = null;
            this.asyncThisAndArgumentsContext = null;
        }

        LexicalContext(LexicalContext outer, Node function) {
            this.superPropertyWrappers = new SuperPropertyWrappers();
            this.mustAddAsyncThisVariable = false;
            this.mustAddAsyncArgumentsVariable = false;
            this.function = Preconditions.checkNotNull(function);
            this.asyncThisAndArgumentsContext = function.isAsyncFunction() ? (function.isArrowFunction() ? (outer.asyncThisAndArgumentsContext == null ? this : outer.asyncThisAndArgumentsContext) : this) : (function.isArrowFunction() ? outer.asyncThisAndArgumentsContext : null);
        }

        boolean isAsyncContext() {
            return this.function.isAsyncFunction();
        }

        boolean mustReplaceThisAndArguments() {
            return this.asyncThisAndArgumentsContext != null;
        }

        void recordAsyncThisReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncThisVariable = true;
        }

        SuperPropertyWrapperInfo getOrCreateSuperPropertyWrapperInfo(Node superDotPropertyNode) {
            return this.asyncThisAndArgumentsContext.superPropertyWrappers.getOrCreateSuperPropertyWrapperInfo(superDotPropertyNode);
        }

        void recordAsyncArgumentsReplacementWasDone() {
            this.asyncThisAndArgumentsContext.mustAddAsyncArgumentsVariable = true;
        }

        Node createThisVariableReference() {
            this.recordAsyncThisReplacementWasDone();
            return RewriteAsyncFunctions.this.astFactory.createThisAliasReferenceForFunction(RewriteAsyncFunctions.ASYNC_THIS, this.asyncThisAndArgumentsContext.function);
        }

        Node createThisReference() {
            return RewriteAsyncFunctions.this.astFactory.createThisForFunction(this.asyncThisAndArgumentsContext.function);
        }

        private Node createWrapperArrowFunction(SuperPropertyWrapperInfo wrapperInfo) {
            Node superDotProperty = wrapperInfo.firstInstanceOfSuperDotProperty.cloneTree();
            if (RewriteAsyncFunctions.this.rewriteSuperPropertyReferencesWithoutSuper) {
                Node thisNode = this.createThisReference();
                Node prototypeOfThisNode = RewriteAsyncFunctions.this.astFactory.createObjectGetPrototypeOfCall(thisNode);
                Node originalSuperNode = superDotProperty.getFirstChild();
                if (this.asyncThisAndArgumentsContext.function.getParent().isStaticMember()) {
                    originalSuperNode.replaceWith(prototypeOfThisNode);
                } else {
                    originalSuperNode.replaceWith(RewriteAsyncFunctions.this.astFactory.createObjectGetPrototypeOfCall(prototypeOfThisNode));
                }
            }
            return RewriteAsyncFunctions.this.astFactory.createZeroArgArrowFunctionForExpression(superDotProperty);
        }
    }

    private final class SuperPropertyWrappers {
        private final Map<String, SuperPropertyWrapperInfo> propertyNameToTypeMap = new LinkedHashMap<String, SuperPropertyWrapperInfo>();

        private SuperPropertyWrappers() {
        }

        private SuperPropertyWrapperInfo getOrCreateSuperPropertyWrapperInfo(Node superDotPropertyNode) {
            SuperPropertyWrapperInfo superPropertyWrapperInfo;
            Preconditions.checkArgument(superDotPropertyNode.isGetProp(), superDotPropertyNode);
            Node superNode = superDotPropertyNode.getFirstChild();
            Preconditions.checkArgument(superNode.isSuper(), superNode);
            Node propertyNameNode = superDotPropertyNode.getLastChild();
            Preconditions.checkArgument(propertyNameNode.isString(), propertyNameNode);
            String propertyName = propertyNameNode.getString();
            JSType propertyType = superDotPropertyNode.getJSType();
            if (this.propertyNameToTypeMap.containsKey(propertyName)) {
                superPropertyWrapperInfo = this.propertyNameToTypeMap.get(propertyName);
                JSType existingJSType = superPropertyWrapperInfo.getPropertyType();
                Preconditions.checkState(Objects.equals(existingJSType, propertyType), "Previous reference type: %s differs from current reference type: %s", (Object)existingJSType, (Object)propertyType);
            } else {
                superPropertyWrapperInfo = this.createNewInfo(superDotPropertyNode);
                this.propertyNameToTypeMap.put(propertyName, superPropertyWrapperInfo);
            }
            return superPropertyWrapperInfo;
        }

        private SuperPropertyWrapperInfo createNewInfo(Node firstSuperDotPropertyNode) {
            Preconditions.checkArgument(firstSuperDotPropertyNode.isGetProp(), firstSuperDotPropertyNode);
            String propertyName = firstSuperDotPropertyNode.getLastChild().getString();
            JSType propertyType = firstSuperDotPropertyNode.getJSType();
            String wrapperFunctionName = RewriteAsyncFunctions.ASYNC_SUPER_PROP_GETTER_PREFIX + propertyName;
            FunctionType wrapperFunctionType = propertyType == null ? null : new FunctionBuilder(RewriteAsyncFunctions.this.registry).withReturnType(propertyType).build();
            return new SuperPropertyWrapperInfo(firstSuperDotPropertyNode, wrapperFunctionName, wrapperFunctionType);
        }

        private Collection<SuperPropertyWrapperInfo> asCollection() {
            return this.propertyNameToTypeMap.values();
        }
    }

    private final class SuperPropertyWrapperInfo {
        private final Node firstInstanceOfSuperDotProperty;
        private final String wrapperFunctionName;
        @Nullable
        private final JSType wrapperFunctionType;

        private SuperPropertyWrapperInfo(Node firstSuperDotPropertyNode, String wrapperFunctionName, JSType wrapperFunctionType) {
            this.firstInstanceOfSuperDotProperty = firstSuperDotPropertyNode;
            this.wrapperFunctionName = wrapperFunctionName;
            this.wrapperFunctionType = wrapperFunctionType;
        }

        @Nullable
        private JSType getPropertyType() {
            return this.firstInstanceOfSuperDotProperty.getJSType();
        }

        private Node createWrapperFunctionNameNode() {
            return RewriteAsyncFunctions.this.astFactory.createName(this.wrapperFunctionName, this.wrapperFunctionType);
        }

        private Node createWrapperFunctionCallNode() {
            return RewriteAsyncFunctions.this.astFactory.createCall(this.createWrapperFunctionNameNode(), new Node[0]);
        }
    }
}

