/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Optional;
import org.apache.sis.metadata.internal.shared.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.NotSpatioTemporalException;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.temporal.TemporalObjects;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends ISOMetadata
implements TemporalExtent {
    private static final long serialVersionUID = -6149873501105795242L;
    private TemporalPrimitive extent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(Temporal beginning, Temporal ending) {
        this.extent = TemporalObjects.createPeriod(beginning, ending);
    }

    public DefaultTemporalExtent(TemporalExtent object) {
        super(object);
        if (object != null) {
            this.extent = object.getExtent();
        }
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent object) {
        if (object instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)object);
        }
        if (object == null || object instanceof DefaultTemporalExtent) {
            return (DefaultTemporalExtent)object;
        }
        return new DefaultTemporalExtent(object);
    }

    @XmlElement(name="extent", required=true)
    public TemporalPrimitive getExtent() {
        return this.extent;
    }

    public void setExtent(TemporalPrimitive newValue) {
        this.checkWritePermission(this.extent);
        this.extent = newValue;
    }

    static Temporal getBound(TemporalPrimitive extent, boolean begin) {
        if (extent instanceof Period) {
            Period p = (Period)extent;
            return (begin ? p.getBeginning() : p.getEnding()).getPosition();
        }
        return null;
    }

    public Optional<Temporal> getBeginning() {
        return Optional.ofNullable(DefaultTemporalExtent.getBound(this.extent, true));
    }

    public Optional<Temporal> getEnding() {
        return Optional.ofNullable(DefaultTemporalExtent.getBound(this.extent, false));
    }

    @Deprecated(since="1.5", forRemoval=true)
    public Date getStartTime() {
        return TemporalDate.toDate((Temporal)this.getBeginning().orElse(null));
    }

    @Deprecated(since="1.5", forRemoval=true)
    public Date getEndTime() {
        return TemporalDate.toDate((Temporal)this.getEnding().orElse(null));
    }

    @Deprecated(since="1.5", forRemoval=true)
    public void setBounds(Date startTime, Date endTime) {
        this.setBounds(startTime == null ? null : startTime.toInstant(), endTime == null ? null : endTime.toInstant());
    }

    public void setBounds(Temporal beginning, Temporal ending) {
        this.setExtent(TemporalObjects.createPeriod(beginning, ending));
    }

    public void setBounds(Envelope envelope) throws TransformException {
        this.checkWritePermission(this.extent);
        if (!ReferencingServices.getInstance().setBounds(envelope, this)) {
            throw new NotSpatioTemporalException(2, envelope);
        }
    }

    public void intersect(TemporalExtent other) {
        this.checkWritePermission(this.extent);
        TemporalPrimitive ot = other.getExtent();
        if (ot != null && !(this.extent instanceof NilObject)) {
            if (this.extent == null || ot instanceof NilObject) {
                this.extent = ot;
            } else {
                Temporal t0 = DefaultTemporalExtent.getBound(this.extent, true);
                Temporal t1 = DefaultTemporalExtent.getBound(this.extent, false);
                Temporal h0 = DefaultTemporalExtent.getBound(ot, true);
                Temporal h1 = DefaultTemporalExtent.getBound(ot, false);
                boolean changed = false;
                if (h0 != null && (t0 == null || TemporalDate.compare(h0, t0) > 0)) {
                    t0 = h0;
                    changed = true;
                }
                if (h1 != null && (t1 == null || TemporalDate.compare(h1, t1) < 0)) {
                    t1 = h1;
                    changed = true;
                }
                if (changed) {
                    if (t0 != null && t1 != null && TemporalDate.compare(t0, t1) > 0) {
                        this.extent = NilReason.MISSING.createNilObject(TemporalPrimitive.class);
                    } else {
                        this.setBounds(t0, t1);
                    }
                }
            }
        }
    }
}

