/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.metadata.MD_Scope;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.quality.Scope;
import org.opengis.util.InternationalString;

@XmlType(name="LI_Lineage_Type", propOrder={"statement", "scope", "documentation", "processSteps", "sources"})
@XmlRootElement(name="LI_Lineage")
public class DefaultLineage
extends ISOMetadata
implements Lineage {
    private static final long serialVersionUID = 6214461492323186254L;
    private InternationalString statement;
    private Scope scope;
    private Collection<Citation> additionalDocumentation;
    private Collection<ProcessStep> processSteps;
    private Collection<Source> sources;

    public DefaultLineage() {
    }

    public DefaultLineage(Lineage object) {
        super(object);
        if (object != null) {
            this.statement = object.getStatement();
            this.processSteps = DefaultLineage.copyCollection(object.getProcessSteps(), ProcessStep.class);
            this.sources = DefaultLineage.copyCollection(object.getSources(), Source.class);
            if (object instanceof DefaultLineage) {
                this.scope = ((DefaultLineage)object).getScope();
                this.additionalDocumentation = DefaultLineage.copyCollection(((DefaultLineage)object).getAdditionalDocumentation(), Citation.class);
            }
        }
    }

    public static DefaultLineage castOrCopy(Lineage object) {
        if (object == null || object instanceof DefaultLineage) {
            return (DefaultLineage)object;
        }
        return new DefaultLineage(object);
    }

    @XmlElement(name="statement")
    public InternationalString getStatement() {
        return this.statement;
    }

    public void setStatement(InternationalString newValue) {
        this.checkWritePermission(this.statement);
        this.statement = newValue;
    }

    @XmlElement(name="scope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    @UML(identifier="scope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission(this.scope);
        this.scope = newValue;
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentation() {
        this.additionalDocumentation = this.nonNullCollection(this.additionalDocumentation, Citation.class);
        return this.additionalDocumentation;
    }

    public void setAdditionalDocumentation(Collection<? extends Citation> newValues) {
        this.additionalDocumentation = this.writeCollection(newValues, this.additionalDocumentation, Citation.class);
    }

    @XmlElement(name="processStep")
    public Collection<ProcessStep> getProcessSteps() {
        this.processSteps = this.nonNullCollection(this.processSteps, ProcessStep.class);
        return this.processSteps;
    }

    public void setProcessSteps(Collection<? extends ProcessStep> newValues) {
        this.processSteps = this.writeCollection(newValues, this.processSteps, ProcessStep.class);
    }

    @XmlElement(name="source")
    public Collection<Source> getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public void setSources(Collection<? extends Source> newValues) {
        this.sources = this.writeCollection(newValues, this.sources, Source.class);
    }

    @XmlElement(name="additionalDocumentation")
    private Collection<Citation> getDocumentation() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAdditionalDocumentation() : null;
    }
}

