/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.lineage.NominalResolution;

@XmlType(name="LE_NominalResolution_Type", propOrder={"scanningResolution", "groundResolution"})
@XmlRootElement(name="LE_NominalResolution")
public class DefaultNominalResolution
extends ISOMetadata
implements NominalResolution {
    private static final long serialVersionUID = -4000422414866855607L;
    private Double scanningResolution;
    private Double groundResolution;

    public DefaultNominalResolution() {
    }

    public DefaultNominalResolution(NominalResolution object) {
        super(object);
        if (object != null) {
            this.scanningResolution = object.getScanningResolution();
            this.groundResolution = object.getGroundResolution();
        }
    }

    public static DefaultNominalResolution castOrCopy(NominalResolution object) {
        if (object == null || object instanceof DefaultNominalResolution) {
            return (DefaultNominalResolution)object;
        }
        return new DefaultNominalResolution(object);
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="scanningResolution")
    public Double getScanningResolution() {
        return this.scanningResolution;
    }

    public void setScanningResolution(Double newValue) {
        this.checkWritePermission(this.scanningResolution);
        if (ImplementationHelper.ensurePositive(DefaultNominalResolution.class, "scanningResolution", true, newValue)) {
            this.scanningResolution = newValue;
        }
    }

    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="groundResolution")
    public Double getGroundResolution() {
        return this.groundResolution;
    }

    public void setGroundResolution(Double newValue) {
        this.checkWritePermission(this.groundResolution);
        if (ImplementationHelper.ensurePositive(DefaultNominalResolution.class, "groundResolution", true, newValue)) {
            this.groundResolution = newValue;
        }
    }
}

