/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.NameToIdentifier;
import org.apache.sis.metadata.internal.shared.SecondaryTrait;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.internal.PositionalAccuracyConstant;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.InternationalString;

@SecondaryTrait(value=Datum.class)
public class DefaultDatumEnsemble<D extends Datum>
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -2757133322734036975L;
    private final List<D> members;
    private final PositionalAccuracy ensembleAccuracy;

    protected DefaultDatumEnsemble(Map<String, ?> properties, Collection<? extends D> members, PositionalAccuracy accuracy, Class<D> memberType) {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"accuracy", (Object)accuracy);
        this.ensembleAccuracy = accuracy;
        this.members = List.copyOf(members);
        this.validate(memberType);
    }

    protected DefaultDatumEnsemble(DefaultDatumEnsemble<? extends D> ensemble, Class<D> memberType) {
        super(ensemble);
        this.members = List.copyOf(ensemble.getMembers());
        this.ensembleAccuracy = Objects.requireNonNull(ensemble.getEnsembleAccuracy());
        this.validate(memberType);
    }

    private void validate(Class<D> memberType) {
        IdentifiedObject rs = null;
        for (Datum datum : this.members) {
            IdentifiedObject dr;
            if (datum instanceof DefaultDatumEnsemble) {
                throw new IllegalArgumentException(Errors.format((short)73, (Object)"members", DefaultDatumEnsemble.class));
            }
            if (!memberType.isInstance(datum)) {
                throw new ClassCastException(Errors.format((short)64, memberType, (Object)Classes.getClass((Object)datum)));
            }
            if (!(datum instanceof AbstractDatum) || (dr = (IdentifiedObject)((AbstractDatum)datum).getConventionalRS().orElse(null)) == null) continue;
            if (rs == null) {
                rs = dr;
                continue;
            }
            if (rs.equals((Object)dr)) continue;
            throw new IllegalArgumentException(Resources.format((short)103));
        }
    }

    public static <D extends Datum> DefaultDatumEnsemble<D> create(Map<String, ?> properties, Class<D> memberType, Collection<? extends D> members, PositionalAccuracy accuracy) {
        return Factory.forMemberType(memberType != null ? memberType : Datum.class, null, properties, List.copyOf(members), accuracy);
    }

    public <N extends Datum> DefaultDatumEnsemble<N> cast(Class<N> memberType) {
        for (Datum member : this.members) {
            if (memberType.isInstance(member)) continue;
            throw new ClassCastException(Errors.format((short)64, memberType, (Object)Classes.getClass((Object)member)));
        }
        DefaultDatumEnsemble<D> ensemble = this;
        if (!memberType.isInstance(ensemble)) {
            ensemble = Factory.forMemberType(memberType, ensemble, null, ensemble.members, ensemble.ensembleAccuracy);
        }
        return ensemble;
    }

    public final Collection<D> getMembers() {
        return this.members;
    }

    public PositionalAccuracy getEnsembleAccuracy() {
        return this.ensembleAccuracy;
    }

    public double getLinearAccuracy() {
        return PositionalAccuracyConstant.getLinearAccuracy(CollectionsExt.singletonOrEmpty((Object)this.getEnsembleAccuracy()));
    }

    public InternationalString getAnchorPoint() {
        return this.getCommonValue(Datum::getAnchorPoint);
    }

    public Date getRealizationEpoch() {
        return this.getCommonValue(Datum::getRealizationEpoch);
    }

    public Extent getDomainOfValidity() {
        return this.getCommonValue(Datum::getDomainOfValidity);
    }

    public InternationalString getScope() {
        return this.getCommonValue(Datum::getScope);
    }

    final <V> V getCommonValue(Function<D, V> getter) {
        block2: {
            V value;
            Iterator<D> it = this.members.iterator();
            if (it.hasNext() && (value = getter.apply((Datum)it.next())) != null) {
                while (it.hasNext()) {
                    if (value.equals(getter.apply((Datum)it.next()))) continue;
                    break block2;
                }
                return value;
            }
        }
        return null;
    }

    final <V> V getCommonMandatoryValue(Function<D, V> getter) {
        V other;
        Iterator<D> it = this.members.iterator();
        V value = getter.apply((Datum)it.next());
        if (it.hasNext() && !Objects.equals(value, other = getter.apply((Datum)it.next()))) {
            throw new GeodeticException(Errors.format((short)79, value instanceof IdentifiedObject ? IdentifiedObjects.getDisplayName((IdentifiedObject)value) : value, other instanceof IdentifiedObject ? IdentifiedObjects.getDisplayName((IdentifiedObject)other) : other));
        }
        return value;
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName((Identifier)super.getName(), super.getAlias(), (CharSequence)name, (NameToIdentifier.Simplifier)AbstractDatum.Simplifier.INSTANCE);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultDatumEnsemble that = (DefaultDatumEnsemble)object;
                return this.members.equals(that.members) && this.ensembleAccuracy.equals((Object)that.ensembleAccuracy);
            }
        }
        if (!(object instanceof DefaultDatumEnsemble)) {
            return false;
        }
        DefaultDatumEnsemble that = (DefaultDatumEnsemble)object;
        return Utilities.deepEquals(this.getMembers(), that.getMembers(), (ComparisonMode)mode) && Utilities.deepEquals((Object)this.getEnsembleAccuracy(), (Object)that.getEnsembleAccuracy(), (ComparisonMode)mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(7 * this.members.hashCode()) + (long)(37 * this.ensembleAccuracy.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        for (Datum member : this.getMembers()) {
            formatter.newLine();
            formatter.appendFormattable(member, AbstractDatum::castOrCopy);
        }
        this.complete(formatter);
        formatter.newLine();
        WKTUtilities.appendElementIfPositive("EnsembleAccuracy", this.getLinearAccuracy(), formatter);
        formatter.newLine();
        if (!formatter.getConvention().supports(Convention.WKT2_2019)) {
            formatter.setInvalidWKT(this, null);
        }
        return "Ensemble";
    }

    void complete(Formatter formatter) {
    }

    private static abstract class Factory<D extends Datum> {
        private final Class<D> memberType;
        private static final Factory<?>[] FACTORIES = new Factory[]{new Factory<GeodeticDatum>(GeodeticDatum.class){

            @Override
            DefaultDatumEnsemble<GeodeticDatum> copy(DefaultDatumEnsemble<? extends GeodeticDatum> object) {
                return new Geodetic(object);
            }

            @Override
            DefaultDatumEnsemble<GeodeticDatum> create(Map<String, ?> properties, List<? extends GeodeticDatum> members, PositionalAccuracy accuracy) {
                return new Geodetic(properties, members, accuracy);
            }
        }, new Factory<VerticalDatum>(VerticalDatum.class){

            @Override
            DefaultDatumEnsemble<VerticalDatum> copy(DefaultDatumEnsemble<? extends VerticalDatum> object) {
                return new Vertical(object);
            }

            @Override
            DefaultDatumEnsemble<VerticalDatum> create(Map<String, ?> properties, List<? extends VerticalDatum> members, PositionalAccuracy accuracy) {
                return new Vertical(properties, members, accuracy);
            }
        }, new Factory<TemporalDatum>(TemporalDatum.class){

            @Override
            DefaultDatumEnsemble<TemporalDatum> copy(DefaultDatumEnsemble<? extends TemporalDatum> object) {
                return new Time(object);
            }

            @Override
            DefaultDatumEnsemble<TemporalDatum> create(Map<String, ?> properties, List<? extends TemporalDatum> members, PositionalAccuracy accuracy) {
                return new Time(properties, members, accuracy);
            }
        }, new Factory<EngineeringDatum>(EngineeringDatum.class){

            @Override
            DefaultDatumEnsemble<EngineeringDatum> copy(DefaultDatumEnsemble<? extends EngineeringDatum> object) {
                return new Engineering(object);
            }

            @Override
            DefaultDatumEnsemble<EngineeringDatum> create(Map<String, ?> properties, List<? extends EngineeringDatum> members, PositionalAccuracy accuracy) {
                return new Engineering(properties, members, accuracy);
            }
        }, new Factory<Datum>(Datum.class){

            @Override
            DefaultDatumEnsemble<Datum> copy(DefaultDatumEnsemble<? extends Datum> object) {
                return new DefaultDatumEnsemble<Datum>(object, Datum.class);
            }

            @Override
            DefaultDatumEnsemble<Datum> create(Map<String, ?> properties, List<? extends Datum> members, PositionalAccuracy accuracy) {
                return new DefaultDatumEnsemble<Datum>(properties, members, accuracy, Datum.class);
            }
        }};

        private Factory(Class<D> memberType) {
            this.memberType = memberType;
        }

        static <D extends Datum> DefaultDatumEnsemble<D> forMemberType(Class<? extends Datum> memberType, DefaultDatumEnsemble<? extends D> object, Map<String, ?> properties, List<? extends D> members, PositionalAccuracy accuracy) {
            Object illegal = null;
            block0: for (Factory<?> factory : FACTORIES) {
                if (!memberType.isAssignableFrom(factory.memberType)) continue;
                for (D member : members) {
                    if (factory.memberType.isInstance(member)) continue;
                    illegal = member;
                    continue block0;
                }
                Factory<?> selected = factory;
                if (object != null) {
                    return selected.copy(object);
                }
                return selected.create(properties, members, accuracy);
            }
            throw new ClassCastException(Errors.format((short)64, memberType, (Object)Classes.getClass(illegal)));
        }

        abstract DefaultDatumEnsemble<D> create(Map<String, ?> var1, List<? extends D> var2, PositionalAccuracy var3);

        abstract DefaultDatumEnsemble<D> copy(DefaultDatumEnsemble<? extends D> var1);
    }

    static final class Engineering
    extends DefaultDatumEnsemble<EngineeringDatum>
    implements EngineeringDatum {
        private static final long serialVersionUID = -8978468990963666861L;

        static EngineeringDatum datum(DefaultDatumEnsemble<EngineeringDatum> ensemble) {
            return ensemble == null || ensemble instanceof EngineeringDatum ? (EngineeringDatum)ensemble : new Engineering(ensemble);
        }

        Engineering(DefaultDatumEnsemble<? extends EngineeringDatum> ensemble) {
            super(ensemble, EngineeringDatum.class);
        }

        Engineering(Map<String, ?> properties, List<? extends EngineeringDatum> members, PositionalAccuracy accuracy) {
            super(properties, members, accuracy, EngineeringDatum.class);
        }
    }

    static final class Time
    extends DefaultDatumEnsemble<TemporalDatum>
    implements TemporalDatum {
        private static final long serialVersionUID = -4208563828181087035L;

        static TemporalDatum datum(DefaultDatumEnsemble<TemporalDatum> ensemble) {
            return ensemble == null || ensemble instanceof TemporalDatum ? (TemporalDatum)ensemble : new Time(ensemble);
        }

        Time(DefaultDatumEnsemble<? extends TemporalDatum> ensemble) {
            super(ensemble, TemporalDatum.class);
        }

        Time(Map<String, ?> properties, List<? extends TemporalDatum> members, PositionalAccuracy accuracy) {
            super(properties, members, accuracy, TemporalDatum.class);
        }

        public Date getOrigin() {
            return this.getCommonMandatoryValue(TemporalDatum::getOrigin);
        }
    }

    static final class Vertical
    extends DefaultDatumEnsemble<VerticalDatum>
    implements VerticalDatum {
        private static final long serialVersionUID = 7242417944400289818L;

        static VerticalDatum datum(DefaultDatumEnsemble<VerticalDatum> ensemble) {
            return ensemble == null || ensemble instanceof VerticalDatum ? (VerticalDatum)ensemble : new Vertical(ensemble);
        }

        Vertical(DefaultDatumEnsemble<? extends VerticalDatum> ensemble) {
            super(ensemble, VerticalDatum.class);
        }

        Vertical(Map<String, ?> properties, List<? extends VerticalDatum> members, PositionalAccuracy accuracy) {
            super(properties, members, accuracy, VerticalDatum.class);
        }

        public VerticalDatumType getVerticalDatumType() {
            return this.getCommonValue(VerticalDatum::getVerticalDatumType);
        }
    }

    static final class Geodetic
    extends DefaultDatumEnsemble<GeodeticDatum>
    implements GeodeticDatum {
        private static final long serialVersionUID = 7669230365507661290L;

        static GeodeticDatum datum(DefaultDatumEnsemble<GeodeticDatum> ensemble) {
            return ensemble == null || ensemble instanceof GeodeticDatum ? (GeodeticDatum)ensemble : new Geodetic(ensemble);
        }

        Geodetic(DefaultDatumEnsemble<? extends GeodeticDatum> ensemble) {
            super(ensemble, GeodeticDatum.class);
        }

        Geodetic(Map<String, ?> properties, List<? extends GeodeticDatum> members, PositionalAccuracy accuracy) {
            super(properties, members, accuracy, GeodeticDatum.class);
        }

        public Ellipsoid getEllipsoid() {
            return this.getCommonMandatoryValue(GeodeticDatum::getEllipsoid);
        }

        public PrimeMeridian getPrimeMeridian() {
            return this.getCommonMandatoryValue(GeodeticDatum::getPrimeMeridian);
        }

        @Override
        void complete(Formatter formatter) {
            formatter.newLine();
            try {
                formatter.appendFormattable(this.getEllipsoid(), DefaultEllipsoid::castOrCopy);
            }
            catch (GeodeticException e) {
                formatter.setInvalidWKT(this, (Exception)e);
            }
        }
    }
}

