/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.metadata.internal.shared.NameMeaning;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;

final class AuthorityFactoryIdentifier {
    private static final Locale IDENTIFIER_LOCALE = Locale.US;
    final Type type;
    private String authority;
    private String version;

    private AuthorityFactoryIdentifier(Type type, String authority, String version) {
        this.type = type;
        this.authority = authority;
        this.version = version;
    }

    static AuthorityFactoryIdentifier create(Class<? extends AuthorityFactory> type, String authority, String version) {
        for (Type i : Type.values()) {
            if (!i.api.isAssignableFrom(type)) continue;
            return AuthorityFactoryIdentifier.create(i, authority, version);
        }
        throw new IllegalArgumentException();
    }

    static AuthorityFactoryIdentifier create(Type type, String authority, String version) {
        return new AuthorityFactoryIdentifier(type, authority.toUpperCase(IDENTIFIER_LOCALE), version == null ? null : version.toLowerCase(IDENTIFIER_LOCALE));
    }

    AuthorityFactoryIdentifier unversioned(String newAuthority) {
        if (this.version == null && newAuthority.equals(this.authority)) {
            return this;
        }
        return new AuthorityFactoryIdentifier(this.type, newAuthority.toUpperCase(IDENTIFIER_LOCALE), null);
    }

    AuthorityFactoryIdentifier versionOf(Citation factory) {
        String newVersion = NameMeaning.getVersion((Citation)factory);
        if (newVersion != null) {
            newVersion = newVersion.toLowerCase(IDENTIFIER_LOCALE);
        }
        if (Objects.equals(this.version, newVersion)) {
            return this;
        }
        return new AuthorityFactoryIdentifier(this.type, this.authority, newVersion);
    }

    AuthorityFactoryIdentifier newType(Type newType) {
        return new AuthorityFactoryIdentifier(newType, this.authority, this.version);
    }

    AuthorityFactoryIdentifier intern() {
        this.authority = this.authority.intern();
        if (this.version != null) {
            this.version = this.version.intern();
        }
        return this;
    }

    public int hashCode() {
        return this.type.hashCode() + 31 * this.authority.hashCode() + Objects.hashCode(this.version);
    }

    public boolean equals(Object other) {
        if (other instanceof AuthorityFactoryIdentifier) {
            AuthorityFactoryIdentifier that = (AuthorityFactoryIdentifier)other;
            if (this.type == that.type && this.authority.equals(that.authority)) {
                return Objects.equals(this.version, that.version);
            }
        }
        return false;
    }

    boolean isSameAuthority(AuthorityFactoryIdentifier other) {
        return this.authority.equals(other.authority);
    }

    CharSequence getAuthorityAndVersion() {
        String name = this.authority;
        if (this.hasVersion()) {
            name = Vocabulary.formatInternational((short)218, (Object[])new Object[]{name, this.version});
        }
        return name;
    }

    boolean hasVersion() {
        return this.version != null;
    }

    void logConflict(AuthorityFactory used) {
        this.log(Resources.forLocale(null).createLogRecord(Level.WARNING, (short)19, this.type.api, this.getAuthorityAndVersion(), Classes.getClass((Object)used)));
    }

    void logFallback() {
        this.log(Resources.forLocale(null).createLogRecord(Level.WARNING, (short)17, this.authority, this.version));
    }

    private void log(LogRecord record) {
        Logging.completeAndLog((Logger)GeodeticAuthorityFactory.LOGGER, MultiAuthoritiesFactory.class, (String)"getAuthorityFactory", (LogRecord)record);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this.type).append(':').append(this.authority);
        if (this.version != null) {
            buffer.append(':').append(this.version);
        }
        return buffer.toString();
    }

    static enum Type {
        CRS(CRSAuthorityFactory.class, CoordinateReferenceSystem.class),
        CS(CSAuthorityFactory.class, CoordinateSystem.class, CoordinateSystemAxis.class, Unit.class),
        DATUM(DatumAuthorityFactory.class, Datum.class, DefaultDatumEnsemble.class, Ellipsoid.class, PrimeMeridian.class),
        OPERATION(CoordinateOperationAuthorityFactory.class, CoordinateOperation.class, OperationMethod.class),
        GEODETIC(GeodeticAuthorityFactory.class, new Class[0]),
        ANY(AuthorityFactory.class, new Class[0]);

        final Class<? extends AuthorityFactory> api;
        private final Class<?>[] objects;

        private Type(Class<? extends AuthorityFactory> api, Class<?> ... objects) {
            this.api = api;
            this.objects = objects;
        }

        final boolean isGeneric() {
            return this.ordinal() >= GEODETIC.ordinal();
        }

        final boolean isFactoryOf(IdentifiedObject object) {
            return Classes.isAssignableToAny((Class)object.getClass(), (Class[])this.objects);
        }
    }
}

