/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.opengis.util.InternationalString;

final class ModifiableLocationTypeAdapter
extends ModifiableLocationType {
    private final ReferencingByIdentifiers referenceSystem;

    private ModifiableLocationTypeAdapter(AbstractLocationType type, Map<AbstractLocationType, ModifiableLocationTypeAdapter> previous) {
        super((CharSequence)type.getName());
        this.setTheme((CharSequence)type.getTheme());
        this.setDefinition((CharSequence)type.getDefinition());
        this.setTerritoryOfUse(type.getTerritoryOfUse());
        this.setOwner(type.getOwner());
        for (InternationalString internationalString : type.getIdentifications()) {
            this.addIdentification((CharSequence)internationalString);
        }
        this.referenceSystem = type.getReferenceSystem();
        for (AbstractLocationType abstractLocationType : type.getChildren()) {
            ModifiableLocationTypeAdapter p = previous.get(abstractLocationType);
            if (p == null) {
                p = new ModifiableLocationTypeAdapter(abstractLocationType, previous);
                previous.put(abstractLocationType, p);
            }
            p.addParent(this);
        }
    }

    static ModifiableLocationType copy(AbstractLocationType type) {
        if (type instanceof ModifiableLocationType) {
            return (ModifiableLocationType)type;
        }
        return new ModifiableLocationTypeAdapter(type, new IdentityHashMap<AbstractLocationType, ModifiableLocationTypeAdapter>());
    }

    static List<ModifiableLocationType> copy(List<? extends AbstractLocationType> types) {
        IdentityHashMap<AbstractLocationType, ModifiableLocationTypeAdapter> previous = new IdentityHashMap<AbstractLocationType, ModifiableLocationTypeAdapter>();
        Object[] nt = new ModifiableLocationType[types.size()];
        for (int i = 0; i < nt.length; ++i) {
            AbstractLocationType c = types.get(i);
            ModifiableLocationTypeAdapter p = (ModifiableLocationTypeAdapter)previous.get(c);
            if (p == null) {
                p = new ModifiableLocationTypeAdapter(c, previous);
                previous.put(c, p);
            }
            nt[i] = p;
        }
        return UnmodifiableArrayList.wrap((Object[])nt);
    }

    @Override
    public ReferencingByIdentifiers getReferenceSystem() {
        return this.referenceSystem;
    }
}

