/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.RasterFactory;
import org.apache.sis.image.internal.shared.TilePlaceholder;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.HyperRectangleReader;
import org.apache.sis.io.stream.Region;
import org.apache.sis.math.Vector;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.TiledGridCoverage;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.reader.ReversedBitsChannel;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;

class DataSubset
extends TiledGridCoverage
implements Localized {
    final DataCube source;
    private final Vector tileOffsets;
    private final Vector tileByteCounts;
    private final int numTiles;
    protected final int numBanks;
    protected final long sourceScanlineStride;
    protected final int sourcePixelStride;
    protected final int targetPixelStride;
    private TilePlaceholder emptyTiles;
    private static final Closeable NOOP = () -> {};

    DataSubset(DataCube source, TiledGridResource.Subset subset) throws DataStoreException {
        super(subset);
        int maxBank;
        this.source = source;
        this.numTiles = Math.toIntExact(source.getNumTiles());
        this.tileOffsets = source.getTileArrayInfo(false);
        this.tileByteCounts = source.getTileArrayInfo(true);
        if (this.model instanceof BandedSampleModel) {
            this.numBanks = this.model.getNumBands();
            this.targetPixelStride = 1;
            this.sourcePixelStride = 1;
            maxBank = this.includedBands != null ? this.includedBands[this.includedBands.length - 1] : this.numBanks - 1;
        } else {
            maxBank = 0;
            this.numBanks = 1;
            this.sourcePixelStride = source.getNumBands();
            this.targetPixelStride = this.model.getNumBands();
        }
        this.sourceScanlineStride = source.getScanlineStride(this.sourcePixelStride);
        int n = this.tileOffsets.size();
        if (maxBank >= n / this.numTiles) {
            throw new DataStoreContentException(source.reader.errors().getString((short)157, (Object)"tileOffsets", (Object)((maxBank + 1) * this.numTiles), (Object)n));
        }
    }

    public final Locale getLocale() {
        return this.source.listeners().getLocale();
    }

    protected final GenericName getIdentifier() {
        try {
            GenericName name = this.source.getIdentifier().orElse(null);
            if (name == null) {
                name = this.source.reader.store.createLocalName("overview");
            }
            return name;
        }
        catch (DataStoreException e) {
            this.source.listeners().warning((Exception)((Object)e));
            return Names.createLocalName(null, null, (CharSequence)Vocabulary.formatInternational((short)208));
        }
    }

    protected final DataType getDataType() {
        return DataType.forDataBufferType((int)this.model.getDataType());
    }

    protected final int getBankCapacity(int pixelsPerElement) {
        int targetScanlineStride = JDK18.ceilDiv((int)Math.multiplyExact(this.model.getWidth(), this.targetPixelStride), (int)pixelsPerElement);
        return Math.multiplyExact(targetScanlineStride, this.model.getHeight());
    }

    final ChannelDataInput input() throws IOException {
        ChannelDataInput input = this.source.reader.input;
        if (this.source.isBitOrderReversed()) {
            input = ReversedBitsChannel.wrap(input);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Raster[] readTiles(TiledGridCoverage.TileIterator iterator) throws IOException, DataStoreException {
        ChannelDataInput input = this.source.reader.input;
        int[] includedBanks = this.sourcePixelStride == 1 ? this.includedBands : null;
        Raster[] result = new Raster[iterator.tileCountInQuery];
        Object[] missings = new Tile[iterator.tileCountInQuery];
        int numMissings = 0;
        boolean needsCompaction = false;
        Object object = this.source.getSynchronizationLock();
        synchronized (object) {
            do {
                Raster tile;
                if ((tile = iterator.getCachedTile()) != null) {
                    result[iterator.getTileIndexInResultArray()] = tile;
                    continue;
                }
                Tile missing = new Tile((TiledGridCoverage.AOI)iterator, this.tileOffsets, includedBanks, this.numTiles);
                missings[numMissings++] = missing;
                if (includedBanks == null) {
                    missing.notifyInputChannel(this.tileOffsets, this.tileByteCounts, 0, this.numTiles, input);
                    continue;
                }
                for (int b : includedBanks) {
                    missing.notifyInputChannel(this.tileOffsets, this.tileByteCounts, b, this.numTiles, input);
                }
            } while (iterator.next());
            if (numMissings != 0) {
                Arrays.sort(missings, 0, numMissings);
                long[] lower = new long[2];
                long[] upper = new long[2];
                long[] subsampling = new long[2];
                Point origin = new Point();
                long[] offsets = new long[this.numBanks];
                long[] byteCounts = new long[this.numBanks];
                try (Closeable finisher = this.createInflater();){
                    for (int i = 0; i < numMissings; ++i) {
                        Object tile = missings[i];
                        if (tile.getRegionInsideTile(lower, upper, subsampling, false)) {
                            Raster r;
                            origin.x = ((Tile)tile).originX;
                            origin.y = ((Tile)tile).originY;
                            ((Tile)tile).copyTileInfo(this.tileOffsets, offsets, includedBanks, this.numTiles);
                            ((Tile)tile).copyTileInfo(this.tileByteCounts, byteCounts, includedBanks, this.numTiles);
                            boolean isEmpty = true;
                            for (int b = 0; b < offsets.length; ++b) {
                                isEmpty &= byteCounts[b] == 0L;
                            }
                            if (isEmpty) {
                                if (this.emptyTiles == null) {
                                    Object[] values = this.fillValues;
                                    if (values == null) {
                                        values = new Number[this.model.getNumBands()];
                                        Arrays.fill(values, (Object)0);
                                    }
                                    this.emptyTiles = TilePlaceholder.filled((SampleModel)this.model, (Number[])values);
                                }
                                r = this.emptyTiles.create(origin);
                            } else {
                                r = this.readSlice(offsets, byteCounts, lower, upper, subsampling, origin);
                            }
                            result[tile.getTileIndexInResultArray()] = tile.cache(r);
                            continue;
                        }
                        needsCompaction = true;
                    }
                }
            }
        }
        if (needsCompaction) {
            int n = 0;
            for (Raster tile : result) {
                if (tile == null) continue;
                result[n++] = tile;
            }
            return Arrays.copyOf(result, n);
        }
        return result;
    }

    Closeable createInflater() {
        return NOOP;
    }

    Raster readSlice(long[] offsets, long[] byteCounts, long[] lower, long[] upper, long[] subsampling, Point location) throws IOException, DataStoreException {
        DataType type = this.getDataType();
        int sampleSize = type.size();
        long width = Math.subtractExact(upper[0], lower[0]);
        long height = Math.subtractExact(upper[1], lower[1]);
        long length = JDK18.ceilDiv((long)(width * height * (long)this.sourcePixelStride * (long)sampleSize), (long)8L);
        long[] size = new long[]{this.sourceScanlineStride, this.getTileSize(1)};
        assert (this.sourcePixelStride == 1 || subsampling[0] == 1L);
        lower[0] = lower[0] * (long)this.sourcePixelStride;
        upper[0] = upper[0] * (long)this.sourcePixelStride;
        HyperRectangleReader hr = new HyperRectangleReader(ImageUtilities.toNumberEnum((DataType)type), this.input());
        Region region = new Region(size, lower, upper, subsampling);
        Buffer[] banks = new Buffer[this.numBanks];
        for (int b = 0; b < this.numBanks; ++b) {
            if (b < byteCounts.length && length > byteCounts[b]) {
                throw new DataStoreContentException(this.source.reader.resources().getString((short)28, length, byteCounts[b]));
            }
            hr.setOrigin(offsets[b]);
            assert (this.model.getSampleSize(b) == sampleSize);
            Buffer bank = hr.readAsBuffer(region, this.getBankCapacity(1));
            this.fillRemainingRows(bank, b);
            banks[b] = bank;
        }
        DataBuffer buffer = RasterFactory.wrap((DataType)type, (Buffer[])banks);
        return this.createWritableRaster(buffer, location);
    }

    final void fillRemainingRows(Buffer bank, int band) {
        int capacity;
        int limit;
        if (this.fillValues != null && (limit = bank.limit()) != (capacity = bank.capacity())) {
            Vector v = Vector.create((Object)bank.limit(capacity), (boolean)DataType.isUnsigned((SampleModel)this.model));
            Number f = this.fillValues[band];
            if (ArraysExt.allEquals((Object[])this.fillValues, (Object)f) || this.model instanceof BandedSampleModel) {
                v.fill(limit, capacity, f);
            } else {
                for (int i = limit; i < capacity; ++i) {
                    v.set(i, this.fillValues[i % this.fillValues.length]);
                }
            }
        }
    }

    final Raster createWritableRaster(DataBuffer buffer, Point location) {
        Number fill = this.source.getReplaceableFillValue();
        if (fill != null) {
            switch (buffer.getDataType()) {
                case 4: {
                    for (float[] bank : ((DataBufferFloat)buffer).getBankData()) {
                        ArraysExt.replace((float[])bank, (float)fill.floatValue(), (float)Float.NaN);
                    }
                    break;
                }
                case 5: {
                    for (double[] bank : ((DataBufferDouble)buffer).getBankData()) {
                        ArraysExt.replace((double[])bank, (double)fill.doubleValue(), (double)Double.NaN);
                    }
                    break;
                }
            }
        }
        return Raster.createWritableRaster(this.model, buffer, location);
    }

    private static final class Tile
    extends TiledGridCoverage.Snapshot
    implements Comparable<Tile> {
        private final long byteOffset;

        Tile(TiledGridCoverage.AOI domain, Vector tileOffsets, int[] includedBanks, int numTiles) {
            super(domain);
            int p = this.getTileIndexInResource();
            if (includedBanks != null) {
                p += includedBanks[0] * numTiles;
            }
            this.byteOffset = tileOffsets.longValue(p);
        }

        final void notifyInputChannel(Vector tileOffsets, Vector tileByteCounts, int b, int numTiles, ChannelDataInput input) {
            b = this.getTileIndexInResource() + b * numTiles;
            long offset = tileOffsets.longValue(b);
            long length = tileByteCounts.longValue(b);
            input.rangeOfInterest(offset, Numerics.saturatingAdd((long)offset, (long)length));
        }

        final void copyTileInfo(Vector source, long[] target, int[] includedBanks, int numTiles) {
            for (int j = 0; j < target.length; ++j) {
                int i = this.getTileIndexInResource() + numTiles * (includedBanks != null ? includedBanks[j] : j);
                target[j] = source.longValue(i);
            }
        }

        @Override
        public int compareTo(Tile other) {
            return Long.compare(this.byteOffset, other.byteOffset);
        }
    }
}

