/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Region;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.coverage.CoverageControls;
import org.apache.sis.gui.coverage.GridControls;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.coverage.ViewAndControls;
import org.apache.sis.gui.dataset.WindowHandler;
import org.apache.sis.gui.internal.DataStoreOpener;
import org.apache.sis.gui.internal.NonNullObjectProperty;
import org.apache.sis.gui.internal.PrivateAccess;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.internal.ToolbarButton;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;

@DefaultProperty(value="coverage")
public class CoverageExplorer
extends Widget {
    public final ObjectProperty<View> viewTypeProperty;
    public final ObjectProperty<GridCoverageResource> resourceProperty;
    public final ObjectProperty<GridCoverage> coverageProperty;
    private boolean isCoverageAdjusting;
    final RecentReferenceSystems referenceSystems;
    private final EnumMap<View, ViewAndControls> views = new EnumMap(View.class);
    private SplitPane content;
    private WindowHandler window;

    public CoverageExplorer(View type) {
        this.viewTypeProperty = new NonNullObjectProperty<View>(this, "viewType", Objects.requireNonNull(type));
        this.resourceProperty = new SimpleObjectProperty((Object)this, "resource");
        this.coverageProperty = new SimpleObjectProperty((Object)this, "coverage");
        this.referenceSystems = new RecentReferenceSystems();
        this.referenceSystems.addUserPreferences();
        this.referenceSystems.addAlternatives("EPSG:4326", "EPSG:3395", "MGRS");
        this.viewTypeProperty.addListener((p, o, n) -> this.onViewTypeSet((View)((Object)n)));
        this.resourceProperty.addListener((p, o, n) -> this.onPropertySet((GridCoverageResource)n, null, this.coverageProperty));
        this.coverageProperty.addListener((p, o, n) -> this.onPropertySet(null, (GridCoverage)n, this.resourceProperty));
    }

    public CoverageExplorer(CoverageExplorer source) {
        this(source.getViewType());
        this.window = PrivateAccess.newWindowHandler.apply(source.window, this);
        source.getImageRequest().ifPresent(this::setCoverage);
        PrivateAccess.finishWindowHandler.accept(this.window);
        if (this.getViewType() == View.IMAGE) {
            this.getCoverageControls().copyStyling(source.getCoverageControls());
        }
    }

    public final WindowHandler getWindowHandler() {
        assert (Platform.isFxApplicationThread());
        if (this.window == null) {
            this.window = WindowHandler.create(this);
        }
        return this.window;
    }

    public final CoverageCanvas getCanvas() {
        return this.getCoverageControls().view;
    }

    private CoverageControls getCoverageControls() {
        return (CoverageControls)this.getViewAndControls(View.IMAGE, false);
    }

    private ViewAndControls getViewAndControls(View type, boolean load) {
        ViewAndControls c = this.views.get((Object)type);
        if (c == null) {
            switch (type.ordinal()) {
                case 1: {
                    c = new GridControls(this);
                    break;
                }
                case 0: {
                    c = new CoverageControls(this, this.getWindowHandler());
                    break;
                }
                default: {
                    throw new AssertionError((Object)type);
                }
            }
            this.views.put(type, c);
            load = true;
        }
        if (load) {
            this.getImageRequest().ifPresent(c::load);
        }
        return c;
    }

    @Override
    public final Region getView() {
        assert (Platform.isFxApplicationThread());
        if (this.content == null) {
            ToggleGroup group = new ToggleGroup();
            Control[] buttons = new Control[3];
            Resources localized = Resources.forLocale(this.getLocale());
            buttons[0] = new Separator();
            for (View type : View.values()) {
                buttons[1 + type.ordinal()] = new Selector(type).createButton(group, type.icon, type.fallback, localized, type.tooltip);
            }
            View type = this.getViewType();
            ViewAndControls c = this.getViewAndControls(type, false);
            group.selectToggle((Toggle)group.getToggles().get(type.ordinal()));
            this.content = new SplitPane(new Node[]{c.controls(), c.viewAndNavigation});
            ToolbarButton.insert((Node)this.content, buttons);
            this.content.setDividerPosition(0, 1.0);
        }
        return this.content;
    }

    public final Region getDataView(View type) {
        assert (Platform.isFxApplicationThread());
        return this.getViewAndControls((View)Objects.requireNonNull(type), (boolean)false).viewAndNavigation;
    }

    public final TitledPane[] getControls(View type) {
        assert (Platform.isFxApplicationThread());
        return (TitledPane[])this.getViewAndControls((View)Objects.requireNonNull(type), (boolean)false).controlPanes.clone();
    }

    public final View getViewType() {
        return (View)((Object)this.viewTypeProperty.get());
    }

    public final void setViewType(View type) {
        this.viewTypeProperty.set((Object)type);
    }

    private void onViewTypeSet(View type) {
        ViewAndControls c = this.getViewAndControls(type, true);
        if (this.content != null) {
            this.content.getItems().setAll((Object[])new Node[]{c.controls(), c.viewAndNavigation});
            Toggle selector = c.selector;
            if (selector != null) {
                selector.setSelected(true);
            }
        }
    }

    public final GridCoverageResource getResource() {
        return (GridCoverageResource)this.resourceProperty.get();
    }

    public final void setResource(GridCoverageResource resource) {
        this.resourceProperty.set((Object)resource);
    }

    public final GridCoverage getCoverage() {
        return (GridCoverage)this.coverageProperty.get();
    }

    public final void setCoverage(GridCoverage coverage) {
        this.coverageProperty.set((Object)coverage);
    }

    public final void setCoverage(ImageRequest source) {
        assert (Platform.isFxApplicationThread());
        ViewAndControls current = this.getViewAndControls(this.getViewType(), false);
        for (ViewAndControls c : this.views.values()) {
            c.load(c == current ? source : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPropertySet(GridCoverageResource resource, GridCoverage coverage, ObjectProperty<?> toClear) {
        if (!this.isCoverageAdjusting) {
            this.isCoverageAdjusting = true;
            try {
                toClear.set(null);
            }
            finally {
                this.isCoverageAdjusting = false;
            }
            this.setCoverage(resource != null || coverage != null ? new ImageRequest(resource, coverage, null) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyDataChanged(GridCoverageResource resource, GridCoverage coverage) {
        if (coverage != null) {
            String name;
            block6: {
                try {
                    name = DataStoreOpener.findLabel((Resource)resource, this.getLocale(), true);
                }
                catch (DataStoreException e) {
                    name = e.getLocalizedMessage();
                    if (name != null) break block6;
                    name = ((Object)((Object)e)).getClass().getSimpleName();
                }
            }
            this.referenceSystems.setGridReferencing(true, Map.of(name, coverage.getGridGeometry()));
        }
        this.isCoverageAdjusting = true;
        try {
            this.setResource(resource);
            this.setCoverage(coverage);
        }
        finally {
            this.isCoverageAdjusting = false;
        }
    }

    private Optional<ImageRequest> getImageRequest() {
        GridCoverageResource resource = this.getResource();
        GridCoverage coverage = this.getCoverage();
        if (resource != null || coverage != null) {
            ImageRequest request = new ImageRequest(resource, coverage, null);
            CoverageControls c = (CoverageControls)this.views.get((Object)View.IMAGE);
            if (c != null) {
                try {
                    request.zoom = c.view.getGridGeometry();
                }
                catch (RenderException e) {
                    CoverageCanvas.unexpectedException("getGridGeometry", (Exception)((Object)e));
                }
            }
            return Optional.of(request);
        }
        return Optional.empty();
    }

    public static enum View {
        IMAGE('\uea56', "\ud83d\uddfa\ufe0f", 33),
        TABLE('\ueb20', "\ud83d\udd22\ufe0f", 34);

        static final int COUNT = 2;
        final char icon;
        final String fallback;
        final short tooltip;

        private View(char icon, String fallback, short tooltip) {
            this.icon = icon;
            this.fallback = fallback;
            this.tooltip = tooltip;
        }
    }

    private final class Selector
    extends ToolbarButton {
        private final View type;

        Selector(View type) {
            this.type = type;
        }

        @Override
        public void handle(ActionEvent event) {
            Toggle button = (Toggle)event.getSource();
            if (button.isSelected()) {
                CoverageExplorer.this.setViewType(this.type);
                CoverageExplorer.this.views.get((Object)((Object)this.type)).selector = button;
            } else {
                button.setSelected(true);
            }
        }
    }
}

