/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.impl.ConfigHolder;
import org.apache.sling.commons.scheduler.impl.MetricsHelper;
import org.apache.sling.commons.scheduler.impl.QuartzScheduler;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzJobExecutor
implements org.quartz.Job {
    static final int DEFAULT_SLOW_JOB_THRESHOLD_MILLIS = 1000;
    public static final AtomicBoolean DISCOVERY_AVAILABLE = new AtomicBoolean(false);
    public static final AtomicBoolean DISCOVERY_INFO_AVAILABLE = new AtomicBoolean(false);
    public static volatile String SLING_ID;
    public static final AtomicBoolean FORCE_LEADER;
    public static final AtomicBoolean IS_LEADER;
    public static final AtomicReference<String[]> SLING_IDS;

    private boolean checkDiscoveryAvailable(Logger logger, JobDesc desc) {
        if (DISCOVERY_AVAILABLE.get()) {
            if (DISCOVERY_INFO_AVAILABLE.get()) {
                return true;
            }
            logger.debug("No discovery info available. Excluding {}.", (Object)desc);
            return false;
        }
        logger.debug("No discovery available, therefore not executing {}.", (Object)desc);
        return false;
    }

    private String checkSlingId(Logger logger, JobDesc desc) {
        String myId = SLING_ID;
        if (myId == null) {
            logger.error("No Sling ID available, therefore not executing {}.", (Object)desc);
            return null;
        }
        return myId;
    }

    private boolean shouldRun(Logger logger, JobDesc desc) {
        if (desc.runOn != null) {
            if (desc.isRunOnLeader()) {
                if (!this.checkDiscoveryAvailable(logger, desc)) {
                    return false;
                }
                if (!IS_LEADER.get()) {
                    logger.debug("Excluding {} - instance is not leader", (Object)desc);
                    return false;
                }
            } else if (desc.isRunOnSingle()) {
                if (!this.checkDiscoveryAvailable(logger, desc)) {
                    return false;
                }
                if (FORCE_LEADER.get()) {
                    if (!IS_LEADER.get()) {
                        logger.debug("Excluding {} - instance is not leader", (Object)desc);
                        return false;
                    }
                } else {
                    String myId = this.checkSlingId(logger, desc);
                    if (myId == null) {
                        return false;
                    }
                    if (desc.shouldRunAsSingleOn() != null) {
                        logger.debug("Excluding {} - distributed to different Sling instance", (Object)desc);
                        return false;
                    }
                }
            } else {
                String myId = this.checkSlingId(logger, desc);
                if (myId == null) {
                    return false;
                }
                boolean schedule = false;
                for (String id : desc.runOn) {
                    if (!myId.equals(id)) continue;
                    schedule = true;
                    break;
                }
                if (!schedule) {
                    logger.debug("Excluding job {} - different Sling ID", (Object)desc);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        JobDesc desc = new JobDesc(data);
        Logger logger = (Logger)data.get("QuartzJobScheduler.Logger");
        if (!this.shouldRun(logger, desc)) {
            return;
        }
        desc.measureJobStart();
        String origThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(origThreadName + "-" + desc.name);
            logger.debug("Executing job {}", (Object)desc);
            if (desc.job instanceof Job) {
                Map configuration = (Map)data.get("QuartzJobScheduler.Configuration");
                JobContextImpl jobCtx = new JobContextImpl(desc.name, configuration);
                ((Job)desc.job).execute(jobCtx);
            } else if (desc.job instanceof Runnable) {
                ((Runnable)desc.job).run();
            } else {
                logger.error("Scheduled job {} is neither a job nor a runnable: {}", (Object)desc);
            }
        }
        catch (Throwable t) {
            if (t instanceof JobExecutionException) {
                throw (JobExecutionException)t;
            }
            logger.error("Exception during job execution of " + desc + " : " + t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setName(origThreadName);
            desc.measureJobEnd();
        }
    }

    static {
        FORCE_LEADER = new AtomicBoolean(true);
        IS_LEADER = new AtomicBoolean(true);
        SLING_IDS = new AtomicReference<Object>(null);
    }

    public static final class JobContextImpl
    implements JobContext {
        protected final Map<String, Serializable> configuration;
        protected final String name;

        public JobContextImpl(String name, Map<String, Serializable> config) {
            this.name = name;
            this.configuration = config;
        }

        @Override
        public Map<String, Serializable> getConfiguration() {
            return this.configuration;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class JobDesc {
        public final Object job;
        public final String providedName;
        public final String name;
        public final String[] runOn;
        private final MetricRegistry metricRegistry;
        private final Counter runningJobsCounter;
        private final Counter overallRunningJobsCounter;
        private final Timer jobDurationTimer;
        private final long slowThresholdMillis;
        private long jobStart = -1L;

        public JobDesc(JobDataMap data) {
            this.job = data.get("QuartzJobScheduler.Object");
            this.name = (String)data.get("QuartzJobScheduler.JobName");
            this.providedName = (String)data.get("QuartzJobScheduler.ProvidedJobName");
            this.runOn = (String[])data.get("QuartzJobScheduler.runOn");
            QuartzScheduler localQuartzScheduler = (QuartzScheduler)data.get("QuartzJobScheduler.QuartzScheduler");
            MetricRegistry localMetricsService = null;
            ConfigHolder localConfigHolder = null;
            if (localQuartzScheduler != null) {
                localMetricsService = localQuartzScheduler.metricsRegistry;
                localConfigHolder = localQuartzScheduler.configHolder;
            }
            this.slowThresholdMillis = localConfigHolder != null ? localConfigHolder.slowThresholdMillis() : 1000L;
            String metricsSuffix = "";
            String filterName = MetricsHelper.deriveFilterName(localConfigHolder, this.job);
            if (filterName != null) {
                metricsSuffix = ".filter." + filterName;
            } else {
                String threadPoolName = data.getString("QuartzJobScheduler.threadPoolName");
                if (threadPoolName != null) {
                    metricsSuffix = ".tp." + threadPoolName;
                }
            }
            if (localMetricsService != null) {
                this.metricRegistry = localMetricsService;
                this.runningJobsCounter = this.metricRegistry.counter("commons.scheduler.running.jobs" + metricsSuffix);
                this.jobDurationTimer = this.metricRegistry.timer("commons.scheduler.timer" + metricsSuffix);
                this.overallRunningJobsCounter = metricsSuffix.length() == 0 ? null : this.metricRegistry.counter("commons.scheduler.running.jobs");
            } else {
                this.metricRegistry = null;
                this.runningJobsCounter = null;
                this.jobDurationTimer = null;
                this.overallRunningJobsCounter = null;
            }
        }

        private void measureJobStart() {
            if (this.overallRunningJobsCounter != null) {
                this.overallRunningJobsCounter.inc();
            }
            if (this.runningJobsCounter != null) {
                this.runningJobsCounter.inc();
            }
            this.jobStart = System.currentTimeMillis();
        }

        private void measureJobEnd() {
            if (this.jobStart == -1L) {
                return;
            }
            if (this.overallRunningJobsCounter != null) {
                this.overallRunningJobsCounter.dec();
            }
            if (this.runningJobsCounter != null) {
                this.runningJobsCounter.dec();
            }
            long elapsedMillis = System.currentTimeMillis() - this.jobStart;
            if (this.slowThresholdMillis > 0L && elapsedMillis > this.slowThresholdMillis) {
                if (this.metricRegistry != null) {
                    String slowTimerName = "commons.scheduler.timer.slow." + MetricsHelper.asMetricsSuffix(this.name);
                    this.metricRegistry.timer(slowTimerName).update(elapsedMillis, TimeUnit.MILLISECONDS);
                }
            } else if (this.jobDurationTimer != null) {
                this.jobDurationTimer.update(elapsedMillis, TimeUnit.MILLISECONDS);
            }
        }

        public boolean isKnownJob() {
            return this.job != null && this.name != null;
        }

        public String getKey() {
            String key;
            String string = key = this.job.getClass().getPackage() != null ? this.job.getClass().getPackage().getName() : this.job.getClass().getName();
            if (this.providedName != null) {
                key = key + "-" + this.providedName;
            }
            return key;
        }

        public String toString() {
            String runOnInfo = this.runOn == null ? null : (this.isRunOnLeader() ? "LEADER" : (this.isRunOnSingle() ? "SINGLE" : Arrays.toString(this.runOn)));
            return "job '" + this.job + "' with name '" + this.name + "'" + (runOnInfo == null ? "" : " and config " + runOnInfo);
        }

        public boolean isRunOnLeader() {
            return this.runOn != null && this.runOn.length == 1 && "LEADER".equals(this.runOn[0]);
        }

        public boolean isRunOnSingle() {
            return this.runOn != null && this.runOn.length == 1 && "SINGLE".equals(this.runOn[0]);
        }

        public String shouldRunAsSingleOn() {
            if (!this.isRunOnSingle()) {
                return null;
            }
            String[] ids = SLING_IDS.get();
            boolean schedule = false;
            if (ids != null) {
                int index = 0;
                try {
                    MessageDigest m = MessageDigest.getInstance("MD5");
                    m.reset();
                    m.update(this.getKey().getBytes("UTF-8"));
                    index = new BigInteger(1, m.digest()).mod(BigInteger.valueOf(ids.length)).intValue();
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    LoggerFactory.getLogger((String)this.getClass().getName()).error("Unable to distribute scheduled " + this, (Throwable)ex);
                    return "";
                }
                String myId = SLING_ID;
                schedule = myId != null && myId.equals(ids[index]);
                return schedule ? null : ids[index];
            }
            return "";
        }
    }
}

