/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.text.CharacterIterator;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.apache.sling.engine.impl.log.RequestLoggerRequest;
import org.apache.sling.engine.impl.log.RequestLoggerResponse;

class CustomLogFormat {
    Parameter[] logParameters;

    CustomLogFormat(String pattern) {
        this.logParameters = this.parse(pattern);
        if (this.logParameters.length == 0) {
            this.logParameters = null;
        }
    }

    String format(RequestLoggerRequest request, RequestLoggerResponse response) {
        if (this.logParameters != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.logParameters.length; ++i) {
                this.logParameters[i].print(buf, request, response);
            }
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; this.logParameters != null && i < this.logParameters.length; ++i) {
            buf.append(this.logParameters[i]);
        }
        return buf.toString();
    }

    private Parameter[] parse(String pattern) {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        StringBuilder buf = new StringBuilder();
        StringCharacterIterator sr = new StringCharacterIterator(pattern);
        char c = sr.first();
        while (c != '\uffff') {
            char c1;
            if (c == '%' && (c1 = sr.next()) != '%') {
                Parameter param;
                if (buf.length() > 0) {
                    PlainTextParameter text = new PlainTextParameter(buf.toString());
                    parameterList.add(text);
                    buf.setLength(0);
                }
                if ((param = this.parseFormatString(sr, c1)) != null) {
                    parameterList.add(param);
                }
            } else {
                buf.append(c);
            }
            c = sr.next();
        }
        if (buf.length() > 0) {
            PlainTextParameter text = new PlainTextParameter(buf.toString());
            parameterList.add(text);
            buf.setLength(0);
        }
        return parameterList.toArray(new Parameter[parameterList.size()]);
    }

    private Parameter parseFormatString(CharacterIterator sr, int c) {
        BaseParameter param;
        String name;
        boolean required = true;
        int[] statCodes = null;
        while (c != 65535) {
            if (c == 33) {
                required = false;
            } else if (c >= 48 && c <= 57) {
                statCodes = this.parseStatusCodes(sr, c);
            } else if (c != 62 && c != 60) break;
            c = sr.next();
        }
        if (c == 123) {
            StringBuilder nameBuf = new StringBuilder();
            c = sr.next();
            while (c != 65535 && c != 125) {
                nameBuf.append((char)c);
                c = sr.next();
            }
            name = nameBuf.length() > 0 ? nameBuf.toString() : null;
            c = sr.next();
        } else {
            name = null;
        }
        switch (c) {
            case 97: {
                param = new RemoteIPParameter();
                break;
            }
            case 65: {
                param = new LocalIPParameter();
                break;
            }
            case 66: 
            case 98: {
                param = new ByteCountParameter();
                break;
            }
            case 67: {
                param = name == null ? null : new CookieParameter(name, true);
                break;
            }
            case 68: {
                param = new DurationParameter(false);
                break;
            }
            case 102: {
                param = new ContentPathParameter();
                break;
            }
            case 104: {
                param = new RemoteHostParameter();
                break;
            }
            case 72: {
                param = new ProtocolParameter();
                break;
            }
            case 105: {
                param = name == null ? null : new HeaderParameter(name, true);
                break;
            }
            case 109: {
                param = new MethodParameter();
                break;
            }
            case 77: {
                param = new ParamParameter(name);
                break;
            }
            case 111: {
                param = name == null ? null : new HeaderParameter(name, false);
                break;
            }
            case 112: {
                param = new LocalPortParameter();
                break;
            }
            case 80: {
                param = new ThreadParameter(name);
                break;
            }
            case 113: {
                param = new QueryParameter();
                break;
            }
            case 114: {
                param = new FirstRequestLineParameter();
                break;
            }
            case 82: {
                param = new IdParameter();
                break;
            }
            case 115: {
                param = new StatusParameter();
                break;
            }
            case 116: {
                param = new TimeParameter(name);
                break;
            }
            case 84: {
                param = new DurationParameter(true);
                break;
            }
            case 117: {
                param = new UserParameter();
                break;
            }
            case 85: {
                param = new RequestParameter();
                break;
            }
            case 86: 
            case 118: {
                param = new ServerNameParameter();
                break;
            }
            case 121: {
                param = new AuthTypeParameter();
                break;
            }
            default: {
                param = new NonImplementedParameter(name);
            }
        }
        if (param instanceof BaseParameter) {
            BaseParameter baseParam = param;
            baseParam.setParName((char)c);
            baseParam.setRequired(required);
            baseParam.setStatusLimits(statCodes);
        }
        return param;
    }

    private int[] parseStatusCodes(CharacterIterator sr, int c) {
        int num;
        StringBuilder buf = new StringBuilder();
        buf.append((char)c);
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        c = sr.next();
        while (c != 65535) {
            if (c == 44) {
                num = 0;
                try {
                    num = Integer.parseInt(buf.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (num >= 100 && num <= 999) {
                    numbers.add(num);
                }
                buf.setLength(0);
            } else {
                if (c < 48 || c > 57) break;
                buf.append((char)c);
            }
            c = sr.next();
        }
        sr.previous();
        num = 0;
        try {
            num = Integer.parseInt(buf.toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (num >= 100 && num <= 999) {
            numbers.add(num);
        }
        if (numbers.isEmpty()) {
            return null;
        }
        int[] statusCodes = new int[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            statusCodes[i] = (Integer)numbers.get(i);
        }
        return statusCodes;
    }

    static interface Parameter {
        public void print(StringBuilder var1, RequestLoggerRequest var2, RequestLoggerResponse var3);
    }

    static class PlainTextParameter
    implements Parameter {
        private String value;

        PlainTextParameter(String value) {
            this.value = value;
        }

        @Override
        public void print(StringBuilder dest, RequestLoggerRequest request, RequestLoggerResponse response) {
            dest.append(this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    static class RemoteIPParameter
    extends BaseParameter {
        public RemoteIPParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getRemoteAddr();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class LocalIPParameter
    extends BaseParameter {
        public LocalIPParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getLocalAddr();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class ByteCountParameter
    extends BaseParameter {
        public ByteCountParameter() {
            super(null, false);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            int count = response.getCount();
            if (count == 0) {
                return this.getParName() == 'b' ? "-" : "0";
            }
            return String.valueOf(count);
        }
    }

    static class CookieParameter
    extends BaseParameter {
        private String cookieName;

        CookieParameter(String cookieName, boolean isRequest) {
            super(cookieName, isRequest);
            this.cookieName = cookieName;
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return this.getValue(request.getCookie(this.cookieName));
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return this.getValue(response.getCookie(this.cookieName));
        }

        private String getValue(Cookie cookie) {
            return cookie == null ? null : CookieParameter.escape(cookie.getValue());
        }
    }

    static class DurationParameter
    extends BaseParameter {
        private final boolean seconds;

        public DurationParameter(boolean seconds) {
            super(null, false);
            this.seconds = seconds;
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            long time = response.getRequestDuration();
            if (this.seconds) {
                time /= 1000L;
            }
            return String.valueOf(time);
        }
    }

    static class ContentPathParameter
    extends BaseParameter {
        public ContentPathParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            Object resourcePath = request.getAttribute("$$sling.request.resource$$");
            if (resourcePath instanceof String) {
                return (String)resourcePath;
            }
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class RemoteHostParameter
    extends BaseParameter {
        public RemoteHostParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getRemoteHost();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class ProtocolParameter
    extends BaseParameter {
        public ProtocolParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getProtocol();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class HeaderParameter
    extends BaseParameter {
        private String headerName;

        HeaderParameter(String headerName, boolean isRequest) {
            super(headerName, isRequest);
            this.headerName = headerName;
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            Enumeration values = request.getHeaders(this.headerName);
            if (values == null || !values.hasMoreElements()) {
                return null;
            }
            String value = (String)values.nextElement();
            while (values.hasMoreElements()) {
                value = value + "," + values.nextElement();
            }
            return HeaderParameter.escape(value);
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return HeaderParameter.escape(response.getHeadersString(this.headerName));
        }
    }

    static class MethodParameter
    extends BaseParameter {
        public MethodParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getMethod();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class ParamParameter
    extends BaseParameter {
        public ParamParameter(String parParam) {
            super(parParam, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getParameter(this.getParParam());
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class LocalPortParameter
    extends BaseParameter {
        public LocalPortParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return String.valueOf(request.getServerPort());
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class ThreadParameter
    extends BaseParameter {
        public ThreadParameter(String parParam) {
            super(parParam, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return Thread.currentThread().getName();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class QueryParameter
    extends BaseParameter {
        public QueryParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            String query = request.getQueryString();
            return query == null || query.length() == 0 ? "" : "?" + query;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class FirstRequestLineParameter
    extends BaseParameter {
        public FirstRequestLineParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            String query = request.getQueryString();
            query = query == null || query.length() == 0 ? "" : "?" + query;
            return request.getMethod() + " " + request.getRequestURI() + query + " " + request.getProtocol();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class IdParameter
    extends BaseParameter {
        public IdParameter() {
            super(null, false);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return String.valueOf(response.getRequestId());
        }
    }

    static class StatusParameter
    extends BaseParameter {
        public StatusParameter() {
            super(null, false);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return String.valueOf(response.getStatus());
        }
    }

    static class TimeParameter
    extends BaseParameter {
        private static final SimpleDateFormat accessLogFmt = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss ", Locale.US);
        private static final DecimalFormat dfmt = new DecimalFormat("+0000;-0000");
        private static final Calendar calendar = Calendar.getInstance();
        private static String lastZoneOffset = "";
        private static long lastZoneOffsetHour = -1L;
        private static String lastTimeFormatted = "";
        private static long lastTimeFormattedSeconds = -1L;
        private final boolean requestStart;

        public TimeParameter(String parParam) {
            super(parParam, false);
            this.requestStart = parParam == null || !parParam.equals("end");
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            long time = this.requestStart ? response.getRequestStart() : response.getRequestEnd();
            return TimeParameter.timeFormatted(time);
        }

        static String timeFormatted(long time) {
            if (time / 1000L != lastTimeFormattedSeconds) {
                lastTimeFormattedSeconds = time / 1000L;
                Date date = new Date(time);
                StringBuilder buf = new StringBuilder(accessLogFmt.format(date));
                if (time / 3600000L != lastZoneOffsetHour) {
                    lastZoneOffsetHour = time / 3600000L;
                    calendar.setTime(date);
                    int tzOffset = calendar.get(15) + calendar.get(16);
                    tzOffset /= 60000;
                    tzOffset = tzOffset / 60 * 100 + tzOffset % 60;
                    lastZoneOffset = dfmt.format(tzOffset);
                }
                buf.append(lastZoneOffset);
                lastTimeFormatted = buf.toString();
            }
            return lastTimeFormatted;
        }
    }

    static class UserParameter
    extends BaseParameter {
        public UserParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            String user = request.getRemoteUser();
            return user == null ? null : UserParameter.escape(user);
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class RequestParameter
    extends BaseParameter {
        public RequestParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getRequestURI();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class ServerNameParameter
    extends BaseParameter {
        public ServerNameParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return request.getServerName();
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class AuthTypeParameter
    extends BaseParameter {
        public AuthTypeParameter() {
            super(null, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            String authType = request.getAuthType();
            return authType == null ? null : AuthTypeParameter.escape(authType);
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static class NonImplementedParameter
    extends BaseParameter {
        NonImplementedParameter(String parParam) {
            super(parParam, true);
        }

        @Override
        protected String getValue(RequestLoggerRequest request) {
            return null;
        }

        @Override
        protected String getValue(RequestLoggerResponse response) {
            return null;
        }
    }

    static abstract class BaseParameter
    implements Parameter {
        private int[] statusLimits;
        private boolean required;
        private char parName;
        private final String parParam;
        private final boolean isRequest;

        protected BaseParameter(String parParam, boolean isRequest) {
            this.parParam = parParam;
            this.isRequest = isRequest;
        }

        public void setParName(char parName) {
            this.parName = parName;
        }

        public void setStatusLimits(int[] statusLimits) {
            this.statusLimits = statusLimits;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        protected abstract String getValue(RequestLoggerRequest var1);

        protected abstract String getValue(RequestLoggerResponse var1);

        @Override
        public final void print(StringBuilder dest, RequestLoggerRequest request, RequestLoggerResponse response) {
            if (this.printOk(response.getStatus())) {
                String value = this.isRequest ? this.getValue(request) : this.getValue(response);
                dest.append(value == null ? "-" : value);
            }
        }

        protected boolean printOk(int status) {
            if (this.statusLimits == null) {
                return true;
            }
            for (int i = 0; i < this.statusLimits.length; ++i) {
                if (status != this.statusLimits[i]) continue;
                return this.required;
            }
            return !this.required;
        }

        protected char getParName() {
            return this.parName;
        }

        protected String getParParam() {
            return this.parParam;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("%");
            if (this.statusLimits != null) {
                if (!this.required) {
                    result.append('!');
                }
                for (int i = 0; i < this.statusLimits.length; ++i) {
                    if (i > 0) {
                        result.append(',');
                    }
                    result.append(this.statusLimits[i]);
                }
            }
            if (this.parParam != null) {
                result.append('{').append(this.parParam).append('}');
            }
            result.append(this.parName);
            return result.toString();
        }

        private static boolean isPrint(char c) {
            return c >= ' ' && c < '\u007f' && c != '\\' && c != '\"';
        }

        static String escape(String value) {
            int i;
            if (value == null || value.length() == 0) {
                return value;
            }
            for (i = 0; i < value.length() && BaseParameter.isPrint(value.charAt(i)); ++i) {
            }
            if (i >= value.length()) {
                return value;
            }
            StringBuilder buf = new StringBuilder(value.substring(0, i));
            while (i < value.length()) {
                char c = value.charAt(i);
                if (BaseParameter.isPrint(c)) {
                    buf.append(c);
                } else if (c == '\n') {
                    buf.append("\\n");
                } else if (c == '\r') {
                    buf.append("\\r");
                } else if (c == '\t') {
                    buf.append("\\t");
                } else if (c == '\f') {
                    buf.append("\\f");
                } else if (c == '\b') {
                    buf.append("\\b");
                } else if (c == '\"') {
                    buf.append("\\\"");
                } else if (c == '\\') {
                    buf.append("\\\\");
                } else {
                    buf.append("\\u");
                    if (c < '\u0010') {
                        buf.append('0');
                    }
                    if (c < '\u0100') {
                        buf.append('0');
                    }
                    if (c < '\u1000') {
                        buf.append('0');
                    }
                    buf.append(Integer.toHexString(c));
                }
                ++i;
            }
            return buf.toString();
        }
    }
}

