/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.event.impl.jobs.InternalJobState;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.stats.GaugeSupport;
import org.apache.sling.event.impl.jobs.stats.StatisticsImpl;
import org.apache.sling.event.impl.jobs.stats.TopicStatisticsImpl;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={StatisticsManager.class}, property={"service.vendor=The Apache Software Foundation"})
public class StatisticsManager {
    @Reference
    private JobManagerConfiguration configuration;
    @Reference(target="(name=sling)", cardinality=ReferenceCardinality.OPTIONAL)
    private MetricRegistry metricRegistry;
    private final StatisticsImpl globalStatistics = new StatisticsImpl(){

        @Override
        public synchronized void reset() {
            super.reset();
            StatisticsManager.this.topicStatistics.clear();
            for (Statistics s : StatisticsManager.this.queueStatistics.values()) {
                s.reset();
            }
        }
    };
    private GaugeSupport globalGauges;
    private final ConcurrentMap<String, TopicStatistics> topicStatistics = new ConcurrentHashMap<String, TopicStatistics>();
    private final ConcurrentMap<String, GaugeSupport> queueGauges = new ConcurrentHashMap<String, GaugeSupport>();
    private final ConcurrentMap<String, Statistics> queueStatistics = new ConcurrentHashMap<String, Statistics>();

    public Statistics getGlobalStatistics() {
        return this.globalStatistics;
    }

    public Map<String, TopicStatistics> getTopicStatistics() {
        return this.topicStatistics;
    }

    public Statistics getQueueStatistics(String queueName) {
        Statistics queueStats = (Statistics)this.queueStatistics.get(queueName);
        if (queueStats == null) {
            queueStats = new StatisticsImpl();
        }
        return queueStats;
    }

    private StatisticsImpl getStatisticsForQueue(String queueName) {
        if (queueName == null) {
            return null;
        }
        StatisticsImpl queueStats = (StatisticsImpl)this.queueStatistics.get(queueName);
        if (queueStats == null) {
            GaugeSupport gaugeSupport;
            this.queueStatistics.putIfAbsent(queueName, new StatisticsImpl());
            queueStats = (StatisticsImpl)this.queueStatistics.get(queueName);
            if (this.metricRegistry != null && this.queueGauges.putIfAbsent(queueName, gaugeSupport = new GaugeSupport(queueName, queueStats, this.metricRegistry)) == null) {
                gaugeSupport.initialize();
            }
        }
        return queueStats;
    }

    public void jobEnded(String queueName, String topic, InternalJobState state, long processingTime) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        if (ts == null) {
            this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
            ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        }
        if (state == InternalJobState.CANCELLED) {
            ts.cancelledJob();
            this.globalStatistics.cancelledJob();
            if (queueStats != null) {
                queueStats.cancelledJob();
            }
        } else if (state == InternalJobState.FAILED) {
            ts.failedJob();
            this.globalStatistics.failedJob();
            if (queueStats != null) {
                queueStats.failedJob();
            }
        } else if (state == InternalJobState.SUCCEEDED) {
            ts.finishedJob(processingTime);
            this.globalStatistics.finishedJob(processingTime);
            if (queueStats != null) {
                queueStats.finishedJob(processingTime);
            }
        }
    }

    public void jobStarted(String queueName, String topic, long queueTime) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        if (ts == null) {
            this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
            ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
        }
        ts.addActive(queueTime);
        this.globalStatistics.addActive(queueTime);
        if (queueStats != null) {
            queueStats.addActive(queueTime);
        }
    }

    public void jobQueued(String queueName, String topic) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        this.globalStatistics.incQueued();
        if (queueStats != null) {
            queueStats.incQueued();
        }
    }

    public void jobDequeued(String queueName, String topic) {
        StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
        this.globalStatistics.decQueued();
        if (queueStats != null) {
            queueStats.decQueued();
        }
    }

    @Activate
    protected void activate() {
        if (this.metricRegistry != null) {
            this.globalGauges = new GaugeSupport(this.globalStatistics, this.metricRegistry);
            this.globalGauges.initialize();
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.globalGauges != null) {
            this.globalGauges.shutdown();
        }
        for (GaugeSupport gaugeSupport : this.queueGauges.values()) {
            gaugeSupport.shutdown();
        }
    }
}

