/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.batch_norm1d.Backward_output;
import org.apache.sysml.scripts.nn.layers.batch_norm1d.Forward_output;
import org.apache.sysml.scripts.nn.layers.batch_norm1d.Init_output;

public class Batch_norm1d
extends Script {
    public Batch_norm1d() {
        String string = "scripts/nn/layers/batch_norm1d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object) {
        String string = "source('scripts/nn/layers/batch_norm1d.dml') as mlcontextns;[gamma, beta, ema_mean, ema_var] = mlcontextns::init(D);";
        Script script = new Script(string);
        script.in("D", object).out("gamma").out("beta").out("ema_mean").out("ema_var");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("gamma");
        Matrix matrix2 = mLResults.getMatrix("beta");
        Matrix matrix3 = mLResults.getMatrix("ema_mean");
        Matrix matrix4 = mLResults.getMatrix("ema_var");
        Init_output init_output = new Init_output(matrix, matrix2, matrix3, matrix4);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int D)\n    return (matrix[double] gamma, matrix[double] beta,\n            matrix[double] ema_mean, matrix[double] ema_var) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - D: Dimensionality of the input features (number of features).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (1, D).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (1, D).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int D)\n    return (matrix[double] gamma, matrix[double] beta,\n            matrix[double] ema_mean, matrix[double] ema_var) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - D: Dimensionality of the input features (number of features).\n   *\n   * Outputs:\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (1, D).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (1, D).\n   */\n   gamma = matrix(1, rows=1, cols=D)\n   beta = matrix(0, rows=1, cols=D)\n   ema_mean = matrix(0, rows=1, cols=D)\n   ema_var = matrix(1, rows=1, cols=D)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        String string = "source('scripts/nn/layers/batch_norm1d.dml') as mlcontextns;[out, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] = mlcontextns::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, epsilon);";
        Script script = new Script(string);
        script.in("X", object).in("gamma", object2).in("beta", object3).in("mode", object4).in("ema_mean", object5).in("ema_var", object6).in("mu", object7).in("epsilon", object8).out("out").out("ema_mean_upd").out("ema_var_upd").out("cache_mean").out("cache_var").out("cache_norm");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        Matrix matrix2 = mLResults.getMatrix("ema_mean_upd");
        Matrix matrix3 = mLResults.getMatrix("ema_var_upd");
        Matrix matrix4 = mLResults.getMatrix("cache_mean");
        Matrix matrix5 = mLResults.getMatrix("cache_var");
        Matrix matrix6 = mLResults.getMatrix("cache_norm");
        Forward_output forward_output = new Forward_output(matrix, matrix2, matrix3, matrix4, matrix5, matrix6);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                   string mode, matrix[double] ema_mean, matrix[double] ema_var,\n                   double mu, double epsilon)\n    return (matrix[double] out, matrix[double] ema_mean_upd, matrix[double] ema_var_upd,\n            matrix[double] cache_mean, matrix[double] cache_var, matrix[double] cache_norm) {\n  /*\n   * Computes the forward pass for a 1D batch normalization layer.\n   * The input data has N examples, each with D features.\n   *\n   * A batch normalization layer uses the per-feature sample mean and\n   * per-feature uncorrected sample variance during training to\n   * normalize each feature of the input data.  Additionally, it\n   * introduces learnable parameters (gamma, beta) to control the\n   * amount of normalization.\n   *\n   *   `y = ((x-mean) / sqrt(var+eps)) * gamma + beta`\n   *\n   * This implementation maintains exponential moving averages of the\n   * mean and variance during training for use during testing.\n   *\n   * Reference:\n   *  - Batch Normalization: Accelerating Deep Network Training by\n   *    Reducing Internal Covariate Shift, S. Ioffe & C. Szegedy, 2015\n   *    - https://arxiv.org/abs/1502.03167\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *  - mode: 'train' or 'test' to indicate if the model is currently\n   *      being trained or tested.  During training, the current batch\n   *      mean and variance will be used to normalize the inputs, while\n   *      during testing, the exponential average of the mean and\n   *      variance over all previous batches will be used.\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (1, D).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (1, D).\n   *  - mu: Momentum value for moving averages.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, D).\n   *  - ema_mean_upd: Updated exponential moving average of the mean,\n   *      of shape (1, D).\n   *  - ema_var_upd: Updated exponential moving average of the variance,\n   *      of shape (1, D).\n   *  - cache_mean: Cache of the batch mean, of shape (1, D).\n   *      Note: This is used for performance during training.\n   *  - cache_var: Cache of the batch variance, of shape (1, D).\n   *      Note: This is used for performance during training.\n   *  - cache_norm: Cache of the normalized inputs, of shape (N, D).\n   *      Note: This is used for performance during training.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                   string mode, matrix[double] ema_mean, matrix[double] ema_var,\n                   double mu, double epsilon)\n    return (matrix[double] out, matrix[double] ema_mean_upd, matrix[double] ema_var_upd,\n            matrix[double] cache_mean, matrix[double] cache_var, matrix[double] cache_norm) {\n  /*\n   * Computes the forward pass for a 1D batch normalization layer.\n   * The input data has N examples, each with D features.\n   *\n   * A batch normalization layer uses the per-feature sample mean and\n   * per-feature uncorrected sample variance during training to\n   * normalize each feature of the input data.  Additionally, it\n   * introduces learnable parameters (gamma, beta) to control the\n   * amount of normalization.\n   *\n   *   `y = ((x-mean) / sqrt(var+eps)) * gamma + beta`\n   *\n   * This implementation maintains exponential moving averages of the\n   * mean and variance during training for use during testing.\n   *\n   * Reference:\n   *  - Batch Normalization: Accelerating Deep Network Training by\n   *    Reducing Internal Covariate Shift, S. Ioffe & C. Szegedy, 2015\n   *    - https://arxiv.org/abs/1502.03167\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *  - mode: 'train' or 'test' to indicate if the model is currently\n   *      being trained or tested.  During training, the current batch\n   *      mean and variance will be used to normalize the inputs, while\n   *      during testing, the exponential average of the mean and\n   *      variance over all previous batches will be used.\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (1, D).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (1, D).\n   *  - mu: Momentum value for moving averages.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (N, D).\n   *  - ema_mean_upd: Updated exponential moving average of the mean,\n   *      of shape (1, D).\n   *  - ema_var_upd: Updated exponential moving average of the variance,\n   *      of shape (1, D).\n   *  - cache_mean: Cache of the batch mean, of shape (1, D).\n   *      Note: This is used for performance during training.\n   *  - cache_var: Cache of the batch variance, of shape (1, D).\n   *      Note: This is used for performance during training.\n   *  - cache_norm: Cache of the normalized inputs, of shape (N, D).\n   *      Note: This is used for performance during training.\n   */\n  N = nrow(X)\n\n  if (mode == 'train') {\n    # Compute feature-wise mean and variance\n    mean = colMeans(X)  # shape (1, D)\n    # var = (1/N) * colSums((X-mean)^2)\n    var = colVars(X) * ((N-1)/N)  # compute uncorrected variance, of shape (1, D)\n    # Update moving averages\n    ema_mean_upd = mu*ema_mean + (1-mu)*mean\n    ema_var_upd = mu*ema_var + (1-mu)*var\n  }\n  else {\n    # Use moving averages of mean and variance during testing\n    mean = ema_mean\n    var = ema_var\n    ema_mean_upd = ema_mean\n    ema_var_upd = ema_var\n  }\n\n  # Normalize, shift, and scale\n  # norm = (X-mean)*(var+epsilon)^(-1/2)\n  norm = (X-mean) / sqrt(var+epsilon)  # shape (N, D)\n  out = norm*gamma + beta  # shape (N, D)\n\n  # Save variable for backward pass\n  cache_mean = mean\n  cache_var = var\n  cache_norm = norm\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) {
        String string = "source('scripts/nn/layers/batch_norm1d.dml') as mlcontextns;[dX, dgamma, dbeta] = mlcontextns::backward(dout, out, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm, X, gamma, beta, mode, ema_mean, ema_var, mu, epsilon);";
        Script script = new Script(string);
        script.in("dout", object).in("out", object2).in("ema_mean_upd", object3).in("ema_var_upd", object4).in("cache_mean", object5).in("cache_var", object6).in("cache_norm", object7).in("X", object8).in("gamma", object9).in("beta", object10).in("mode", object11).in("ema_mean", object12).in("ema_var", object13).in("mu", object14).in("epsilon", object15).out("dX").out("dgamma").out("dbeta");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dgamma");
        Matrix matrix3 = mLResults.getMatrix("dbeta");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] out,\n                    matrix[double] ema_mean_upd, matrix[double] ema_var_upd,\n                    matrix[double] cache_mean, matrix[double] cache_var, matrix[double] cache_norm,\n                    matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                    string mode, matrix[double] ema_mean, matrix[double] ema_var,\n                    double mu, double epsilon)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 1D batch normalization layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, D).\n   *  - out: Outputs from the forward pass, of shape (N, D).\n   *  - ema_mean_upd: Updated exponential moving average of the mean\n   *      from the forward pass, of shape (1, D).\n   *  - ema_var_upd: Updated exponential moving average of the variance\n   *      from the forward pass, of shape (1, D).\n   *  - cache_mean: Cache of the batch mean from the forward pass, of\n   *      shape (1, D).  Note: This is used for performance during\n   *      training.\n   *  - cache_var: Cache of the batch variance from the forward pass,\n   *      of shape (1, D).  Note: This is used for performance during\n   *      training.\n   *  - cache_norm: Cache of the normalized inputs from the forward\n   *      pass, of shape (N, D).  Note: This is used for performance\n   *      during training.\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *  - mode: 'train' or 'test' to indicate if the model is currently\n   *      being trained or tested.  During training, the current batch\n   *      mean and variance will be used to normalize the inputs, while\n   *      during testing, the exponential average of the mean and\n   *      variance over all previous batches will be used.\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (1, D).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (1, D).\n   *  - mu: Momentum value for moving averages.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, D).\n   *  - dgamma: Gradient wrt `W`, of shape (1, D).\n   *  - dbeta: Gradient wrt `b`, of shape (1, D).\n   *\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] out,\n                    matrix[double] ema_mean_upd, matrix[double] ema_var_upd,\n                    matrix[double] cache_mean, matrix[double] cache_var, matrix[double] cache_norm,\n                    matrix[double] X, matrix[double] gamma, matrix[double] beta,\n                    string mode, matrix[double] ema_mean, matrix[double] ema_var,\n                    double mu, double epsilon)\n      return (matrix[double] dX, matrix[double] dgamma, matrix[double] dbeta) {\n  /*\n   * Computes the backward pass for a 1D batch normalization layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of shape (N, D).\n   *  - out: Outputs from the forward pass, of shape (N, D).\n   *  - ema_mean_upd: Updated exponential moving average of the mean\n   *      from the forward pass, of shape (1, D).\n   *  - ema_var_upd: Updated exponential moving average of the variance\n   *      from the forward pass, of shape (1, D).\n   *  - cache_mean: Cache of the batch mean from the forward pass, of\n   *      shape (1, D).  Note: This is used for performance during\n   *      training.\n   *  - cache_var: Cache of the batch variance from the forward pass,\n   *      of shape (1, D).  Note: This is used for performance during\n   *      training.\n   *  - cache_norm: Cache of the normalized inputs from the forward\n   *      pass, of shape (N, D).  Note: This is used for performance\n   *      during training.\n   *  - X: Inputs, of shape (N, D).\n   *  - gamma: Scale parameters, of shape (1, D).\n   *  - beta: Shift parameters, of shape (1, D).\n   *  - mode: 'train' or 'test' to indicate if the model is currently\n   *      being trained or tested.  During training, the current batch\n   *      mean and variance will be used to normalize the inputs, while\n   *      during testing, the exponential average of the mean and\n   *      variance over all previous batches will be used.\n   *  - ema_mean: Exponential moving average of the mean, of\n   *      shape (1, D).\n   *  - ema_var: Exponential moving average of the variance, of\n   *      shape (1, D).\n   *  - mu: Momentum value for moving averages.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-5, 1e-3].\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, D).\n   *  - dgamma: Gradient wrt `W`, of shape (1, D).\n   *  - dbeta: Gradient wrt `b`, of shape (1, D).\n   *\n   */\n  N = nrow(X)\n  mean = cache_mean\n  var = cache_var\n  norm = cache_norm\n  centered = X-mean\n\n  if (mode == 'train') {\n    # Compute gradients during training\n    dgamma = colSums(dout*norm)  # shape (1, D)\n    dbeta = colSums(dout)  # shape (1, D)\n    dnorm = dout * gamma  # shape (N, D)\n    dvar = (-1/2) * colSums(centered * (var+epsilon)^(-3/2) * dnorm)  # shape (1, D)\n    dmean = colSums((-dnorm/sqrt(var+epsilon)) + ((-2/N)*centered*dvar))  # shape (1, D)\n    dX = (dnorm/sqrt(var+epsilon)) + ((2/N)*centered*dvar) + ((1/N)*dmean)  # shape (N, D)\n  }\n  else {\n    # Compute gradients during testing\n    dgamma = colSums(dout*norm)  # shape (1, D)\n    dbeta = colSums(dout)  # shape (1, D)\n    dnorm = dout * gamma  # shape (N, D)\n    dX = dnorm / sqrt(var+epsilon)  # shape (N, D)\n  }\n}\n";
        return string;
    }
}

