/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.optim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.optim.sgd_momentum.Update_output;

public class Sgd_momentum
extends Script {
    public Sgd_momentum() {
        String string = "scripts/nn/optim/sgd_momentum.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix init(Object object) {
        String string = "source('scripts/nn/optim/sgd_momentum.dml') as mlcontextns;v = mlcontextns::init(X);";
        Script script = new Script(string);
        script.in("X", object).out("v");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("v");
        return matrix;
    }

    public String init__docs() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] v) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - v: Initial velocity of the parameters `X`.\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] v) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - v: Initial velocity of the parameters `X`.\n   */\n  v = matrix(0, rows=nrow(X), cols=ncol(X))\n}\n";
        return string;
    }

    public Update_output update(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/nn/optim/sgd_momentum.dml') as mlcontextns;[X, v] = mlcontextns::update(X, dX, lr, mu, v);";
        Script script = new Script(string);
        script.in("X", object).in("dX", object2).in("lr", object3).in("mu", object4).in("v", object5).out("X").out("v");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        Matrix matrix2 = mLResults.getMatrix("v");
        Update_output update_output = new Update_output(matrix, matrix2);
        return update_output;
    }

    public String update__docs() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double mu, matrix[double] v)\n    return (matrix[double] X, matrix[double] v) {\n  /*\n   * Performs an SGD update with momentum.\n   *\n   * In SGD with momentum, we assume that the parameters have a velocity\n   * that continues with some momentum, and that is influenced by the\n   * gradient.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - mu: Momentum value.\n   *      Typical values are in the range of [0.5, 0.99], usually\n   *      started at the lower end and annealed towards the higher end.\n   *  - v: State maintaining the velocity of the parameters `X`, of same\n   *      shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - v: Updated velocity of the parameters `X`, of same shape as\n   *      input `X`.\n   */\n";
        return string;
    }

    public String update__source() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double mu, matrix[double] v)\n    return (matrix[double] X, matrix[double] v) {\n  /*\n   * Performs an SGD update with momentum.\n   *\n   * In SGD with momentum, we assume that the parameters have a velocity\n   * that continues with some momentum, and that is influenced by the\n   * gradient.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - mu: Momentum value.\n   *      Typical values are in the range of [0.5, 0.99], usually\n   *      started at the lower end and annealed towards the higher end.\n   *  - v: State maintaining the velocity of the parameters `X`, of same\n   *      shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - v: Updated velocity of the parameters `X`, of same shape as\n   *      input `X`.\n   */\n  v = mu*v - lr*dX  # update velocity\n  X = X + v  # update position\n}\n";
        return string;
    }
}

