/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JCompType;
import org.apache.hadoop.record.compiler.JType;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class JMap
extends JCompType {
    private static int level = 0;
    private JType keyType;
    private JType valueType;

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    private static String getId(String id) {
        return id + JMap.getLevel();
    }

    public JMap(JType t1, JType t2) {
        this.setJavaType(new JavaMap(t1.getJavaType(), t2.getJavaType()));
        this.setCppType(new CppMap(t1.getCppType(), t2.getCppType()));
        this.setCType(new JType.CType(this));
        this.keyType = t1;
        this.valueType = t2;
    }

    @Override
    String getSignature() {
        return "{" + this.keyType.getSignature() + this.valueType.getSignature() + "}";
    }

    class CppMap
    extends JCompType.CppCompType {
        JType.CppType key;
        JType.CppType value;

        CppMap(JType.CppType key, JType.CppType value) {
            super("::std::map< " + key.getType() + ", " + value.getType() + " >");
            this.key = key;
            this.value = value;
        }

        @Override
        String getTypeIDObjectString() {
            return "new ::hadoop::MapTypeID(" + this.key.getTypeIDObjectString() + ", " + this.value.getTypeIDObjectString() + ")";
        }

        @Override
        void genSetRTIFilter(CodeBuffer cb) {
            this.key.genSetRTIFilter(cb);
            this.value.genSetRTIFilter(cb);
        }
    }

    class JavaMap
    extends JCompType.JavaCompType {
        JType.JavaType key;
        JType.JavaType value;

        JavaMap(JType.JavaType key, JType.JavaType value) {
            super("java.util.TreeMap<" + key.getWrapperType() + "," + value.getWrapperType() + ">", "Map", "java.util.TreeMap<" + key.getWrapperType() + "," + value.getWrapperType() + ">", "TypeID.RIOType.MAP");
            this.key = key;
            this.value = value;
        }

        @Override
        String getTypeIDObjectString() {
            return "new org.apache.hadoop.record.meta.MapTypeID(" + this.key.getTypeIDObjectString() + ", " + this.value.getTypeIDObjectString() + ")";
        }

        @Override
        void genSetRTIFilter(CodeBuffer cb, Map<String, Integer> nestedStructMap) {
            this.key.genSetRTIFilter(cb, nestedStructMap);
            this.value.genSetRTIFilter(cb, nestedStructMap);
        }

        @Override
        void genCompareTo(CodeBuffer cb, String fname, String other) {
            String setType = "java.util.Set<" + this.key.getWrapperType() + "> ";
            String iterType = "java.util.Iterator<" + this.key.getWrapperType() + "> ";
            cb.append("{\n");
            cb.append(setType + JMap.getId("_rio_set1") + " = " + fname + ".keySet();\n");
            cb.append(setType + JMap.getId("_rio_set2") + " = " + other + ".keySet();\n");
            cb.append(iterType + JMap.getId("_rio_miter1") + " = " + JMap.getId("_rio_set1") + ".iterator();\n");
            cb.append(iterType + JMap.getId("_rio_miter2") + " = " + JMap.getId("_rio_set2") + ".iterator();\n");
            cb.append("for(; " + JMap.getId("_rio_miter1") + ".hasNext() && " + JMap.getId("_rio_miter2") + ".hasNext();) {\n");
            cb.append(this.key.getType() + " " + JMap.getId("_rio_k1") + " = " + JMap.getId("_rio_miter1") + ".next();\n");
            cb.append(this.key.getType() + " " + JMap.getId("_rio_k2") + " = " + JMap.getId("_rio_miter2") + ".next();\n");
            this.key.genCompareTo(cb, JMap.getId("_rio_k1"), JMap.getId("_rio_k2"));
            cb.append("if (_rio_ret != 0) { return _rio_ret; }\n");
            cb.append("}\n");
            cb.append("_rio_ret = (" + JMap.getId("_rio_set1") + ".size() - " + JMap.getId("_rio_set2") + ".size());\n");
            cb.append("}\n");
        }

        @Override
        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + ";\n");
            }
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("org.apache.hadoop.record.Index " + JMap.getId("_rio_midx") + " = " + "_rio_a" + ".startMap(\"" + tag + "\");\n");
            cb.append(fname + "=new " + this.getType() + "();\n");
            cb.append("for (; !" + JMap.getId("_rio_midx") + ".done(); " + JMap.getId("_rio_midx") + ".incr()) {\n");
            this.key.genReadMethod(cb, JMap.getId("_rio_k"), JMap.getId("_rio_k"), true);
            this.value.genReadMethod(cb, JMap.getId("_rio_v"), JMap.getId("_rio_v"), true);
            cb.append(fname + ".put(" + JMap.getId("_rio_k") + "," + JMap.getId("_rio_v") + ");\n");
            cb.append("}\n");
            cb.append("_rio_a.endMap(\"" + tag + "\");\n");
            JMap.decrLevel();
            cb.append("}\n");
        }

        @Override
        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            String setType = "java.util.Set<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            String entryType = "java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + "> ";
            String iterType = "java.util.Iterator<java.util.Map.Entry<" + this.key.getWrapperType() + "," + this.value.getWrapperType() + ">> ";
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("_rio_a.startMap(" + fname + ",\"" + tag + "\");\n");
            cb.append(setType + JMap.getId("_rio_es") + " = " + fname + ".entrySet();\n");
            cb.append("for(" + iterType + JMap.getId("_rio_midx") + " = " + JMap.getId("_rio_es") + ".iterator(); " + JMap.getId("_rio_midx") + ".hasNext();) {\n");
            cb.append(entryType + JMap.getId("_rio_me") + " = " + JMap.getId("_rio_midx") + ".next();\n");
            cb.append(this.key.getType() + " " + JMap.getId("_rio_k") + " = " + JMap.getId("_rio_me") + ".getKey();\n");
            cb.append(this.value.getType() + " " + JMap.getId("_rio_v") + " = " + JMap.getId("_rio_me") + ".getValue();\n");
            this.key.genWriteMethod(cb, JMap.getId("_rio_k"), JMap.getId("_rio_k"));
            this.value.genWriteMethod(cb, JMap.getId("_rio_v"), JMap.getId("_rio_v"));
            cb.append("}\n");
            cb.append("_rio_a.endMap(" + fname + ",\"" + tag + "\");\n");
            cb.append("}\n");
            JMap.decrLevel();
        }

        @Override
        void genSlurpBytes(CodeBuffer cb, String b, String s, String l) {
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("int " + JMap.getId("mi") + " = org.apache.hadoop.record.Utils.readVInt(" + b + ", " + s + ");\n");
            cb.append("int " + JMap.getId("mz") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JMap.getId("mi") + ");\n");
            cb.append(s + "+=" + JMap.getId("mz") + "; " + l + "-=" + JMap.getId("mz") + ";\n");
            cb.append("for (int " + JMap.getId("midx") + " = 0; " + JMap.getId("midx") + " < " + JMap.getId("mi") + "; " + JMap.getId("midx") + "++) {");
            this.key.genSlurpBytes(cb, b, s, l);
            this.value.genSlurpBytes(cb, b, s, l);
            cb.append("}\n");
            JMap.decrLevel();
            cb.append("}\n");
        }

        @Override
        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            JMap.incrLevel();
            cb.append("int " + JMap.getId("mi1") + " = org.apache.hadoop.record.Utils.readVInt(b1, s1);\n");
            cb.append("int " + JMap.getId("mi2") + " = org.apache.hadoop.record.Utils.readVInt(b2, s2);\n");
            cb.append("int " + JMap.getId("mz1") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JMap.getId("mi1") + ");\n");
            cb.append("int " + JMap.getId("mz2") + " = org.apache.hadoop.record.Utils.getVIntSize(" + JMap.getId("mi2") + ");\n");
            cb.append("s1+=" + JMap.getId("mz1") + "; s2+=" + JMap.getId("mz2") + "; l1-=" + JMap.getId("mz1") + "; l2-=" + JMap.getId("mz2") + ";\n");
            cb.append("for (int " + JMap.getId("midx") + " = 0; " + JMap.getId("midx") + " < " + JMap.getId("mi1") + " && " + JMap.getId("midx") + " < " + JMap.getId("mi2") + "; " + JMap.getId("midx") + "++) {");
            this.key.genCompareBytes(cb);
            this.value.genSlurpBytes(cb, "b1", "s1", "l1");
            this.value.genSlurpBytes(cb, "b2", "s2", "l2");
            cb.append("}\n");
            cb.append("if (" + JMap.getId("mi1") + " != " + JMap.getId("mi2") + ") { return (" + JMap.getId("mi1") + "<" + JMap.getId("mi2") + ")?-1:0; }\n");
            JMap.decrLevel();
            cb.append("}\n");
        }
    }
}

