/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.functions;

import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import scala.Tuple2;

public class OuterVectorBinaryOpFunction
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = 1730704346934726826L;
    private BinaryOperator _op;
    private PartitionedBroadcast<MatrixBlock> _pmV;

    public OuterVectorBinaryOpFunction(BinaryOperator op, PartitionedBroadcast<MatrixBlock> binput) {
        this._op = op;
        this._pmV = binput;
    }

    public OuterVectorBinaryOpIterator call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        return new OuterVectorBinaryOpIterator(arg0);
    }

    private class OuterVectorBinaryOpIterator
    implements Iterable<Tuple2<MatrixIndexes, MatrixBlock>>,
    Iterator<Tuple2<MatrixIndexes, MatrixBlock>> {
        private Tuple2<MatrixIndexes, MatrixBlock> _currBlk = null;
        private int _currPos = -1;

        public OuterVectorBinaryOpIterator(Tuple2<MatrixIndexes, MatrixBlock> in) {
            this._currBlk = in;
            this._currPos = 1;
        }

        @Override
        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this._currBlk != null && this._currPos <= OuterVectorBinaryOpFunction.this._pmV.getNumColumnBlocks();
        }

        @Override
        public Tuple2<MatrixIndexes, MatrixBlock> next() {
            Tuple2 ret = null;
            try {
                MatrixIndexes ix = (MatrixIndexes)this._currBlk._1();
                MatrixBlock in1 = (MatrixBlock)this._currBlk._2();
                MatrixBlock in2 = (MatrixBlock)OuterVectorBinaryOpFunction.this._pmV.getBlock(1, this._currPos);
                MatrixBlock resultBlk = in1.binaryOperations(OuterVectorBinaryOpFunction.this._op, in2, new MatrixBlock());
                resultBlk.examSparsity();
                ret = new Tuple2((Object)new MatrixIndexes(ix.getRowIndex(), this._currPos), (Object)resultBlk);
                ++this._currPos;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Unsupported remove operation.");
        }
    }
}

