/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.FrameGenerateReader;
import org.apache.sysds.runtime.iogen.MatrixGenerateReader;
import org.apache.sysds.runtime.iogen.ReaderMapping;
import org.apache.sysds.runtime.iogen.SampleProperties;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class GenerateReader {
    protected static final Log LOG = LogFactory.getLog((String)GenerateReader.class.getName());
    protected static ReaderMapping readerMapping;

    public GenerateReader(SampleProperties sampleProperties) throws Exception {
        readerMapping = sampleProperties.getDataType().isMatrix() ? new ReaderMapping.MatrixReaderMapping(sampleProperties.getSampleRaw(), sampleProperties.getSampleMatrix()) : new ReaderMapping.FrameReaderMapping(sampleProperties.getSampleRaw(), sampleProperties.getSampleFrame());
    }

    public static class GenerateReaderFrame
    extends GenerateReader {
        private FrameReader frameReader;

        public GenerateReaderFrame(SampleProperties sampleProperties) throws Exception {
            super(sampleProperties);
        }

        public GenerateReaderFrame(String sampleRaw, FrameBlock sampleFrame) throws Exception {
            super(new SampleProperties(sampleRaw, sampleFrame));
        }

        public FrameReader getReader() throws Exception {
            boolean isMapped;
            boolean bl = isMapped = readerMapping != null && readerMapping.isMapped();
            if (!isMapped) {
                throw new Exception("Sample raw data and sample frame don't match !!");
            }
            CustomProperties ffp = readerMapping.getFormatProperties();
            if (ffp == null) {
                throw new Exception("The file format couldn't recognize!!");
            }
            this.frameReader = ffp.getRowPattern().equals((Object)CustomProperties.GRPattern.Regular) ? (ffp.getColPattern().equals((Object)CustomProperties.GRPattern.Regular) ? new FrameGenerateReader.FrameReaderRowRegularColRegular(ffp) : new FrameGenerateReader.FrameReaderRowRegularColIrregular(ffp)) : new FrameGenerateReader.FrameReaderRowIrregular(ffp);
            return this.frameReader;
        }
    }

    public static class GenerateReaderMatrix
    extends GenerateReader {
        private MatrixReader matrixReader;

        public GenerateReaderMatrix(SampleProperties sampleProperties) throws Exception {
            super(sampleProperties);
        }

        public GenerateReaderMatrix(String sampleRaw, MatrixBlock sampleMatrix) throws Exception {
            super(new SampleProperties(sampleRaw, sampleMatrix));
        }

        public MatrixReader getReader() throws Exception {
            boolean isMapped;
            boolean bl = isMapped = readerMapping != null && readerMapping.isMapped();
            if (!isMapped) {
                throw new Exception("Sample raw data and sample matrix don't match !!");
            }
            CustomProperties ffp = readerMapping.getFormatProperties();
            if (ffp == null) {
                throw new Exception("The file format couldn't recognize!!");
            }
            this.matrixReader = ffp.getRowPattern().equals((Object)CustomProperties.GRPattern.Regular) ? (ffp.getColPattern().equals((Object)CustomProperties.GRPattern.Regular) ? new MatrixGenerateReader.MatrixReaderRowRegularColRegular(ffp) : new MatrixGenerateReader.MatrixReaderRowRegularColIrregular(ffp)) : new MatrixGenerateReader.MatrixReaderRowIrregular(ffp);
            return this.matrixReader;
        }
    }
}

