# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/cvlm.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def cvlm(X: Matrix,
         y: Matrix,
         k: int,
         **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     The cvlm-function is used for cross-validation of the provided data model. This function follows a non-exhaustive cross
     validation method. It uses lm and lmPredict functions to solve the linear regression and to predict the class of a
     feature vector with no intercept, shifting, and rescaling.
    
    
    
    :param X: Recorded Data set into matrix
    :param y: 1-column matrix of response values.
    :param k: Number of subsets needed, It should always be more than 1 and less than nrow(X)
    :param icpt: Intercept presence, shifting and rescaling the columns of X
    :param reg: Regularization constant (lambda) for L2-regularization. set to nonzero for
        highly dependant/sparse/numerous features
    :return: Response values
    :return: Validated data set
    """

    params_dict = {'X': X, 'y': y, 'k': k}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(X.sds_context, '')
    vX_1 = Matrix(X.sds_context, '')
    output_nodes = [vX_0, vX_1, ]

    op = MultiReturn(X.sds_context, 'cvlm', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]

    return op
