# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/randomForest.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def randomForest(X: Matrix,
                 Y: Matrix,
                 R: Matrix,
                 **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This script implement classification random forest with both scale and categorical features.
    
    
    
    :param X: Feature matrix X; note that X needs to be both recoded and dummy coded
    :param Y: Label matrix Y; note that Y needs to be both recoded and dummy coded
    :param R: Matrix which for each feature in X contains the following information
        - R[,1]: column ids       TODO pass recorded and binned
        - R[,2]: start indices
        - R[,3]: end indices
        If R is not provided by default all variables are assumed to be scale
    :param bins: Number of equiheight bins per scale feature to choose thresholds
    :param depth: Maximum depth of the learned tree
    :param num_leaf: Number of samples when splitting stops and a leaf node is added
    :param num_samples: Number of samples at which point we switch to in-memory subtree building
    :param num_trees: Number of trees to be learned in the random forest model
    :param subsamp_rate: Parameter controlling the size of each tree in the forest; samples are selected from a
        Poisson distribution with parameter subsamp_rate (the default value is 1.0)
    :param feature_subset: Parameter that controls the number of feature used as candidates for splitting at each tree node
        as a power of number of features in the dataset;
        by default square root of features (i.e., feature_subset = 0.5) are used at each tree node
    :param impurity: Impurity measure: entropy or Gini (the default)
    :return: Matrix M containing the learned tree, where each column corresponds to a node
        in the learned tree and each row contains the following information:
        M[1,j]: id of node j (in a complete binary tree)
        M[2,j]: tree id to which node j belongs
        M[3,j]: Offset (no. of columns) to left child of j
        M[4,j]: Feature index of the feature that node j looks at if j is an internal node, otherwise 0
        M[5,j]: Type of the feature that node j looks at if j is an internal node: 1 for scale and 2
        for categorical features,
        otherwise the label that leaf node j is supposed to predict
        M[6,j]: 1 if j is an internal node and the feature chosen for j is scale, otherwise the
        size of the subset of values
        stored in rows 7,8,... if j is categorical
        M[7:,j]: Only applicable for internal nodes. Threshold the example's feature value is
        compared to is stored at M[7,j] if the feature chosen for j is scale;
        If the feature chosen for j is categorical rows 7,8,... depict the value subset chosen for j
    :return: Matrix C containing the number of times samples are chosen in each tree of the random forest
    :return: Mappings from scale feature ids to global feature ids
    :return: Mappings from categorical feature ids to global feature ids
    """

    params_dict = {'X': X, 'Y': Y, 'R': R}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(X.sds_context, '')
    vX_1 = Matrix(X.sds_context, '')
    vX_2 = Matrix(X.sds_context, '')
    vX_3 = Matrix(X.sds_context, '')
    output_nodes = [vX_0, vX_1, vX_2, vX_3, ]

    op = MultiReturn(X.sds_context, 'randomForest', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]
    vX_2._unnamed_input_nodes = [op]
    vX_3._unnamed_input_nodes = [op]

    return op
