/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import org.apache.sysds.hops.fedplanner.AFederatedPlanner;
import org.apache.sysds.hops.fedplanner.FederatedPlannerCostbased;
import org.apache.sysds.hops.fedplanner.FederatedPlannerFedAll;
import org.apache.sysds.hops.fedplanner.FederatedPlannerFedHeuristic;

public class FTypes {

    public static enum AlignType {
        FULL,
        ROW,
        COL,
        FULL_T,
        ROW_T,
        COL_T;


        public boolean isTransposed() {
            return this == FULL_T || this == ROW_T || this == COL_T;
        }

        public boolean isFullType() {
            return this == FULL || this == FULL_T;
        }

        public boolean isRowType() {
            return this == ROW || this == ROW_T;
        }

        public boolean isColType() {
            return this == COL || this == COL_T;
        }
    }

    public static enum FType {
        ROW(FPartitioning.ROW, FReplication.NONE),
        COL(FPartitioning.COL, FReplication.NONE),
        FULL(FPartitioning.NONE, FReplication.NONE),
        BROADCAST(FPartitioning.NONE, FReplication.FULL),
        PART(FPartitioning.NONE, FReplication.OVERLAP),
        OTHER(FPartitioning.MIXED, FReplication.NONE);

        private final FPartitioning _partType;
        private final FReplication _repType;

        private FType(FPartitioning ptype, FReplication rtype) {
            this._partType = ptype;
            this._repType = rtype;
        }

        public boolean isRowPartitioned() {
            return this._partType == FPartitioning.ROW || this._partType == FPartitioning.NONE && this._repType != FReplication.OVERLAP;
        }

        public boolean isColPartitioned() {
            return this._partType == FPartitioning.COL || this._partType == FPartitioning.NONE && this._repType != FReplication.OVERLAP;
        }

        public FPartitioning getPartType() {
            return this._partType;
        }

        public boolean isType(FType t) {
            switch (t) {
                case ROW: {
                    return this.isRowPartitioned();
                }
                case COL: {
                    return this.isColPartitioned();
                }
            }
            return t == this;
        }
    }

    public static enum FReplication {
        NONE,
        FULL,
        OVERLAP;

    }

    public static enum FPartitioning {
        ROW,
        COL,
        MIXED,
        NONE;

    }

    public static enum FederatedPlanner {
        NONE,
        RUNTIME,
        COMPILE_FED_ALL,
        COMPILE_FED_HEURISTIC,
        COMPILE_COST_BASED;


        public AFederatedPlanner getPlanner() {
            switch (this) {
                case COMPILE_FED_ALL: {
                    return new FederatedPlannerFedAll();
                }
                case COMPILE_FED_HEURISTIC: {
                    return new FederatedPlannerFedHeuristic();
                }
                case COMPILE_COST_BASED: {
                    return new FederatedPlannerCostbased();
                }
            }
            return null;
        }

        public boolean isCompiled() {
            return this != NONE && this != RUNTIME;
        }

        public static boolean isCompiled(String planner) {
            try {
                return FederatedPlanner.valueOf(planner.toUpperCase()).isCompiled();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }
}

