/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.InputStreamInputFormat;

public class FrameReaderTextCSV
extends FrameReader {
    protected final FileFormatPropertiesCSV _props;

    public FrameReaderTextCSV(FileFormatPropertiesCSV props) {
        this._props = props != null ? props : new FileFormatPropertiesCSV();
    }

    @Override
    public final FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        LOG.debug((Object)"readFrameFromHDFS csv");
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        FrameReaderTextCSV.checkValidInputFile(fs, path);
        if (rlen <= 0L || clen <= 0L) {
            Pair<Integer, Integer> size = this.computeCSVSize(path, job, fs);
            rlen = size.getKey().intValue();
            clen = size.getValue().intValue();
        }
        Types.ValueType[] lschema = FrameReaderTextCSV.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCSV.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCSV.createOutputFrameBlock(lschema, lnames, rlen);
        this.readCSVFrameFromHDFS(path, job, fs, ret, lschema, lnames, rlen, clen);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Types.ValueType[] lschema = FrameReaderTextCSV.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCSV.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCSV.createOutputFrameBlock(lschema, lnames, rlen);
        InputStreamInputFormat informat = new InputStreamInputFormat(is);
        InputSplit split = informat.getSplits(null, 1)[0];
        this.readCSVFrameFromInputSplit(split, informat, null, ret, schema, names, rlen, clen, 0, true);
        return ret;
    }

    protected void readCSVFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        LOG.debug((Object)"readCSVFrameFromHDFS csv");
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int rpos = 0;
        for (int i = 0; i < splits.length; ++i) {
            rpos = this.readCSVFrameFromInputSplit(splits[i], (InputFormat<LongWritable, Text>)informat, job, dest, schema, names, rlen, clen, rpos, i == 0);
        }
    }

    protected final int readCSVFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> informat, JobConf job, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen, int rl, boolean first) throws IOException {
        if ((long)rl > rlen) {
            throw new DMLRuntimeException("Invalid offset");
        }
        boolean hasHeader = this._props.hasHeader();
        boolean isFill = this._props.isFill();
        double dfillValue = this._props.getFillValue();
        String sfillValue = String.valueOf(this._props.getFillValue());
        HashSet<String> naValues = this._props.getNAStrings();
        String delim = this._props.getDelim();
        RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int row = rl;
        int nCol = dest.getNumColumns();
        if (first && hasHeader) {
            reader.next((Object)key, (Object)value);
            dest.setColumnNames(value.toString().split(delim));
        }
        try {
            String[] parts = null;
            while (reader.next((Object)key, (Object)value)) {
                boolean emptyValuesFound = false;
                String cellStr = IOUtilFunctions.trim(value.toString());
                parts = IOUtilFunctions.splitCSV(cellStr, delim, parts);
                boolean mtdP = parts[0].equals("#Meta\u00b7MV");
                boolean mtdx = parts[0].equals("#Meta\u00b7ND");
                if (mtdP || mtdx) {
                    int j;
                    if (parts.length != dest.getNumColumns() + 1) {
                        LOG.warn((Object)"Invalid metadata ");
                        parts = null;
                        continue;
                    }
                    if (mtdP) {
                        for (j = 0; j < dest.getNumColumns(); ++j) {
                            dest.getColumnMetadata(j).setMvValue(parts[j + 1]);
                        }
                    } else if (mtdx) {
                        for (j = 0; j < dest.getNumColumns(); ++j) {
                            dest.getColumnMetadata(j).setNumDistinct(Long.parseLong(parts[j + 1]));
                        }
                    }
                    parts = null;
                    continue;
                }
                this.assignColumns(row, nCol, dest, parts, naValues, isFill, dfillValue, sfillValue);
                IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, isFill, emptyValuesFound);
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns("", cellStr, parts, clen);
                ++row;
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed parsing string: \"" + value + "\"", e);
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
        return row;
    }

    private boolean assignColumns(int row, int nCol, FrameBlock dest, String[] parts, Set<String> naValues, boolean isFill, double dfillValue, String sfillValue) {
        if (!isFill && naValues == null) {
            return this.assignColumnsNoFillNoNan(row, nCol, dest, parts);
        }
        return this.assignColumnsGeneric(row, nCol, dest, parts, naValues, isFill, dfillValue, sfillValue);
    }

    private boolean assignColumnsGeneric(int row, int nCol, FrameBlock dest, String[] parts, Set<String> naValues, boolean isFill, double dfillValue, String sfillValue) {
        boolean emptyValuesFound = false;
        for (int col = 0; col < nCol; ++col) {
            String part = IOUtilFunctions.trim(parts[col]);
            if (part.isEmpty() || naValues != null && naValues.contains(part)) {
                if (isFill && dfillValue != 0.0) {
                    dest.set(row, col, sfillValue);
                }
                emptyValuesFound = true;
                continue;
            }
            dest.set(row, col, part);
        }
        return emptyValuesFound;
    }

    private boolean assignColumnsNoFillNoNan(int row, int nCol, FrameBlock dest, String[] parts) {
        boolean emptyValuesFound = false;
        for (int col = 0; col < nCol; ++col) {
            String part = IOUtilFunctions.trim(parts[col]);
            if (part.isEmpty()) {
                emptyValuesFound = true;
                continue;
            }
            dest.set(row, col, part);
        }
        return emptyValuesFound;
    }

    protected Pair<Integer, Integer> computeCSVSize(Path path, JobConf job, FileSystem fs) throws IOException {
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int ncol = IOUtilFunctions.countNumColumnsCSV(splits, (InputFormat)informat, job, this._props.getDelim());
        int nrow = 0;
        for (int i = 0; i < splits.length; ++i) {
            boolean header = i == 0 && this._props.hasHeader();
            nrow += FrameReaderTextCSV.countLinesInReader(splits[i], informat, job, ncol, header);
        }
        return new Pair<Integer, Integer>(nrow, ncol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int countLinesInReader(InputSplit split, TextInputFormat inFormat, JobConf job, long ncol, boolean header) throws IOException {
        RecordReader reader = inFormat.getRecordReader(split, job, Reporter.NULL);
        try {
            int n = FrameReaderTextCSV.countLinesInReader((RecordReader<LongWritable, Text>)reader, ncol, header);
            return n;
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int countLinesInReader(RecordReader<LongWritable, Text> reader, long ncol, boolean header) throws IOException {
        LongWritable key = new LongWritable();
        Text value = new Text();
        int nrow = 0;
        try {
            if (header) {
                reader.next((Object)key, (Object)value);
            }
            while (reader.next((Object)key, (Object)value)) {
                nrow += FrameReaderTextCSV.containsMetaTag(value) ? 0 : 1;
            }
            int n = nrow;
            return n;
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
    }

    private static final boolean containsMetaTag(Text val) {
        if (val.charAt(0) == 35) {
            return val.find("#Meta\u00b7MV") > -1 || val.find("#Meta\u00b7ND") > -1;
        }
        return false;
    }
}

