/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.parser.xml.AttributeDependantMetadataHandler;
import org.apache.tika.parser.xml.AttributeMetadataHandler;
import org.apache.tika.parser.xml.ElementMetadataHandler;
import org.apache.tika.parser.xml.MetadataHandler;
import org.apache.tika.parser.xml.XMLParser;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OpenDocumentMetaParser
extends XMLParser {
    public static final String ODF_VERSION_KEY = "odf:version";
    private static final long serialVersionUID = -8739250869531737584L;
    private static final String META_NS = "urn:oasis:names:tc:opendocument:xmlns:meta:1.0";
    private static final String OFFICE_NS = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    private static final XPathParser META_XPATH = new XPathParser("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
    private static final XPathParser OFFICE_XPATH = new XPathParser("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");

    private static ContentHandler getDublinCoreHandler(Metadata metadata, Property property, String element) {
        return new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", element, metadata, property);
    }

    private static ContentHandler getMeta(ContentHandler ch, Metadata md, Property property, String element) {
        CompositeMatcher matcher = new CompositeMatcher(META_XPATH.parse("//meta:" + element), META_XPATH.parse("//meta:" + element + "//text()"));
        MatchingContentHandler branch = new MatchingContentHandler(new MetadataHandler(md, property), matcher);
        return new TeeContentHandler(ch, branch);
    }

    private static ContentHandler getUserDefined(ContentHandler ch, Metadata md) {
        CompositeMatcher matcher = new CompositeMatcher(META_XPATH.parse("//meta:user-defined/@meta:name"), META_XPATH.parse("//meta:user-defined//text()"));
        MatchingContentHandler branch = new MatchingContentHandler(new AttributeDependantMetadataHandler(md, "meta:name", "custom:"), matcher);
        return new TeeContentHandler(ch, branch);
    }

    private static ContentHandler getVersion(ContentHandler ch, Metadata md) {
        Matcher matcher = OFFICE_XPATH.parse("/office:document-meta/@office:version");
        MatchingContentHandler branch = new MatchingContentHandler(new AttributeMetadataHandler(OFFICE_NS, "version", md, ODF_VERSION_KEY), matcher);
        return new TeeContentHandler(ch, branch);
    }

    @Deprecated
    private static ContentHandler getStatistic(ContentHandler ch, Metadata md, String name, String attribute) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + attribute);
        MatchingContentHandler branch = new MatchingContentHandler(new AttributeMetadataHandler(META_NS, attribute, md, name), matcher);
        return new TeeContentHandler(ch, branch);
    }

    private static ContentHandler getStatistic(ContentHandler ch, Metadata md, Property property, String attribute) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + attribute);
        MatchingContentHandler branch = new MatchingContentHandler(new AttributeMetadataHandler(META_NS, attribute, md, property), matcher);
        return new TeeContentHandler(ch, branch);
    }

    static ContentHandler getContentHandler(Metadata md, ParseContext context, ContentHandler ... handlers) {
        ContentHandler ch = new TeeContentHandler(OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.TITLE, "title"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.CREATOR, "creator"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.DESCRIPTION, "description"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.PUBLISHER, "publisher"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.CONTRIBUTOR, "contributor"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.TYPE, "type"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.FORMAT, "format"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.IDENTIFIER, "identifier"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.LANGUAGE, "language"), OpenDocumentMetaParser.getDublinCoreHandler(md, TikaCoreProperties.RIGHTS, "rights"));
        ch = OpenDocumentMetaParser.getVersion(ch, md);
        ch = OpenDocumentMetaParser.getMeta(ch, md, TikaCoreProperties.CREATED, "creation-date");
        ch = new TeeContentHandler(ch, new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", "date", md, TikaCoreProperties.MODIFIED));
        ch = new TeeContentHandler(ch, new ElementMetadataHandler("http://purl.org/dc/elements/1.1/", "subject", md, OfficeOpenXMLCore.SUBJECT));
        ch = OpenDocumentMetaParser.getMeta(ch, md, Office.KEYWORDS, "keyword");
        ch = OpenDocumentMetaParser.getMeta(ch, md, OfficeOpenXMLExtended.TOTAL_TIME, "editing-duration");
        ch = OpenDocumentMetaParser.getMeta(ch, md, Property.externalText("editing-cycles"), "editing-cycles");
        ch = OpenDocumentMetaParser.getMeta(ch, md, TikaCoreProperties.CREATOR, "initial-creator");
        ch = OpenDocumentMetaParser.getMeta(ch, md, Property.externalText("generator"), "generator");
        ch = OpenDocumentMetaParser.getUserDefined(ch, md);
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.OBJECT_COUNT, "object-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.IMAGE_COUNT, "image-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.PAGE_COUNT, "page-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, PagedText.N_PAGES, "page-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.TABLE_COUNT, "table-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.PARAGRAPH_COUNT, "paragraph-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.WORD_COUNT, "word-count");
        ch = OpenDocumentMetaParser.getStatistic(ch, md, Office.CHARACTER_COUNT, "character-count");
        if (handlers != null && handlers.length > 0) {
            ContentHandler[] newHandlers = new ContentHandler[handlers.length + 1];
            newHandlers[0] = ch;
            System.arraycopy(handlers, 0, newHandlers, 1, handlers.length);
            ch = new TeeContentHandler(newHandlers);
        }
        ch = new NSNormalizerContentHandler(ch);
        return ch;
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler ch, Metadata md, ParseContext context) {
        return OpenDocumentMetaParser.getContentHandler(md, context, super.getContentHandler(ch, md, context));
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        super.parse(stream, handler, metadata, context);
        String odfSubject = metadata.get(OfficeOpenXMLCore.SUBJECT);
        if (odfSubject != null && !odfSubject.equals("") && (metadata.get(TikaCoreProperties.DESCRIPTION) == null || metadata.get(TikaCoreProperties.DESCRIPTION).equals(""))) {
            metadata.set(TikaCoreProperties.DESCRIPTION, odfSubject);
        }
        ArrayList<String> subjects = new ArrayList<String>();
        if (metadata.getValues(Office.KEYWORDS) != null) {
            subjects.addAll(Arrays.asList(metadata.getValues(Office.KEYWORDS)));
        }
        if (metadata.getValues(OfficeOpenXMLCore.SUBJECT) != null) {
            subjects.addAll(Arrays.asList(metadata.getValues(OfficeOpenXMLCore.SUBJECT)));
        }
        if (subjects.size() > 0) {
            metadata.set(TikaCoreProperties.SUBJECT, subjects.toArray(new String[0]));
        }
    }
}

