/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.function.UnaryOperator;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;

final class WraparoundInEnvelope
extends WraparoundTransform {
    private static final long serialVersionUID = 4017870982753327584L;
    private double limit;
    private double minCycles;
    private double maxCycles;
    private boolean minChanged;
    private boolean maxChanged;

    private WraparoundInEnvelope(WraparoundTransform other) {
        super(other);
        this.maxCycles = this.limit = Math.rint(this.sourceMedian / this.period);
        this.minCycles = this.limit;
    }

    @Override
    protected final double shift(double x) {
        double n = Math.rint(x / this.period);
        if (x < this.sourceMedian) {
            if (n < this.limit) {
                if (n < this.minCycles) {
                    this.minCycles = n;
                    this.minChanged = true;
                }
                n = this.limit;
            }
        } else if (n > this.limit) {
            if (n > this.maxCycles) {
                this.maxCycles = n;
                this.maxChanged = true;
            }
            n = this.limit;
        }
        return x - n * this.period;
    }

    private boolean translate() {
        if (this.minChanged) {
            this.minChanged = false;
            this.limit = this.minCycles;
            return true;
        }
        if (this.maxChanged) {
            this.maxChanged = false;
            this.limit = this.maxCycles;
            return true;
        }
        return false;
    }

    static final class Controller
    implements UnaryOperator<WraparoundTransform> {
        final MathTransform transform;
        private WraparoundInEnvelope[] wraparounds;

        Controller(MathTransform transform) {
            this.transform = WraparoundTransform.replace(transform, this);
        }

        @Override
        public WraparoundTransform apply(WraparoundTransform transform) {
            if (!Double.isFinite(transform.sourceMedian)) {
                return transform;
            }
            WraparoundInEnvelope w = new WraparoundInEnvelope(transform);
            this.wraparounds = this.wraparounds == null ? new WraparoundInEnvelope[]{w} : ArraysExt.append(this.wraparounds, w);
            return w;
        }

        final boolean translate() {
            boolean modified = false;
            if (this.wraparounds != null) {
                for (WraparoundInEnvelope tr : this.wraparounds) {
                    modified |= tr.translate();
                }
            }
            return modified;
        }
    }
}

