/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.testing.evaluator.ICasEvaluator;
import org.apache.uima.ruta.testing.ui.views.TestCasData;
import org.apache.uima.ruta.testing.ui.views.TestPageBookView;
import org.apache.uima.ruta.testing.ui.views.TestViewPage;
import org.apache.uima.ruta.testing.ui.views.evalDataTable.TypeEvalData;
import org.apache.uima.ruta.testing.ui.views.util.EvalDataProcessor;
import org.apache.uima.ruta.type.EvalAnnotation;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xml.sax.SAXException;

public class RerunActionHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TestPageBookView debugView = (TestPageBookView)HandlerUtil.getActivePart((ExecutionEvent)event);
        TestViewPage debugPage = (TestViewPage)debugView.getCurrentPage();
        String viewCasName = debugPage.getSelectedViewCasName();
        String scriptName = debugPage.getResource().getLocation().lastSegment();
        RerunHandlerJob job = new RerunHandlerJob(event, scriptName, viewCasName, debugPage.getExcludedTypes(), debugPage.getIncludedTypes());
        job.addJobChangeListener((IJobChangeListener)new DebugJobChangeAdapter(debugPage){});
        job.schedule();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmi(CAS aCas, File name) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            name.getParentFile().mkdirs();
            if (!name.exists()) {
                name.createNewFile();
            }
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        catch (Exception e) {
            RutaAddonsPlugin.error(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void calculateEvaluatData(TestCasData data, CAS resultCas) {
        TypeEvalData newData;
        int oldCount;
        TypeEvalData element;
        Type originalType;
        Annotation original;
        EvalAnnotation a;
        data.setEvaluationStatus(true);
        TypeSystem ts = resultCas.getTypeSystem();
        Type falsePositiveType = ts.getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = ts.getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositiveType = ts.getType("org.apache.uima.ruta.type.TruePositive");
        int falsePositiveCount = resultCas.getAnnotationIndex(falsePositiveType).size();
        int falseNegativeCount = resultCas.getAnnotationIndex(falseNegativeType).size();
        int truePositiveCount = resultCas.getAnnotationIndex(truePositiveType).size();
        data.setTruePositiveCount(truePositiveCount);
        data.setFalsePositiveCount(falsePositiveCount);
        data.setFalseNegativeCount(falseNegativeCount);
        HashMap<String, TypeEvalData> map = new HashMap<String, TypeEvalData>();
        AnnotationIndex index = resultCas.getAnnotationIndex(truePositiveType);
        FSIterator iter = index.iterator();
        while (iter.isValid()) {
            a = (EvalAnnotation)iter.next();
            original = a.getOriginal();
            originalType = original.getType();
            if (map.containsKey(originalType.getName())) {
                element = (TypeEvalData)map.get(originalType.getName());
                oldCount = element.getTruePositives();
                element.setTruePositives(oldCount + 1);
                continue;
            }
            newData = new TypeEvalData(originalType.getName(), 1, 0, 0);
            map.put(originalType.getName(), newData);
        }
        index = resultCas.getAnnotationIndex(falsePositiveType);
        iter = index.iterator();
        while (iter.isValid()) {
            a = (EvalAnnotation)iter.next();
            original = a.getOriginal();
            originalType = original.getType();
            if (map.containsKey(originalType.getName())) {
                element = (TypeEvalData)map.get(originalType.getName());
                oldCount = element.getFalsePositives();
                element.setFalsePositives(oldCount + 1);
                continue;
            }
            newData = new TypeEvalData(originalType.getName(), 0, 1, 0);
            map.put(originalType.getName(), newData);
        }
        index = resultCas.getAnnotationIndex(falseNegativeType);
        iter = index.iterator();
        while (iter.isValid()) {
            a = (EvalAnnotation)iter.next();
            original = a.getOriginal();
            originalType = original.getType();
            if (map.containsKey(originalType.getName())) {
                element = (TypeEvalData)map.get(originalType.getName());
                oldCount = element.getFalseNegatives();
                element.setFalseNegatives(oldCount + 1);
                continue;
            }
            newData = new TypeEvalData(originalType.getName(), 0, 0, 1);
            map.put(originalType.getName(), newData);
        }
        data.setTypeEvalData(map);
    }

    private class DebugJobChangeAdapter
    extends JobChangeAdapter {
        private TestViewPage page;

        DebugJobChangeAdapter(TestViewPage page) {
            this.page = page;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                this.page.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        DebugJobChangeAdapter.this.page.updateInfoPanel();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RerunHandlerJob
    extends Job {
        ExecutionEvent event;
        private final String viewCasName;
        private List<String> excludedTypes;
        private List<String> includedTypes;

        RerunHandlerJob(ExecutionEvent event, String scriptName, String viewCasName, List<String> excludedTypes, List<String> includedTypes) {
            super("Testing " + scriptName + "...");
            this.event = event;
            this.viewCasName = viewCasName;
            this.excludedTypes = excludedTypes;
            this.includedTypes = includedTypes;
            this.setUser(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            TestPageBookView debugView = (TestPageBookView)HandlerUtil.getActivePart((ExecutionEvent)this.event);
            final TestViewPage debugPage = (TestViewPage)debugView.getCurrentPage();
            debugPage.saveState();
            debugView.showBusy(true);
            IResource r = debugPage.getResource();
            ArrayList testCasData = (ArrayList)debugPage.getViewer().getInput();
            monitor.beginTask("Running evaluation, please wait", testCasData.size());
            IProject project = r.getProject();
            IPath engineDescriptorPath = RutaProjectUtils.getEngineDescriptorPath((IPath)r.getLocation(), (IProject)project);
            try {
                XMLInputSource in = new XMLInputSource(engineDescriptorPath.toPortableString());
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
                AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
                String desc = null;
                desc = engineDescriptorPath.toPortableString();
                XMLInputSource in2 = new XMLInputSource(desc);
                XMLizable descriptor = UIMAFramework.getXMLParser().parse(in2);
                CAS runCas = this.getEmptyCas(descriptor);
                CAS testCas = this.getEmptyCas(descriptor);
                for (TestCasData td : testCasData) {
                    AnnotationIndex annotationIndex;
                    runCas.reset();
                    testCas.reset();
                    String elementName = r.getLocation().lastSegment();
                    monitor.setTaskName("Evaluating " + td.getPath().lastSegment());
                    int lastIndexOf = elementName.lastIndexOf(".ruta");
                    if (lastIndexOf != -1) {
                        elementName = elementName.substring(0, lastIndexOf);
                    }
                    FileInputStream inputStreamTest = null;
                    try {
                        inputStreamTest = new FileInputStream(new File(td.getPath().toPortableString()));
                        XmiCasDeserializer.deserialize((InputStream)inputStreamTest, (CAS)testCas, (boolean)true);
                    }
                    finally {
                        if (inputStreamTest != null) {
                            inputStreamTest.close();
                        }
                    }
                    FileInputStream inputStreamRun = null;
                    try {
                        inputStreamRun = new FileInputStream(new File(td.getPath().toPortableString()));
                        XmiCasDeserializer.deserialize((InputStream)inputStreamRun, (CAS)runCas, (boolean)true);
                    }
                    finally {
                        if (inputStreamRun != null) {
                            inputStreamRun.close();
                        }
                    }
                    testCas = testCas.getView(this.viewCasName);
                    runCas = runCas.getView(this.viewCasName);
                    if (this.includedTypes != null && !this.includedTypes.isEmpty()) {
                        this.excludedTypes = new ArrayList<String>();
                        List types = runCas.getTypeSystem().getProperlySubsumedTypes(runCas.getAnnotationType());
                        for (Type type : types) {
                            if (this.includedTypes.contains(type.getName())) continue;
                            this.excludedTypes.add(type.getName());
                        }
                    }
                    LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
                    if (this.excludedTypes != null && !this.excludedTypes.isEmpty()) {
                        annotationIndex = runCas.getAnnotationIndex();
                        for (AnnotationFS annotationFS : annotationIndex) {
                            Type type = annotationFS.getType();
                            String typeName = type.getName();
                            if (!this.includedTypes.contains(typeName) && this.excludedTypes.contains(typeName) || type == null || !runCas.getTypeSystem().subsumes(runCas.getAnnotationType(), type)) continue;
                            toRemove.add(annotationFS);
                        }
                    }
                    if (this.excludedTypes != null && this.excludedTypes.isEmpty() && this.includedTypes != null && this.includedTypes.isEmpty()) {
                        annotationIndex = runCas.getAnnotationIndex();
                        for (AnnotationFS each : annotationIndex) {
                            toRemove.add(each);
                        }
                    }
                    for (AnnotationFS each : toRemove) {
                        if (runCas.getDocumentAnnotation().equals(each)) continue;
                        runCas.removeFsFromIndexes((FeatureStructure)each);
                    }
                    IPreferenceStore store = RutaAddonsPlugin.getDefault().getPreferenceStore();
                    String factoryName = store.getString("EVALUATOR_FACTORY");
                    ICasEvaluator evaluator = RutaAddonsPlugin.getCasEvaluatorFactoryById(factoryName).createEvaluator();
                    ae.process(runCas);
                    CAS resultCas = evaluator.evaluate(testCas, runCas, this.excludedTypes);
                    IPath path2Test = td.getPath().removeLastSegments(1);
                    IPath estimatedTestPath = project.getFullPath().append(RutaProjectUtils.getDefaultTestLocation());
                    IPath path2recource = r.getFullPath();
                    IPath projectRelativePath2Script = path2recource.removeFirstSegments(2);
                    IPath estimatedTestFolderPath = estimatedTestPath.append(projectRelativePath2Script.removeFileExtension());
                    IPath path2Result = path2Test.append("results");
                    IPath path2ResultFile = path2Result.append(td.getPath().removeFileExtension().lastSegment() + ".result.xmi");
                    if (!path2Test.toOSString().contains(estimatedTestFolderPath.toOSString())) {
                        path2Result = project.getLocation().append(RutaProjectUtils.getDefaultTestLocation()).append(RutaProjectUtils.getDefaultTempTestLocation());
                        path2ResultFile = path2Result.append(td.getPath().removeFileExtension().lastSegment() + ".result.xmi");
                    }
                    File resultFile = new File(path2ResultFile.toPortableString());
                    RerunActionHandler.writeXmi(resultCas, resultFile);
                    td.setResultPath(path2ResultFile);
                    EvalDataProcessor.calculateEvaluatData(td, resultCas);
                    debugView.getDefaultPage().getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            debugPage.getViewer().refresh();
                        }
                    });
                    monitor.worked(1);
                    r.getProject().getFolder(path2Result).refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    runCas.release();
                    testCas.release();
                    resultCas.release();
                    ae.destroy();
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                RutaAddonsPlugin.error(e);
            }
            monitor.done();
            debugView.showBusy(false);
            return Status.OK_STATUS;
        }

        private CAS getEmptyCas(Object descriptor) throws ResourceInitializationException, InvalidXMLException {
            CAS testCas = null;
            if (descriptor instanceof AnalysisEngineDescription) {
                testCas = CasCreationUtils.createCas((AnalysisEngineDescription)((AnalysisEngineDescription)descriptor));
            } else if (descriptor instanceof TypeSystemDescription) {
                TypeSystemDescription tsDesc = (TypeSystemDescription)descriptor;
                tsDesc.resolveImports();
                testCas = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]);
            }
            return testCas;
        }
    }
}

