/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.xml.sax.Locator;

public class TemplatesHandlerImpl
extends ReceivingContentHandler
implements TemplatesHandler {
    private TreeBuilder builder;
    private StyleNodeFactory nodeFactory;
    private Templates templates;
    private String systemId;

    protected TemplatesHandlerImpl(Configuration configuration) {
        this.setPipelineConfiguration(configuration.makePipelineConfiguration());
        this.nodeFactory = new StyleNodeFactory(configuration, this.getPipelineConfiguration().getErrorListener());
        this.builder = new TreeBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        this.builder.setNodeFactory(this.nodeFactory);
        this.builder.setLineNumbering(true);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        UseWhenFilter useWhenFilter = new UseWhenFilter(startTagBuffer);
        useWhenFilter.setUnderlyingReceiver(this.builder);
        useWhenFilter.setPipelineConfiguration(this.getPipelineConfiguration());
        startTagBuffer.setUnderlyingReceiver(useWhenFilter);
        startTagBuffer.setPipelineConfiguration(this.getPipelineConfiguration());
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(configuration.getNamePool());
        stylesheetStripper.setUnderlyingReceiver(startTagBuffer);
        stylesheetStripper.setPipelineConfiguration(this.getPipelineConfiguration());
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(stylesheetStripper);
        commentStripper.setPipelineConfiguration(this.getPipelineConfiguration());
        this.setReceiver(commentStripper);
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl documentImpl = (DocumentImpl)this.builder.getCurrentRoot();
            if (documentImpl == null) {
                return null;
            }
            Configuration configuration = this.getConfiguration();
            CompilerInfo compilerInfo = new CompilerInfo();
            compilerInfo.setURIResolver(configuration.getURIResolver());
            compilerInfo.setErrorListener(configuration.getErrorListener());
            PreparedStylesheet preparedStylesheet = new PreparedStylesheet(configuration, compilerInfo);
            try {
                preparedStylesheet.setStylesheetDocument(documentImpl, this.nodeFactory);
                this.templates = preparedStylesheet;
            }
            catch (XPathException xPathException) {
                throw new UnsupportedOperationException(xPathException.getMessage());
            }
        }
        return this.templates;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.setSystemId(locator.getSystemId());
    }

    public String getSystemId() {
        return this.systemId;
    }
}

