/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public class UnparsedEntity
extends SystemFunction
implements XSLTFunction {
    public static int URI = 0;
    public static int PUBLIC_ID = 1;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        UnparsedEntity unparsedEntity = (UnparsedEntity)super.simplify(staticContext);
        unparsedEntity.addContextDocumentArgument(1, this.operation == URI ? "unparsed-entity-uri_9999_" : "unparsed-entity-public-id_9999_");
        return unparsedEntity;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        try {
            return super.typeCheck(staticContext, itemType);
        }
        catch (XPathException xPathException) {
            if ("XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                if (this.operation == URI) {
                    DynamicError dynamicError = new DynamicError("Cannot call the unparsed-entity-uri() function when there is no context node");
                    dynamicError.setErrorCode("XTDE1370");
                    throw dynamicError;
                }
                DynamicError dynamicError = new DynamicError("Cannot call the unparsed-entity-public-id() function when there is no context node");
                dynamicError.setErrorCode("XTDE1380");
                throw dynamicError;
            }
            throw xPathException;
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        NodeInfo nodeInfo;
        String string;
        block7: {
            string = this.argument[0].evaluateItem(xPathContext).getStringValue();
            nodeInfo = null;
            try {
                nodeInfo = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
            }
            catch (XPathException xPathException) {
                if ("XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                    if (this.operation == URI) {
                        DynamicError dynamicError = new DynamicError("Cannot call the unparsed-entity-uri() function when there is no context node");
                        dynamicError.setErrorCode("XTDE1370");
                        throw dynamicError;
                    }
                    DynamicError dynamicError = new DynamicError("Cannot call the unparsed-entity-public-id() function when there is no context node");
                    dynamicError.setErrorCode("XTDE1380");
                    throw dynamicError;
                }
                if (!"XPDY0050".equals(xPathException.getErrorCodeLocalPart())) break block7;
                if (this.operation == URI) {
                    DynamicError dynamicError = new DynamicError("Can only call the unparsed-entity-uri() function when the context node is in a tree rooted at a document node");
                    dynamicError.setErrorCode("XTDE1370");
                    throw dynamicError;
                }
                DynamicError dynamicError = new DynamicError("Can only call the unparsed-entity-public-id() function when the context node is in a tree rooted at a document node");
                dynamicError.setErrorCode("XTDE1380");
                throw dynamicError;
            }
        }
        if (nodeInfo.getNodeKind() != 9) {
            object = this.operation == URI ? "XTDE1370" : "XTDE1380";
            this.dynamicError("In function " + this.getDisplayName(xPathContext.getNamePool()) + ", the context node must be in a tree whose root is a document node", (String)object, xPathContext);
        }
        if ((object = ((DocumentInfo)nodeInfo).getUnparsedEntity(string)) == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(object[this.operation]);
    }
}

